/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.network;

import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.network.Endpoint;
import io.mantisrx.common.network.WritableEndpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RoundRobinRouter<T> {
    private Map<String, WritableEndpoint<T>> endpoints = new HashMap<String, WritableEndpoint<T>>();
    private List<String> idList = new ArrayList<String>();
    private int currentListSize;
    private int count;
    private Metrics metrics = new Metrics.Builder().name("RoundRobin").addGauge("activeConnections").build();
    private Gauge activeConnections = this.metrics.getGauge("activeConnections");

    public Metrics getMetrics() {
        return this.metrics;
    }

    public synchronized boolean add(WritableEndpoint<T> endpoint) {
        String id = Endpoint.uniqueHost(endpoint.getHost(), endpoint.getPort(), endpoint.getSlotId());
        boolean added = false;
        if (!this.endpoints.containsKey(id)) {
            this.endpoints.put(id, endpoint);
            this.idList.add(id);
            ++this.currentListSize;
            added = true;
        }
        this.activeConnections.set(this.endpoints.size());
        return added;
    }

    public synchronized boolean remove(WritableEndpoint<T> endpoint) {
        String id = Endpoint.uniqueHost(endpoint.getHost(), endpoint.getPort(), endpoint.getSlotId());
        boolean removed = false;
        if (this.endpoints.containsKey(id)) {
            this.endpoints.remove(id);
            this.idList.remove(id);
            --this.currentListSize;
            removed = true;
        }
        this.activeConnections.set(this.endpoints.size());
        return removed;
    }

    public synchronized WritableEndpoint<T> nextSlot() {
        return this.endpoints.get(this.idList.get((this.count++ & Integer.MAX_VALUE) % this.currentListSize));
    }

    public synchronized void completeAllEndpoints() {
        for (WritableEndpoint<T> endpoint : this.endpoints.values()) {
            endpoint.complete();
        }
    }

    public synchronized boolean isEmpty() {
        return this.endpoints.isEmpty();
    }

    public synchronized void errorAllEndpoints(Throwable e) {
        for (WritableEndpoint<T> endpoint : this.endpoints.values()) {
            endpoint.error(e);
        }
    }
}

