/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.codec;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.mantisrx.common.codec.Codec;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JacksonCodecs {
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new CBORFactory());

    public static <T> Codec<T> pojo(final Class<T> clazz) {
        return new Codec<T>(){

            @Override
            public byte[] encode(T value) {
                try {
                    return mapper.writeValueAsBytes(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to write bytes for value: " + value, e);
                }
            }

            @Override
            public T decode(byte[] bytes) {
                try {
                    return mapper.readValue(bytes, clazz);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to convert to type: " + clazz.toString(), e);
                }
            }
        };
    }

    public static <T> Codec<List<T>> list() {
        return new Codec<List<T>>(){

            @Override
            public byte[] encode(List<T> value) {
                try {
                    return mapper.writeValueAsBytes(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to write list to bytes", e);
                }
            }

            @Override
            public List<T> decode(byte[] bytes) {
                try {
                    return (List)mapper.readValue(bytes, new TypeReference<List<T>>(){});
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to convert bytes to list", e);
                }
            }
        };
    }

    public static Codec<Map<String, Object>> mapStringObject() {
        return new Codec<Map<String, Object>>(){
            private final ObjectReader reader = JacksonCodecs.access$000().readerFor(Map.class);

            @Override
            public byte[] encode(Map<String, Object> map) {
                try {
                    return mapper.writeValueAsBytes(map);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to write bytes for map: " + map, e);
                }
            }

            @Override
            public Map<String, Object> decode(byte[] bytes) {
                try {
                    return (Map)this.reader.readValue(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to convert bytes to map", e);
                }
            }
        };
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new AfterburnerModule());
    }
}

