/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.network;

import io.mantisrx.common.network.HashFunction;
import io.mantisrx.common.network.NodeConfiguration;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T> {
    private final HashFunction hashAlgo;
    private final NodeConfiguration<T> nodeConfig;
    private final SortedMap<Long, T> ring = new TreeMap<Long, T>();

    public ConsistentHash(HashFunction hashAlgo, NodeConfiguration<T> nodeConfig, Collection<T> nodes) {
        if (hashAlgo == null || nodeConfig == null || nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("Constructor args to ConsistentHash should be non null and the collection of nodes should be non empty");
        }
        this.hashAlgo = hashAlgo;
        this.nodeConfig = nodeConfig;
        for (T node : nodes) {
            this.add(node);
        }
    }

    private void add(T node) {
        int numReps = this.nodeConfig.getNodeRepetitions();
        if (numReps < 0) {
            throw new IllegalArgumentException("Number of repetitions of a node should be positive");
        }
        for (int i = 0; i < numReps; ++i) {
            this.putInRing((Long)this.hashAlgo.call(this.nodeConfig.getKeyForNode(node, i)), node);
        }
    }

    void putInRing(Long hash, T node) {
        if (this.ring.containsKey(hash)) {
            // empty if block
        }
        this.ring.put(hash, node);
    }

    public T get(byte[] keyBytes) {
        Long hash = (Long)this.hashAlgo.call(keyBytes);
        if (!this.ring.containsKey(hash)) {
            SortedMap<Long, T> tailMap = this.ring.tailMap(hash);
            hash = tailMap.isEmpty() ? this.ring.firstKey() : tailMap.firstKey();
        }
        return (T)this.ring.get(hash);
    }

    SortedMap<Long, T> getRing() {
        return this.ring;
    }

    HashFunction getHashAlgo() {
        return this.hashAlgo;
    }
}

