/*
 * Decompiled with CFR 0.152.
 */
package io.reactivx.mantis.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;
import rx.subscriptions.SerialSubscription;

public final class OnSubscribeRedo<T>
implements Observable.OnSubscribe<T> {
    static final Func1<Observable<? extends Notification<?>>, Observable<?>> REDO_INIFINITE = new Func1<Observable<? extends Notification<?>>, Observable<?>>(){

        public Observable<?> call(Observable<? extends Notification<?>> ts) {
            return ts.map(new Func1<Notification<?>, Notification<?>>(){

                public Notification<?> call(Notification<?> terminal) {
                    return Notification.createOnNext(null);
                }
            });
        }
    };
    private final Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> controlHandlerFunction;
    private final Scheduler scheduler;
    private Observable<T> source;
    private boolean stopOnComplete;
    private boolean stopOnError;

    public OnSubscribeRedo(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> f, boolean stopOnComplete, boolean stopOnError, Scheduler scheduler) {
        this.source = source;
        this.controlHandlerFunction = f;
        this.stopOnComplete = stopOnComplete;
        this.stopOnError = stopOnError;
        this.scheduler = scheduler;
    }

    public static <T> Observable<T> retry(Observable<T> source) {
        return OnSubscribeRedo.retry(source, REDO_INIFINITE);
    }

    public static <T> Observable<T> retry(Observable<T> source, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 expected");
        }
        if (count == 0L) {
            return source;
        }
        return OnSubscribeRedo.retry(source, new RedoFinite(count));
    }

    public static <T> Observable<T> retry(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, true, false, Schedulers.trampoline()));
    }

    public static <T> Observable<T> retry(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, true, false, scheduler));
    }

    public static <T> Observable<T> repeat(Observable<T> source) {
        return OnSubscribeRedo.repeat(source, Schedulers.trampoline());
    }

    public static <T> Observable<T> repeat(Observable<T> source, Scheduler scheduler) {
        return OnSubscribeRedo.repeat(source, REDO_INIFINITE, scheduler);
    }

    public static <T> Observable<T> repeat(Observable<T> source, long count) {
        return OnSubscribeRedo.repeat(source, count, Schedulers.trampoline());
    }

    public static <T> Observable<T> repeat(Observable<T> source, long count, Scheduler scheduler) {
        if (count == 0L) {
            return Observable.empty();
        }
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 expected");
        }
        return OnSubscribeRedo.repeat(source, new RedoFinite(count - 1L), scheduler);
    }

    public static <T> Observable<T> repeat(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, false, true, Schedulers.trampoline()));
    }

    public static <T> Observable<T> repeat(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, false, true, scheduler));
    }

    public static <T> Observable<T> redo(Observable<T> source, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.create(new OnSubscribeRedo<T>(source, notificationHandler, false, false, scheduler));
    }

    public void call(final Subscriber<? super T> child) {
        final AtomicBoolean isLocked = new AtomicBoolean(true);
        final AtomicBoolean resumeBoundary = new AtomicBoolean(true);
        final AtomicLong consumerCapacity = new AtomicLong(0L);
        final AtomicReference currentProducer = new AtomicReference();
        final Scheduler.Worker worker = this.scheduler.createWorker();
        child.add((Subscription)worker);
        final SerialSubscription sourceSubscriptions = new SerialSubscription();
        child.add((Subscription)sourceSubscriptions);
        final PublishSubject terminals = PublishSubject.create();
        final Action0 subscribeToSource = new Action0(){

            public void call() {
                if (child.isUnsubscribed()) {
                    return;
                }
                Subscriber terminalDelegatingSubscriber = new Subscriber<T>(){

                    public void onCompleted() {
                        this.unsubscribe();
                        terminals.onNext((Object)Notification.createOnCompleted());
                    }

                    public void onError(Throwable e) {
                        this.unsubscribe();
                        terminals.onNext((Object)Notification.createOnError((Throwable)e));
                    }

                    public void onNext(T v) {
                        consumerCapacity.decrementAndGet();
                        child.onNext(v);
                    }

                    public void setProducer(Producer producer) {
                        currentProducer.set(producer);
                        producer.request(consumerCapacity.get());
                    }
                };
                sourceSubscriptions.set((Subscription)terminalDelegatingSubscriber);
                OnSubscribeRedo.this.source.unsafeSubscribe(terminalDelegatingSubscriber);
            }
        };
        final Observable restarts = (Observable)this.controlHandlerFunction.call((Object)terminals.lift(new Observable.Operator<Notification<?>, Notification<?>>(){

            public Subscriber<? super Notification<?>> call(final Subscriber<? super Notification<?>> filteredTerminals) {
                return new Subscriber<Notification<?>>(filteredTerminals){

                    public void onCompleted() {
                        filteredTerminals.onCompleted();
                    }

                    public void onError(Throwable e) {
                        filteredTerminals.onError(e);
                    }

                    public void onNext(Notification<?> t) {
                        if (t.isOnCompleted() && OnSubscribeRedo.this.stopOnComplete) {
                            child.onCompleted();
                        } else if (t.isOnError() && OnSubscribeRedo.this.stopOnError) {
                            child.onError(t.getThrowable());
                        } else {
                            isLocked.set(false);
                            filteredTerminals.onNext(t);
                        }
                    }

                    public void setProducer(Producer producer) {
                        producer.request(Long.MAX_VALUE);
                    }
                };
            }
        }));
        worker.schedule(new Action0(){

            public void call() {
                restarts.unsafeSubscribe((Subscriber)new Subscriber<Object>(child){

                    public void onCompleted() {
                        child.onCompleted();
                    }

                    public void onError(Throwable e) {
                        child.onError(e);
                    }

                    public void onNext(Object t) {
                        if (!isLocked.get() && !child.isUnsubscribed()) {
                            if (consumerCapacity.get() > 0L) {
                                worker.schedule(subscribeToSource);
                            } else {
                                resumeBoundary.compareAndSet(false, true);
                            }
                        }
                    }

                    public void setProducer(Producer producer) {
                        producer.request(Long.MAX_VALUE);
                    }
                });
            }
        });
        child.setProducer(new Producer(){

            public void request(long n) {
                long c = consumerCapacity.getAndAdd(n);
                Producer producer = (Producer)currentProducer.get();
                if (producer != null) {
                    producer.request(c + n);
                } else if (c == 0L && resumeBoundary.compareAndSet(true, false)) {
                    worker.schedule(subscribeToSource);
                }
            }
        });
    }

    public static final class RetryWithPredicate
    implements Func1<Observable<? extends Notification<?>>, Observable<? extends Notification<?>>> {
        private Func2<Integer, Throwable, Boolean> predicate;

        public RetryWithPredicate(Func2<Integer, Throwable, Boolean> predicate) {
            this.predicate = predicate;
        }

        public Observable<? extends Notification<?>> call(Observable<? extends Notification<?>> ts) {
            return ts.scan((Object)Notification.createOnNext((Object)0), new Func2<Notification<Integer>, Notification<?>, Notification<Integer>>(){

                public Notification<Integer> call(Notification<Integer> n, Notification<?> term) {
                    int value = (Integer)n.getValue();
                    if (((Boolean)predicate.call((Object)value, (Object)term.getThrowable())).booleanValue()) {
                        return Notification.createOnNext((Object)(value + 1));
                    }
                    return term;
                }
            });
        }
    }

    public static final class RedoFinite
    implements Func1<Observable<? extends Notification<?>>, Observable<?>> {
        private final long count;

        public RedoFinite(long count) {
            this.count = count;
        }

        public Observable<?> call(Observable<? extends Notification<?>> ts) {
            return ts.map(new Func1<Notification<?>, Notification<?>>(){
                int num = 0;

                public Notification<?> call(Notification<?> terminalNotification) {
                    if (count == 0L) {
                        return terminalNotification;
                    }
                    ++this.num;
                    if ((long)this.num <= count) {
                        return Notification.createOnNext((Object)this.num);
                    }
                    return terminalNotification;
                }
            }).dematerialize();
        }
    }
}

