/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics.spectator;

import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import io.mantisrx.common.metrics.Timer;
import io.mantisrx.common.metrics.spectator.MetricId;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class TimerImpl
implements Timer {
    private final MetricId id;
    private final com.netflix.spectator.api.Timer spectatorTimer;

    public TimerImpl(MetricId id, Registry registry) {
        this.id = id;
        this.spectatorTimer = registry.timer(id.getSpectatorId(registry));
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.spectatorTimer.record(amount, unit);
    }

    @Override
    public <T> T record(Callable<T> f) throws Exception {
        return (T)this.spectatorTimer.record(f);
    }

    @Override
    public void record(Runnable f) {
        this.spectatorTimer.record(f);
    }

    @Override
    public long count() {
        return this.spectatorTimer.count();
    }

    @Override
    public long totalTime() {
        return this.spectatorTimer.totalTime();
    }

    @Override
    public MetricId id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.spectatorTimer.measure();
    }

    @Override
    public boolean hasExpired() {
        return this.spectatorTimer.hasExpired();
    }
}

