/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import java.util.HashMap;
import java.util.Map;

public enum MantisJobState {
    Accepted,
    Launched,
    StartInitiated,
    Started,
    Failed,
    Completed,
    Noop;

    private static final Map<MantisJobState, MantisJobState[]> validChanges;
    private static final Map<MantisJobState, MetaState> metaStates;

    public static MetaState toMetaState(MantisJobState state) {
        return metaStates.get((Object)state);
    }

    public boolean isValidStateChgTo(MantisJobState newState) {
        for (MantisJobState validState : validChanges.get((Object)this)) {
            if (validState != newState) continue;
            return true;
        }
        return false;
    }

    public boolean isTerminalState() {
        return MantisJobState.isTerminalState(this);
    }

    public static boolean isTerminalState(MantisJobState state) {
        switch (state) {
            case Failed: 
            case Completed: {
                return true;
            }
        }
        return false;
    }

    public static boolean isErrorState(MantisJobState started) {
        switch (started) {
            case Failed: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRunningState(MantisJobState state) {
        switch (state) {
            case Launched: 
            case StartInitiated: 
            case Started: {
                return true;
            }
        }
        return false;
    }

    public static boolean isOnSlaveState(MantisJobState state) {
        switch (state) {
            case StartInitiated: 
            case Started: {
                return true;
            }
        }
        return false;
    }

    static {
        validChanges = new HashMap<MantisJobState, MantisJobState[]>();
        validChanges.put(Accepted, new MantisJobState[]{Launched, Failed, Completed});
        validChanges.put(Launched, new MantisJobState[]{StartInitiated, Started, Failed, Completed});
        validChanges.put(StartInitiated, new MantisJobState[]{StartInitiated, Started, Completed, Failed});
        validChanges.put(Started, new MantisJobState[]{Started, Completed, Failed});
        validChanges.put(Failed, new MantisJobState[0]);
        validChanges.put(Completed, new MantisJobState[0]);
        metaStates = new HashMap<MantisJobState, MetaState>();
        metaStates.put(Accepted, MetaState.Active);
        metaStates.put(Launched, MetaState.Active);
        metaStates.put(StartInitiated, MetaState.Active);
        metaStates.put(Started, MetaState.Active);
        metaStates.put(Failed, MetaState.Terminal);
        metaStates.put(Completed, MetaState.Terminal);
    }

    public static enum MetaState {
        Active,
        Terminal;

    }
}

