/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.common.metrics;

import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsPublisher;
import io.mantisrx.shaded.com.google.common.base.Joiner;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMetricsPublisher
extends MetricsPublisher {
    private static final Logger log = LoggerFactory.getLogger(LoggingMetricsPublisher.class);
    public static final String LOGGING_ENABLED_METRICS_GROUP_ID_LIST_KEY = "MANTIS_LOGGING_ENABLED_METRICS_GROUP_ID_LIST";
    private Set<String> loggingEnabledMetricsGroupId = new HashSet<String>();

    public LoggingMetricsPublisher(Properties properties) {
        super(properties);
        String key = properties.getProperty(LOGGING_ENABLED_METRICS_GROUP_ID_LIST_KEY, System.getenv(LOGGING_ENABLED_METRICS_GROUP_ID_LIST_KEY));
        log.info("LOGGING_ENABLED_METRICS_GROUP_ID_LIST_KEY: {}", (Object)key);
        if (key != null) {
            this.loggingEnabledMetricsGroupId = Arrays.stream(key.toLowerCase().split(";")).collect(Collectors.toSet());
            log.info("[Metrics Publisher] enable logging for: {}", (Object)Joiner.on((char)',').join(this.loggingEnabledMetricsGroupId));
        }
    }

    @Override
    public void publishMetrics(long timestamp, Collection<Metrics> currentMetricsRegistered) {
        log.info("Printing metrics from: {}", (Object)Instant.ofEpochMilli(timestamp));
        currentMetricsRegistered.stream().filter(ms -> this.loggingEnabledMetricsGroupId.contains(ms.getMetricGroupId().id().toLowerCase())).map(ms -> ms.counters().entrySet()).flatMap(Collection::stream).forEach(m -> log.info("[METRICS] {} : {}", m.getKey(), (Object)((Counter)m.getValue()).value()));
    }
}

