/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka.source.checkpoint.strategy;

import io.mantisrx.connector.kafka.source.checkpoint.strategy.CheckpointStrategy;
import io.mantisrx.connector.kafka.source.checkpoint.strategy.FileBasedOffsetCheckpointStrategy;
import io.mantisrx.connector.kafka.source.checkpoint.strategy.KafkaOffsetCheckpointStrategy;
import io.mantisrx.connector.kafka.source.checkpoint.strategy.NoopCheckpointStrategy;
import io.mantisrx.connector.kafka.source.metrics.ConsumerMetrics;
import io.mantisrx.runtime.Context;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckpointStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckpointStrategyFactory.class);

    private CheckpointStrategyFactory() {
    }

    public static CheckpointStrategy<?> getNewInstance(Context context, KafkaConsumer<?, ?> consumer, String strategy, ConsumerMetrics metrics) {
        switch (strategy) {
            case "offsetsOnlyDefaultKafka": {
                KafkaOffsetCheckpointStrategy cs = new KafkaOffsetCheckpointStrategy(consumer, metrics);
                cs.init(context);
                return cs;
            }
            case "fileBasedOffsetCheckpointing": {
                FileBasedOffsetCheckpointStrategy fcs = new FileBasedOffsetCheckpointStrategy();
                LOGGER.info("initializing file checkpoint strategy");
                fcs.init(context);
                return fcs;
            }
        }
        return new NoopCheckpointStrategy();
    }
}

