/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka;

import io.mantisrx.connector.kafka.KafkaData;
import io.mantisrx.connector.kafka.KafkaDataNotification;
import java.util.concurrent.TimeUnit;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class KafkaAckable {
    private final Subject<KafkaDataNotification, KafkaDataNotification> subject;
    private final KafkaData kafkaData;
    private final long createTimeNano = System.nanoTime();

    public KafkaAckable(KafkaData data, SerializedSubject<KafkaDataNotification, KafkaDataNotification> ackSubject) {
        this.kafkaData = data;
        this.subject = ackSubject;
    }

    public KafkaAckable(KafkaData data, Subject<KafkaDataNotification, KafkaDataNotification> ackSubject) {
        this.kafkaData = data;
        this.subject = ackSubject;
    }

    public void ack() {
        KafkaDataNotification n = KafkaDataNotification.ack(this.getKafkaData(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.createTimeNano, TimeUnit.NANOSECONDS));
        this.subject.onNext((Object)n);
    }

    public void nack() {
        KafkaDataNotification n = KafkaDataNotification.nack(this.getKafkaData(), TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.createTimeNano, TimeUnit.NANOSECONDS));
        this.subject.onNext((Object)n);
    }

    public void error(Throwable t) {
        KafkaDataNotification n = KafkaDataNotification.error(this.getKafkaData(), t, TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.createTimeNano, TimeUnit.NANOSECONDS));
        this.subject.onNext((Object)n);
    }

    public KafkaData getKafkaData() {
        return this.kafkaData;
    }
}

