/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.connector.kafka.source.serde;

import io.mantisrx.connector.kafka.source.serde.MapDeserializerBase;
import io.mantisrx.connector.kafka.source.serde.ParseException;
import io.mantisrx.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJsonDeserializer
extends MapDeserializerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleJsonDeserializer.class);
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};

    @Override
    public boolean canParse(byte[] message) {
        return true;
    }

    @Override
    public Map<String, Object> parseMessage(byte[] message) throws ParseException {
        Map result;
        try {
            result = (Map)this.jsonMapper.readValue(message, this.typeRef);
        }
        catch (Exception ex) {
            LOGGER.error("Json parser failed to parse message! PAYLOAD:" + this.getPartialPayLoadForLogging(message), (Throwable)ex);
            throw new ParseException("Json not able to parse raw message", ex);
        }
        return result;
    }
}

