/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.server.core.WorkerOutlier;
import java.util.HashMap;
import java.util.Map;
import rx.functions.Action1;

public class TimeBufferedWorkerOutlier
extends WorkerOutlier {
    private Map<Integer, CumulatedValue> workerValues = new HashMap<Integer, CumulatedValue>();
    private long bufferedSecs;

    public TimeBufferedWorkerOutlier(long cooldownSecs, long bufferedSecs, Action1<Integer> outlierTrigger) {
        super(cooldownSecs, outlierTrigger);
        this.bufferedSecs = bufferedSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataPoint(int workerIndex, double value, int numWorkers) {
        CumulatedValue cumulatedValue;
        Map<Integer, CumulatedValue> map = this.workerValues;
        synchronized (map) {
            cumulatedValue = this.workerValues.get(workerIndex);
            if (cumulatedValue == null) {
                cumulatedValue = new CumulatedValue();
                this.workerValues.put(workerIndex, cumulatedValue);
            }
        }
        double dataPoint = -1.0;
        CumulatedValue cumulatedValue2 = cumulatedValue;
        synchronized (cumulatedValue2) {
            if (System.currentTimeMillis() - cumulatedValue.startTs > this.bufferedSecs * 1000L) {
                dataPoint = cumulatedValue.value;
                cumulatedValue.reset();
            }
            cumulatedValue.increment(value);
        }
        if (dataPoint != -1.0) {
            super.addDataPoint(workerIndex, dataPoint, numWorkers);
        }
    }

    public static class CumulatedValue {
        private long startTs = System.currentTimeMillis();
        private double value = 0.0;

        public void increment(double incr) {
            this.value += incr;
        }

        public void reset() {
            this.startTs = System.currentTimeMillis();
            this.value = 0.0;
        }
    }
}

