/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.core;

import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.server.core.ExecuteStageRequest;
import java.util.HashMap;
import java.util.Map;

public class WorkerTopologyInfo {
    private static final String MANTIS_JOB_NAME = "MANTIS_JOB_NAME";
    private static final String MANTIS_JOB_ID = "MANTIS_JOB_ID";
    private static final String MANTIS_WORKER_INDEX = "MANTIS_WORKER_INDEX";
    private static final String MANTIS_WORKER_NUMBER = "MANTIS_WORKER_NUMBER";
    private static final String MANTIS_WORKER_STAGE_NUMBER = "MANTIS_WORKER_STAGE_NUMBER";
    private static final String MANTIS_NUM_STAGES = "MANTIS_NUM_STAGES";
    private static final String MANTIS_PREV_STAGE_INITIAL_NUM_WORKERS = "MANTIS_PREV_STAGE_INITIAL_NUM_WORKERS";
    private static final String MANTIS_NEXT_STAGE_INITIAL_NUM_WORKERS = "MANTIS_NEXT_STAGE_INITIAL_NUM_WORKERS";
    private static final String MANTIS_METRICS_PORT = "MANTIS_METRICS_PORT";
    private static final String MANTIS_WORKER_CUSTOM_PORT = "MANTIS_WORKER_CUSTOM_PORT";

    public static class Reader {
        private static Data data = new Data(System.getenv("MANTIS_JOB_NAME"), System.getenv("MANTIS_JOB_ID"), System.getenv("MANTIS_WORKER_INDEX") == null ? -1 : Integer.parseInt(System.getenv("MANTIS_WORKER_INDEX")), System.getenv("MANTIS_WORKER_NUMBER") == null ? -1 : Integer.parseInt(System.getenv("MANTIS_WORKER_NUMBER")), System.getenv("MANTIS_WORKER_STAGE_NUMBER") == null ? -1 : Integer.parseInt(System.getenv("MANTIS_WORKER_STAGE_NUMBER")), System.getenv("MANTIS_NUM_STAGES") == null ? -1 : Integer.parseInt(System.getenv("MANTIS_NUM_STAGES")), System.getenv("MANTIS_PREV_STAGE_INITIAL_NUM_WORKERS") == null ? -1 : Integer.parseInt(System.getenv("MANTIS_PREV_STAGE_INITIAL_NUM_WORKERS")), System.getenv("MANTIS_NEXT_STAGE_INITIAL_NUM_WORKERS") == null ? -1 : Integer.parseInt(System.getenv("MANTIS_NEXT_STAGE_INITIAL_NUM_WORKERS")), System.getenv("MANTIS_METRICS_PORT") == null ? -1 : Integer.parseInt(System.getenv("MANTIS_METRICS_PORT")));

        public static Data getData() {
            return data;
        }
    }

    public static class Writer {
        private final Map<String, String> envVars = new HashMap<String, String>();

        public Writer(ExecuteStageRequest request) {
            this.envVars.put(WorkerTopologyInfo.MANTIS_JOB_NAME, request.getJobName());
            this.envVars.put(WorkerTopologyInfo.MANTIS_JOB_ID, request.getJobId());
            this.envVars.put(WorkerTopologyInfo.MANTIS_WORKER_INDEX, request.getWorkerIndex() + "");
            this.envVars.put(WorkerTopologyInfo.MANTIS_WORKER_NUMBER, request.getWorkerNumber() + "");
            this.envVars.put(WorkerTopologyInfo.MANTIS_WORKER_STAGE_NUMBER, request.getStage() + "");
            this.envVars.put(WorkerTopologyInfo.MANTIS_NUM_STAGES, request.getTotalNumStages() + "");
            int totalNumWorkerStages = request.getTotalNumStages() - (request.getHasJobMaster() ? 1 : 0);
            if (totalNumWorkerStages > 1 && request.getStage() > 1) {
                StageSchedulingInfo prevStage = request.getSchedulingInfo().forStage(request.getStage() - 1);
                this.envVars.put(WorkerTopologyInfo.MANTIS_PREV_STAGE_INITIAL_NUM_WORKERS, prevStage.getNumberOfInstances() + "");
                if (totalNumWorkerStages > request.getStage()) {
                    StageSchedulingInfo nextStage = request.getSchedulingInfo().forStage(request.getStage() + 1);
                    this.envVars.put(WorkerTopologyInfo.MANTIS_NEXT_STAGE_INITIAL_NUM_WORKERS, nextStage.getNumberOfInstances() + "");
                }
            }
            this.envVars.put(WorkerTopologyInfo.MANTIS_METRICS_PORT, request.getMetricsPort() + "");
            this.envVars.put(WorkerTopologyInfo.MANTIS_WORKER_CUSTOM_PORT, request.getWorkerPorts().getCustomPort() + "");
        }

        public Map<String, String> getEnvVars() {
            return this.envVars;
        }
    }

    public static class Data {
        private String jobName;
        private String JobId;
        private int workerIndex;
        private int workerNumber;
        private int stageNumber;
        private int numStages;
        private int prevStageInitialNumWorkers = -1;
        private int nextStageInitialNumWorkers = -1;
        private int metricsPort;

        public Data(String jobName, String jobId, int workerIndex, int workerNumber, int stageNumber, int numStages) {
            this.jobName = jobName;
            this.JobId = jobId;
            this.workerIndex = workerIndex;
            this.workerNumber = workerNumber;
            this.stageNumber = stageNumber;
            this.numStages = numStages;
        }

        public Data(String jobName, String jobId, int workerIndex, int workerNumber, int stageNumber, int numStages, int prevStageInitialNumWorkers, int nextStageInitialNumWorkers, int metricsPort) {
            this.jobName = jobName;
            this.JobId = jobId;
            this.workerIndex = workerIndex;
            this.workerNumber = workerNumber;
            this.stageNumber = stageNumber;
            this.numStages = numStages;
            this.prevStageInitialNumWorkers = prevStageInitialNumWorkers;
            this.nextStageInitialNumWorkers = nextStageInitialNumWorkers;
            this.metricsPort = metricsPort;
        }

        public String getJobName() {
            return this.jobName;
        }

        public String getJobId() {
            return this.JobId;
        }

        public int getWorkerIndex() {
            return this.workerIndex;
        }

        public int getWorkerNumber() {
            return this.workerNumber;
        }

        public int getStageNumber() {
            return this.stageNumber;
        }

        public int getNumStages() {
            return this.numStages;
        }

        public int getPrevStageInitialNumWorkers() {
            return this.prevStageInitialNumWorkers;
        }

        public int getNextStageInitialNumWorkers() {
            return this.nextStageInitialNumWorkers;
        }

        public int getMetricsPort() {
            return this.metricsPort;
        }
    }
}

