/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master;

import akka.actor.ActorRef;
import akka.pattern.PatternsCS;
import akka.util.Timeout;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.Timer;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.server.core.BaseService;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.scheduler.MantisSchedulerFactory;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClustersManagerService
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(JobClustersManagerService.class);
    private final ActorRef jobClustersManagerActor;
    private final MantisSchedulerFactory schedulerFactory;
    private final boolean loadJobsFromStore;
    private final Timer initializationTimeTracker;

    public JobClustersManagerService(ActorRef jobClustersManagerActor, MantisSchedulerFactory schedulerFactory, boolean loadJobsFromStore) {
        super(true);
        this.jobClustersManagerActor = jobClustersManagerActor;
        this.schedulerFactory = schedulerFactory;
        this.loadJobsFromStore = loadJobsFromStore;
        Metrics metrics = new Metrics.Builder().name("JobClustersManagerService").addTimer("initializationTime").build();
        this.initializationTimeTracker = metrics.getTimer("initializationTime");
    }

    public void start() {
        super.awaitActiveModeAndStart(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            long startTime = System.currentTimeMillis();
            try {
                long masterInitTimeoutSecs = ConfigurationProvider.getConfig().getMasterInitTimeoutSecs();
                CompletionStage<JobClusterManagerProto.JobClustersManagerInitializeResponse> initResponse = PatternsCS.ask((ActorRef)this.jobClustersManagerActor, (Object)new JobClusterManagerProto.JobClustersManagerInitialize(this.schedulerFactory, this.loadJobsFromStore), (Timeout)Timeout.apply((long)masterInitTimeoutSecs, (TimeUnit)TimeUnit.SECONDS)).thenApply(JobClusterManagerProto.JobClustersManagerInitializeResponse.class::cast);
                initResponse.whenComplete((resp, t) -> {
                    logger.info("JobClustersManagerActor init response {}", resp);
                    if (t != null || !resp.responseCode.equals((Object)BaseResponse.ResponseCode.SUCCESS)) {
                        logger.error("failed to initialize JobClustersManagerActor, committing suicide...", t);
                        System.exit(3);
                    }
                    latch.countDown();
                });
            }
            catch (Exception e) {
                logger.error("caught exception when initializing JobClustersManagerService, committing suicide...", (Throwable)e);
                System.exit(3);
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("interrupted waiting for latch countdown during JobClustersManagerInitialize, committing suicide..", (Throwable)e);
                System.exit(3);
            }
            logger.info("JobClustersManager initialize took {} sec", (Object)TimeUnit.SECONDS.convert(System.currentTimeMillis() - startTime, TimeUnit.MILLISECONDS));
            this.initializationTimeTracker.record(System.currentTimeMillis() - startTime, TimeUnit.MILLISECONDS);
        });
    }
}

