/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.pattern.PatternsCS;
import akka.util.Timeout;
import io.mantisrx.master.JobClustersManagerActor;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;
import scala.concurrent.duration.Duration;

public class JobListHelperActor
extends AbstractActor {
    private final Logger logger = LoggerFactory.getLogger(JobListHelperActor.class);

    public static Props props() {
        return Props.create(JobListHelperActor.class, (Object[])new Object[0]);
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ListJobClusterRequestWrapper.class, this::onJobClustersList).match(ListJobRequestWrapper.class, this::onJobList).match(ListJobIdRequestWrapper.class, this::onJobIdList).matchAny(x -> this.logger.warn("Unexpected message {}", x)).build();
    }

    private void onJobList(ListJobRequestWrapper request) {
        ActorRef sender = this.getSender();
        Timeout t = new Timeout(Duration.create((long)500L, (TimeUnit)TimeUnit.MILLISECONDS));
        ArrayList resultList = Lists.newArrayList();
        this.getJobClustersMatchingRegex(request.jobClusterInfoMap.values(), request.listJobsRequest.getCriteria()).flatMap(jobClusterInfo -> {
            CompletionStage<JobClusterManagerProto.ListJobsResponse> respCS = PatternsCS.ask((ActorRef)jobClusterInfo.jobClusterActor, (Object)request.listJobsRequest, (Timeout)t).thenApply(JobClusterManagerProto.ListJobsResponse.class::cast);
            return Observable.from(respCS.toCompletableFuture(), (Scheduler)Schedulers.io()).onErrorResumeNext(ex -> {
                this.logger.warn("caught exception {}", (Object)ex.getMessage(), ex);
                return Observable.empty();
            });
        }).filter(Objects::nonNull).flatMapIterable(listJobsResp -> listJobsResp.getJobList()).toSortedList((o1, o2) -> Long.compare(o1.getJobMetadata().getSubmittedAt(), o2.getJobMetadata().getSubmittedAt())).subscribeOn(Schedulers.computation()).subscribe(resultList::addAll, e -> request.sender.tell((Object)new JobClusterManagerProto.ListJobsResponse(((ListJobRequestWrapper)request).listJobsRequest.requestId, BaseResponse.ResponseCode.SERVER_ERROR, e.getMessage(), resultList), sender), () -> request.sender.tell((Object)new JobClusterManagerProto.ListJobsResponse(((ListJobRequestWrapper)request).listJobsRequest.requestId, BaseResponse.ResponseCode.SUCCESS, "", resultList), sender));
    }

    private void onJobIdList(ListJobIdRequestWrapper request) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("In onJobIdList {}", (Object)request);
        }
        ActorRef sender = this.getSender();
        Timeout t = new Timeout(Duration.create((long)500L, (TimeUnit)TimeUnit.MILLISECONDS));
        ArrayList resultList = Lists.newArrayList();
        this.getJobClustersMatchingRegex(request.jobClusterInfoMap.values(), request.listJobIdsRequest.getCriteria()).flatMap(jobClusterInfo -> {
            CompletionStage<JobClusterManagerProto.ListJobIdsResponse> respCS = PatternsCS.ask((ActorRef)jobClusterInfo.jobClusterActor, (Object)request.listJobIdsRequest, (Timeout)t).thenApply(JobClusterManagerProto.ListJobIdsResponse.class::cast);
            return Observable.from(respCS.toCompletableFuture(), (Scheduler)Schedulers.io()).onErrorResumeNext(ex -> {
                this.logger.warn("caught exception {}", (Object)ex.getMessage(), ex);
                return Observable.empty();
            });
        }).filter(Objects::nonNull).map(JobClusterManagerProto.ListJobIdsResponse::getJobIds).subscribeOn(Schedulers.computation()).subscribe(resultList::addAll, error -> {
            this.logger.warn("Exception in JobListHelperActor:onJobIdList", error);
            request.sender.tell((Object)new JobClusterManagerProto.ListJobIdsResponse(((ListJobIdRequestWrapper)request).listJobIdsRequest.requestId, BaseResponse.ResponseCode.SERVER_ERROR, error.getMessage(), resultList), sender);
        }, () -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Exit onJobIdList {}", (Object)resultList);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Exit onJobIdList {}", (Object)resultList);
            }
            request.sender.tell((Object)new JobClusterManagerProto.ListJobIdsResponse(((ListJobIdRequestWrapper)request).listJobIdsRequest.requestId, BaseResponse.ResponseCode.SUCCESS, "", resultList), sender);
        });
    }

    private void onJobClustersList(ListJobClusterRequestWrapper request) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("In onJobClustersListRequest {}", (Object)request);
        }
        ActorRef callerActor = this.getSender();
        Timeout timeout = new Timeout(Duration.create((long)500L, (TimeUnit)TimeUnit.MILLISECONDS));
        ArrayList clusterList = Lists.newArrayList();
        Observable.from(request.jobClusterInfoMap.values()).flatMap(jInfo -> {
            CompletionStage<JobClusterManagerProto.GetJobClusterResponse> respCS = PatternsCS.ask((ActorRef)jInfo.jobClusterActor, (Object)new JobClusterManagerProto.GetJobClusterRequest(jInfo.clusterName), (Timeout)timeout).thenApply(JobClusterManagerProto.GetJobClusterResponse.class::cast);
            return Observable.from(respCS.toCompletableFuture(), (Scheduler)Schedulers.io()).onErrorResumeNext(ex -> {
                this.logger.warn("caught exception {}", (Object)ex.getMessage(), ex);
                return Observable.empty();
            });
        }).filter(resp -> resp != null && resp.getJobCluster().isPresent()).map(resp -> resp.getJobCluster().get()).doOnError(this::logError).subscribeOn(Schedulers.computation()).subscribe(clusterList::add, err -> {
            this.logger.warn("Exception in onJobClusterList ", err);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Exit onJobClustersListRequest {}", err);
            }
            request.sender.tell((Object)new JobClusterManagerProto.ListJobClustersResponse(((ListJobClusterRequestWrapper)request).listJobClustersRequest.requestId, BaseResponse.ResponseCode.SERVER_ERROR, err.getMessage(), clusterList), callerActor);
        }, () -> {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Exit onJobClustersListRequest {}", (Object)clusterList);
            }
            request.sender.tell((Object)new JobClusterManagerProto.ListJobClustersResponse(((ListJobClusterRequestWrapper)request).listJobClustersRequest.requestId, BaseResponse.ResponseCode.SUCCESS, "", clusterList), callerActor);
        });
    }

    private void logError(Throwable e) {
        this.logger.error("Exception occurred retrieving job cluster list {}", (Object)e.getMessage());
    }

    private Observable<JobClustersManagerActor.JobClusterInfo> getJobClustersMatchingRegex(Collection<JobClustersManagerActor.JobClusterInfo> jobClusterList, JobClusterManagerProto.ListJobCriteria criteria) {
        return Observable.from(jobClusterList).filter(jcInfo -> {
            if (criteria.getMatchingRegex().isPresent()) {
                try {
                    return Pattern.compile(criteria.getMatchingRegex().get(), 2).matcher(jcInfo.clusterName).find();
                }
                catch (Exception e) {
                    this.logger.warn("Invalid regex {}", (Object)e.getMessage());
                    return true;
                }
            }
            return true;
        });
    }

    static class ListJobIdRequestWrapper {
        private final JobClusterManagerProto.ListJobIdsRequest listJobIdsRequest;
        private final ActorRef sender;
        private final Map<String, JobClustersManagerActor.JobClusterInfo> jobClusterInfoMap;

        public ListJobIdRequestWrapper(JobClusterManagerProto.ListJobIdsRequest listJobIdsRequest, ActorRef sender, Map<String, JobClustersManagerActor.JobClusterInfo> jobClusterInfoMap) {
            this.listJobIdsRequest = listJobIdsRequest;
            this.sender = sender;
            this.jobClusterInfoMap = jobClusterInfoMap;
        }
    }

    static class ListJobRequestWrapper {
        private final JobClusterManagerProto.ListJobsRequest listJobsRequest;
        private final ActorRef sender;
        private final Map<String, JobClustersManagerActor.JobClusterInfo> jobClusterInfoMap;

        public ListJobRequestWrapper(JobClusterManagerProto.ListJobsRequest listJobsRequest, ActorRef sender, Map<String, JobClustersManagerActor.JobClusterInfo> jobClusterInfoMap) {
            this.listJobsRequest = listJobsRequest;
            this.sender = sender;
            this.jobClusterInfoMap = jobClusterInfoMap;
        }
    }

    static class ListJobClusterRequestWrapper {
        private final JobClusterManagerProto.ListJobClustersRequest listJobClustersRequest;
        private final ActorRef sender;
        private final Map<String, JobClustersManagerActor.JobClusterInfo> jobClusterInfoMap;

        public ListJobClusterRequestWrapper(JobClusterManagerProto.ListJobClustersRequest request, ActorRef sender, Map<String, JobClustersManagerActor.JobClusterInfo> jobClusterInfoMap) {
            this.jobClusterInfoMap = jobClusterInfoMap;
            this.sender = sender;
            this.listJobClustersRequest = request;
        }

        public JobClusterManagerProto.ListJobClustersRequest getListJobClustersRequest() {
            return this.listJobClustersRequest;
        }

        public ActorRef getSender() {
            return this.sender;
        }

        public Map<String, JobClustersManagerActor.JobClusterInfo> getJobClusterInfoMap() {
            return this.jobClusterInfoMap;
        }
    }
}

