/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.utils;

import io.mantisrx.master.api.akka.route.utils.QueryParamUtils;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.master.jobcluster.job.worker.WorkerHeartbeat;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.master.jobcluster.job.worker.WorkerStatus;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.server.core.PostJobStatusRequest;
import io.mantisrx.server.core.Status;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRouteUtils {
    private static final Logger logger = LoggerFactory.getLogger(JobRouteUtils.class);
    public static final String QUERY_PARAM_LIMIT = "limit";
    public static final String QUERY_PARAM_JOB_STATE = "jobState";
    public static final String QUERY_PARAM_STAGE_NUM = "stageNumber";
    public static final String QUERY_PARAM_WORKER_INDEX = "workerIndex";
    public static final String QUERY_PARAM_WORKER_NUM = "workerNumber";
    public static final String QUERY_PARAM_WORKER_STATE = "workerState";
    public static final String QUERY_PARAM_ACTIVE_ONLY = "activeOnly";
    public static final String QUERY_PARAM_LABELS_QUERY = "labels";
    public static final String QUERY_PARAM_LABELS_OPERAND = "labels.op";
    public static final String QUERY_PARAM_END_JOB_ID = "startJobIdExclusive";

    public static WorkerEvent createWorkerStatusRequest(PostJobStatusRequest req) {
        Status status = req.getStatus();
        if (status.getType() != Status.TYPE.HEARTBEAT) {
            WorkerId workerId = new WorkerId(req.getJobId(), status.getWorkerIndex(), status.getWorkerNumber());
            if (logger.isTraceEnabled()) {
                logger.trace("forwarding worker status type {} from worker {}", (Object)status.getType().name(), (Object)workerId);
            }
            return new WorkerStatus(status);
        }
        return new WorkerHeartbeat(status);
    }

    public static JobClusterManagerProto.ListJobsRequest createListJobsRequest(Map<String, List<String>> params, Optional<String> regex, boolean activeOnlyDefault) {
        if (params == null) {
            if (regex.isPresent()) {
                return new JobClusterManagerProto.ListJobsRequest(regex.get());
            }
            return new JobClusterManagerProto.ListJobsRequest();
        }
        Optional<Integer> limit = QueryParamUtils.paramValueAsInt(params, QUERY_PARAM_LIMIT);
        Optional<JobState.MetaState> jobState = QueryParamUtils.paramValue(params, QUERY_PARAM_JOB_STATE).map(p -> JobState.MetaState.valueOf(p));
        List<Integer> stageNumber = QueryParamUtils.paramValuesAsInt(params, QUERY_PARAM_STAGE_NUM);
        List<Integer> workerIndex = QueryParamUtils.paramValuesAsInt(params, QUERY_PARAM_WORKER_INDEX);
        List<Integer> workerNumber = QueryParamUtils.paramValuesAsInt(params, QUERY_PARAM_WORKER_NUM);
        List<WorkerState.MetaState> workerState = QueryParamUtils.paramValuesAsMetaState(params, QUERY_PARAM_WORKER_STATE);
        Optional<Boolean> activeOnly = Optional.of(QueryParamUtils.paramValueAsBool(params, QUERY_PARAM_ACTIVE_ONLY).orElse(activeOnlyDefault));
        Optional<String> labelsQuery = QueryParamUtils.paramValue(params, QUERY_PARAM_LABELS_QUERY);
        Optional<String> labelsOperand = QueryParamUtils.paramValue(params, QUERY_PARAM_LABELS_OPERAND);
        Optional<JobId> jobId = QueryParamUtils.paramValue(params, QUERY_PARAM_END_JOB_ID).flatMap(JobId::fromId);
        return new JobClusterManagerProto.ListJobsRequest(new JobClusterManagerProto.ListJobCriteria(limit, jobState, stageNumber, workerIndex, workerNumber, workerState, activeOnly, regex, labelsQuery, labelsOperand, jobId));
    }

    public static JobClusterManagerProto.ListJobIdsRequest createListJobIdsRequest(Map<String, List<String>> params, Optional<String> regex, boolean activeOnlyDefault) {
        if (params == null) {
            return new JobClusterManagerProto.ListJobIdsRequest();
        }
        Optional<Integer> limit = QueryParamUtils.paramValueAsInt(params, QUERY_PARAM_LIMIT);
        Optional<JobState.MetaState> jobState = QueryParamUtils.paramValue(params, QUERY_PARAM_JOB_STATE).map(p -> JobState.MetaState.valueOf(p));
        Optional<Boolean> activeOnly = Optional.of(QueryParamUtils.paramValueAsBool(params, QUERY_PARAM_ACTIVE_ONLY).orElse(activeOnlyDefault));
        Optional<String> labelsQuery = QueryParamUtils.paramValue(params, QUERY_PARAM_LABELS_QUERY);
        Optional<String> labelsOperand = QueryParamUtils.paramValue(params, QUERY_PARAM_LABELS_OPERAND);
        Optional<JobId> jobId = QueryParamUtils.paramValue(params, QUERY_PARAM_END_JOB_ID).flatMap(JobId::fromId);
        return new JobClusterManagerProto.ListJobIdsRequest(limit, jobState, activeOnly, regex, labelsQuery, labelsOperand, jobId);
    }
}

