/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v0;

import akka.actor.ActorSystem;
import akka.http.caching.LfuCache;
import akka.http.caching.javadsl.Cache;
import akka.http.caching.javadsl.CachingSettings;
import akka.http.caching.javadsl.LfuCacheSettings;
import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.HttpMethods;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.Uri;
import akka.http.javadsl.server.ExceptionHandler;
import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.RequestContext;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.RouteResult;
import akka.http.javadsl.server.directives.CachingDirectives;
import akka.http.javadsl.unmarshalling.StringUnmarshallers;
import akka.http.javadsl.unmarshalling.Unmarshaller;
import akka.japi.JavaPartialFunction;
import akka.japi.Pair;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.handlers.JobClusterRouteHandler;
import io.mantisrx.master.api.akka.route.handlers.JobRouteHandler;
import io.mantisrx.master.api.akka.route.proto.JobClusterProtoAdapter;
import io.mantisrx.master.api.akka.route.utils.JobRouteUtils;
import io.mantisrx.master.api.akka.route.v0.BaseRoute;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.runtime.MantisJobDefinition;
import io.mantisrx.runtime.NamedJobDefinition;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.shaded.com.google.common.base.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

public class JobClusterRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(JobClusterRoute.class);
    private final JobClusterRouteHandler jobClusterRouteHandler;
    private final JobRouteHandler jobRouteHandler;
    private final Cache<Uri, RouteResult> cache;
    private final JavaPartialFunction<RequestContext, Uri> requestUriKeyer = new JavaPartialFunction<RequestContext, Uri>(){

        public Uri apply(RequestContext in, boolean isCheck) {
            boolean isGet;
            HttpRequest request = in.getRequest();
            boolean bl = isGet = request.method() == HttpMethods.GET;
            if (isGet) {
                return request.getUri();
            }
            throw 1.noMatch();
        }
    };
    private final Metrics metrics;
    private final Counter jobClusterSubmit;
    private final Counter jobClusterSubmitError;
    private final Counter jobClusterCreate;
    private final Counter jobClusterCreateError;
    private final Counter jobClusterCreateUpdate;
    private final Counter jobClusterCreateUpdateError;
    private final Counter jobClusterDelete;
    private final Counter jobClusterDeleteError;
    private final Counter jobClusterDisable;
    private final Counter jobClusterDisableError;
    private final Counter jobClusterEnable;
    private final Counter jobClusterEnableError;
    private final Counter jobClusterQuickupdate;
    private final Counter jobClusterQuickupdateError;
    private final Counter jobClusterUpdateLabel;
    private final Counter jobClusterUpdateSla;
    private final Counter jobClusterUpdateSlaError;
    private final Counter jobClusterUpdateLabelError;
    private final Counter jobClusterListGET;
    private final Counter jobClusterListJobIdGET;
    private final Counter jobClusterListClusterGET;
    private static final PathMatcher0 API_V0_JOBCLUSTER = PathMatchers.segment((String)"api").slash("namedjob");
    private static final HttpHeader ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = HttpHeader.parse((String)"Access-Control-Allow-Origin", (String)"*");
    private static final Iterable<HttpHeader> DEFAULT_RESPONSE_HEADERS = Arrays.asList(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);

    public JobClusterRoute(JobClusterRouteHandler jobClusterRouteHandler, JobRouteHandler jobRouteHandler, ActorSystem actorSystem) {
        this.jobClusterRouteHandler = jobClusterRouteHandler;
        this.jobRouteHandler = jobRouteHandler;
        MasterConfiguration config = ConfigurationProvider.getConfig();
        this.cache = this.createCache(actorSystem, config.getApiCacheMinSize(), config.getApiCacheMaxSize(), config.getApiCacheTtlMilliseconds());
        Metrics m = new Metrics.Builder().id("V0JobClusterRoute", new Tag[0]).addCounter("jobClusterSubmit").addCounter("jobClusterSubmitError").addCounter("jobClusterCreate").addCounter("jobClusterCreateError").addCounter("jobClusterCreateUpdate").addCounter("jobClusterCreateUpdateError").addCounter("jobClusterDelete").addCounter("jobClusterDeleteError").addCounter("jobClusterDisable").addCounter("jobClusterDisableError").addCounter("jobClusterEnable").addCounter("jobClusterEnableError").addCounter("jobClusterQuickupdate").addCounter("jobClusterQuickupdateError").addCounter("jobClusterUpdateLabel").addCounter("jobClusterUpdateLabelError").addCounter("jobClusterListGET").addCounter("jobClusterListJobIdGET").addCounter("jobClusterListClusterGET").addCounter("jobClusterUpdateSla").addCounter("jobClusterUpdateSlaError").build();
        this.metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.jobClusterSubmit = this.metrics.getCounter("jobClusterSubmit");
        this.jobClusterSubmitError = this.metrics.getCounter("jobClusterSubmitError");
        this.jobClusterCreate = this.metrics.getCounter("jobClusterCreate");
        this.jobClusterCreateError = this.metrics.getCounter("jobClusterCreateError");
        this.jobClusterCreateUpdate = this.metrics.getCounter("jobClusterCreateUpdate");
        this.jobClusterCreateUpdateError = this.metrics.getCounter("jobClusterCreateUpdateError");
        this.jobClusterDelete = this.metrics.getCounter("jobClusterDelete");
        this.jobClusterDeleteError = this.metrics.getCounter("jobClusterDeleteError");
        this.jobClusterDisable = this.metrics.getCounter("jobClusterDisable");
        this.jobClusterDisableError = this.metrics.getCounter("jobClusterDisableError");
        this.jobClusterEnable = this.metrics.getCounter("jobClusterEnable");
        this.jobClusterEnableError = this.metrics.getCounter("jobClusterEnableError");
        this.jobClusterQuickupdate = this.metrics.getCounter("jobClusterQuickupdate");
        this.jobClusterQuickupdateError = this.metrics.getCounter("jobClusterQuickupdateError");
        this.jobClusterUpdateLabel = this.metrics.getCounter("jobClusterUpdateLabel");
        this.jobClusterUpdateLabelError = this.metrics.getCounter("jobClusterUpdateLabelError");
        this.jobClusterListGET = this.metrics.getCounter("jobClusterListGET");
        this.jobClusterListJobIdGET = this.metrics.getCounter("jobClusterListJobIdGET");
        this.jobClusterListClusterGET = this.metrics.getCounter("jobClusterListClusterGET");
        this.jobClusterUpdateSla = this.metrics.getCounter("jobClusterUpdateSla");
        this.jobClusterUpdateSlaError = this.metrics.getCounter("jobClusterUpdateSlaError");
    }

    private Cache<Uri, RouteResult> createCache(ActorSystem actorSystem) {
        CachingSettings defaultCachingSettings = CachingSettings.create((ActorSystem)actorSystem);
        LfuCacheSettings lfuCacheSettings = defaultCachingSettings.lfuCacheSettings().withInitialCapacity(5).withMaxCapacity(50).withTimeToLive((Duration)Duration.create((long)1L, (TimeUnit)TimeUnit.SECONDS));
        CachingSettings cachingSettings = defaultCachingSettings.withLfuCacheSettings(lfuCacheSettings);
        Cache jobClustersListCache = LfuCache.create((CachingSettings)cachingSettings);
        return jobClustersListCache;
    }

    private Route jobClusterListRoute(String jobCluster) {
        return this.parameterOptional(StringUnmarshallers.BOOLEAN, "jobIdsOnly", jobIdsOnly -> this.parameterMultiMap(params -> {
            if (jobIdsOnly.isPresent() && ((Boolean)jobIdsOnly.get()).booleanValue()) {
                logger.debug("/api/namedjob/listJobIds jobIdsOnly called");
                return CachingDirectives.alwaysCache(this.cache, this.requestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.jobRouteHandler.listJobIds(JobRouteUtils.createListJobIdsRequest(params, Strings.isNullOrEmpty((String)jobCluster) ? Optional.empty() : Optional.of("^" + jobCluster + "$"), true)), resp -> this.completeOK(resp.getJobIds().stream().map(jobId -> jobId.getJobId()).collect(Collectors.toList()), Jackson.marshaller()))));
            }
            logger.debug("/api/namedjob/listJobIds/{} called", (Object)jobCluster);
            return CachingDirectives.alwaysCache(this.cache, this.requestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.jobRouteHandler.listJobIds(JobRouteUtils.createListJobIdsRequest(params, Strings.isNullOrEmpty((String)jobCluster) ? Optional.empty() : Optional.of("^" + jobCluster + "$"), false)), resp -> this.completeOK(resp.getJobIds(), Jackson.marshaller()), resp -> this.completeOK(Collections.emptyList(), Jackson.marshaller()))));
        }));
    }

    private Pair<Boolean, String> validateSubmitJobRequest(MantisJobDefinition mjd) {
        if (mjd.getName() == null || mjd.getName().length() == 0) {
            logger.info("rejecting job submit request, must include name {}", (Object)mjd);
            return Pair.apply((Object)false, (Object)"Job definition must include name");
        }
        SchedulingInfo schedulingInfo = mjd.getSchedulingInfo();
        if (schedulingInfo != null) {
            Map stages = schedulingInfo.getStages();
            if (stages == null) {
                return Pair.apply((Object)true, (Object)"");
            }
            for (StageSchedulingInfo stageSchedInfo : stages.values()) {
                int maxWorkersPerStage;
                int maxNetworkMbps;
                int maxMemoryMB;
                int maxCpuCores;
                double cpuCores = stageSchedInfo.getMachineDefinition().getCpuCores();
                if (cpuCores > (double)(maxCpuCores = ConfigurationProvider.getConfig().getWorkerMachineDefinitionMaxCpuCores())) {
                    logger.info("rejecting job submit request, requested CPU {} > max for {} (user: {}) (stage: {})", new Object[]{cpuCores, mjd.getName(), mjd.getUser(), stages});
                    return Pair.apply((Object)false, (Object)("requested CPU cannot be more than max CPU per worker " + maxCpuCores));
                }
                double memoryMB = stageSchedInfo.getMachineDefinition().getMemoryMB();
                if (memoryMB > (double)(maxMemoryMB = ConfigurationProvider.getConfig().getWorkerMachineDefinitionMaxMemoryMB())) {
                    logger.info("rejecting job submit request, requested memory {} > max for {} (user: {}) (stage: {})", new Object[]{memoryMB, mjd.getName(), mjd.getUser(), stages});
                    return Pair.apply((Object)false, (Object)("requested memory cannot be more than max memoryMB per worker " + maxMemoryMB));
                }
                double networkMbps = stageSchedInfo.getMachineDefinition().getNetworkMbps();
                if (networkMbps > (double)(maxNetworkMbps = ConfigurationProvider.getConfig().getWorkerMachineDefinitionMaxNetworkMbps())) {
                    logger.info("rejecting job submit request, requested network {} > max for {} (user: {}) (stage: {})", new Object[]{networkMbps, mjd.getName(), mjd.getUser(), stages});
                    return Pair.apply((Object)false, (Object)("requested network cannot be more than max networkMbps per worker " + maxNetworkMbps));
                }
                int numberOfInstances = stageSchedInfo.getNumberOfInstances();
                if (numberOfInstances > (maxWorkersPerStage = ConfigurationProvider.getConfig().getMaxWorkersPerStage())) {
                    logger.info("rejecting job submit request, requested num instances {} > max for {} (user: {}) (stage: {})", new Object[]{numberOfInstances, mjd.getName(), mjd.getUser(), stages});
                    return Pair.apply((Object)false, (Object)("requested number of instances per stage cannot be more than " + maxWorkersPerStage));
                }
                StageScalingPolicy scalingPolicy = stageSchedInfo.getScalingPolicy();
                if (scalingPolicy == null || scalingPolicy.getMax() <= maxWorkersPerStage) continue;
                logger.info("rejecting job submit request, requested num instances in scaling policy {} > max for {} (user: {}) (stage: {})", new Object[]{numberOfInstances, mjd.getName(), mjd.getUser(), stages});
                return Pair.apply((Object)false, (Object)("requested number of instances per stage in scaling policy cannot be more than " + maxWorkersPerStage));
            }
        }
        return Pair.apply((Object)true, (Object)"");
    }

    private Route getJobClusterRoutes() {
        return this.route(new Route[]{this.path(PathMatchers.segment((String)"api").slash("submit"), () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), request -> {
            logger.debug("/api/submit called {}", request);
            try {
                MantisJobDefinition mjd = Jackson.fromJSON(request, MantisJobDefinition.class);
                logger.debug("job submit request {}", (Object)mjd);
                mjd.validate(true);
                Pair<Boolean, String> validationResult = this.validateSubmitJobRequest(mjd);
                if (!((Boolean)validationResult.first()).booleanValue()) {
                    this.jobClusterSubmitError.increment();
                    return this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"" + (String)validationResult.second() + "\"}");
                }
                this.jobClusterSubmit.increment();
                return this.completeWithFuture(this.jobClusterRouteHandler.submit(JobClusterProtoAdapter.toSubmitJobClusterRequest(mjd)).thenApply(this::toHttpResponse));
            }
            catch (Exception e) {
                logger.warn("exception in submit job request {}", request, (Object)e);
                this.jobClusterSubmitError.increment();
                return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "{\"error\": \"" + e.getMessage() + "\"}");
            }
        }))), this.pathPrefix(API_V0_JOBCLUSTER, () -> this.route(new Route[]{this.post(() -> this.route(new Route[]{this.path("create", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), jobClusterDefn -> {
            logger.debug("/api/namedjob/create called {}", jobClusterDefn);
            try {
                NamedJobDefinition namedJobDefinition = Jackson.fromJSON(jobClusterDefn, NamedJobDefinition.class);
                if (namedJobDefinition == null || namedJobDefinition.getJobDefinition() == null || namedJobDefinition.getJobDefinition().getJobJarFileLocation() == null || namedJobDefinition.getJobDefinition().getName() == null || namedJobDefinition.getJobDefinition().getName().isEmpty()) {
                    logger.warn("JobCluster create request must include name and URL {}", jobClusterDefn);
                    return this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"Job definition must include name and URL\"}");
                }
                CompletionStage<JobClusterManagerProto.CreateJobClusterResponse> response = this.jobClusterRouteHandler.create(JobClusterProtoAdapter.toCreateJobClusterRequest(namedJobDefinition));
                this.jobClusterCreate.increment();
                return this.completeWithFuture(response.thenApply(r -> {
                    if ((r.responseCode == BaseResponse.ResponseCode.CLIENT_ERROR || r.responseCode == BaseResponse.ResponseCode.CLIENT_ERROR_CONFLICT) && r.message.contains("already exists")) {
                        return new JobClusterManagerProto.CreateJobClusterResponse(r.requestId, BaseResponse.ResponseCode.SERVER_ERROR, r.message, r.getJobClusterName());
                    }
                    return r;
                }).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error creating JobCluster {}", jobClusterDefn, (Object)e);
                this.jobClusterCreateError.increment();
                return this.complete(StatusCodes.BAD_REQUEST, "Can't read valid json in request: " + e.getMessage());
            }
            catch (Exception e) {
                logger.warn("Error creating JobCluster {}", jobClusterDefn, (Object)e);
                this.jobClusterCreateError.increment();
                return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "{\"error\": " + e.getMessage() + "}");
            }
        }))), this.path("update", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), jobClusterDefn -> {
            logger.debug("/api/namedjob/update called {}", jobClusterDefn);
            try {
                NamedJobDefinition namedJobDefinition = Jackson.fromJSON(jobClusterDefn, NamedJobDefinition.class);
                if (namedJobDefinition == null || namedJobDefinition.getJobDefinition() == null || namedJobDefinition.getJobDefinition().getJobJarFileLocation() == null || namedJobDefinition.getJobDefinition().getName() == null || namedJobDefinition.getJobDefinition().getName().isEmpty()) {
                    logger.warn("JobCluster update request must include name and URL {}", jobClusterDefn);
                    this.jobClusterCreateUpdateError.increment();
                    return this.complete(StatusCodes.BAD_REQUEST, "{\"error\": \"Job definition must include name and URL\"}");
                }
                CompletionStage<JobClusterManagerProto.UpdateJobClusterResponse> response = this.jobClusterRouteHandler.update(JobClusterProtoAdapter.toUpdateJobClusterRequest(namedJobDefinition));
                this.jobClusterCreateUpdate.increment();
                return this.completeWithFuture(response.thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error updating JobCluster {}", jobClusterDefn, (Object)e);
                this.jobClusterCreateUpdateError.increment();
                return this.complete(StatusCodes.BAD_REQUEST, "Can't read valid json in request: " + e.getMessage());
            }
            catch (Exception e) {
                logger.warn("Error updating JobCluster {}", jobClusterDefn, (Object)e);
                this.jobClusterCreateUpdateError.increment();
                return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "{\"error\": " + e.getMessage() + "}");
            }
        }))), this.path("delete", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), deleteReq -> {
            logger.debug("/api/namedjob/delete called {}", deleteReq);
            try {
                JobClusterManagerProto.DeleteJobClusterRequest deleteJobClusterRequest = Jackson.fromJSON(deleteReq, JobClusterManagerProto.DeleteJobClusterRequest.class);
                CompletionStage<JobClusterManagerProto.DeleteJobClusterResponse> response = this.jobClusterRouteHandler.delete(deleteJobClusterRequest);
                this.jobClusterDelete.increment();
                return this.completeWithFuture(response.thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error deleting JobCluster {}", deleteReq, (Object)e);
                this.jobClusterDeleteError.increment();
                return this.complete(StatusCodes.BAD_REQUEST, "Can't find valid json in request: " + e.getMessage());
            }
        }))), this.path("disable", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), request -> {
            logger.debug("/api/namedjob/disable called {}", request);
            try {
                JobClusterManagerProto.DisableJobClusterRequest disableJobClusterRequest = Jackson.fromJSON(request, JobClusterManagerProto.DisableJobClusterRequest.class);
                CompletionStage<JobClusterManagerProto.DisableJobClusterResponse> response = this.jobClusterRouteHandler.disable(disableJobClusterRequest);
                this.jobClusterDisable.increment();
                return this.completeWithFuture(response.thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error disabling JobCluster {}", request, (Object)e);
                this.jobClusterDisableError.increment();
                return this.complete(StatusCodes.BAD_REQUEST, "Can't find valid json in request: " + e.getMessage());
            }
        }))), this.path("enable", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), request -> {
            logger.debug("/api/namedjob/enable called {}", request);
            try {
                JobClusterManagerProto.EnableJobClusterRequest enableJobClusterRequest = Jackson.fromJSON(request, JobClusterManagerProto.EnableJobClusterRequest.class);
                CompletionStage<JobClusterManagerProto.EnableJobClusterResponse> response = this.jobClusterRouteHandler.enable(enableJobClusterRequest);
                this.jobClusterEnable.increment();
                return this.completeWithFuture(response.thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error enabling JobCluster {}", request, (Object)e);
                this.jobClusterEnableError.increment();
                return this.complete(StatusCodes.BAD_REQUEST, "Can't find valid json in request: " + e.getMessage());
            }
        }))), this.path("quickupdate", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), request -> {
            logger.debug("/api/namedjob/quickupdate called {}", request);
            try {
                JobClusterManagerProto.UpdateJobClusterArtifactRequest updateJobClusterArtifactRequest = Jackson.fromJSON(request, JobClusterManagerProto.UpdateJobClusterArtifactRequest.class);
                CompletionStage<JobClusterManagerProto.UpdateJobClusterArtifactResponse> response = this.jobClusterRouteHandler.updateArtifact(updateJobClusterArtifactRequest);
                this.jobClusterQuickupdate.increment();
                return this.completeWithFuture(response.thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error on quickupdate for JobCluster {}", request, (Object)e);
                this.jobClusterQuickupdateError.increment();
                return this.complete(StatusCodes.BAD_REQUEST, "Can't find valid json in request: " + e.getMessage());
            }
        }))), this.path("updatelabels", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), request -> {
            logger.debug("/api/namedjob/updatelabels called {}", request);
            try {
                JobClusterManagerProto.UpdateJobClusterLabelsRequest updateJobClusterLabelsRequest = Jackson.fromJSON(request, JobClusterManagerProto.UpdateJobClusterLabelsRequest.class);
                this.jobClusterUpdateLabel.increment();
                return this.completeWithFuture(this.jobClusterRouteHandler.updateLabels(updateJobClusterLabelsRequest).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error updating labels for JobCluster {}", request, (Object)e);
                this.jobClusterUpdateLabelError.increment();
                return this.complete(StatusCodes.BAD_REQUEST, "Can't find valid json in request: " + e.getMessage());
            }
        }))), this.path("updatesla", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), request -> {
            logger.debug("/api/namedjob/updatesla called {}", request);
            this.jobClusterUpdateSla.increment();
            try {
                JobClusterManagerProto.UpdateJobClusterSLARequest updateJobClusterSLARequest = Jackson.fromJSON(request, JobClusterManagerProto.UpdateJobClusterSLARequest.class);
                return this.completeWithFuture(this.jobClusterRouteHandler.updateSLA(updateJobClusterSLARequest).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error updating SLA for JobCluster {}", request, (Object)e);
                this.jobClusterUpdateSlaError.increment();
                return this.complete(StatusCodes.BAD_REQUEST, "Can't find valid json in request: " + e.getMessage());
            }
        }))), this.path("migratestrategy", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), request -> {
            logger.debug("/api/namedjob/migratestrategy called {}", request);
            try {
                JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyRequest updateMigrateStrategyReq = Jackson.fromJSON(request, JobClusterManagerProto.UpdateJobClusterWorkerMigrationStrategyRequest.class);
                return this.completeWithFuture(this.jobClusterRouteHandler.updateWorkerMigrateStrategy(updateMigrateStrategyReq).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error updating migrate strategy for JobCluster {}", request, (Object)e);
                return this.complete(StatusCodes.BAD_REQUEST, "Can't find valid json in request: " + e.getMessage());
            }
        }))), this.path("quicksubmit", () -> this.decodeRequest(() -> this.entity(Unmarshaller.entityToString(), request -> {
            logger.debug("/api/namedjob/quicksubmit called {}", request);
            try {
                JobClusterManagerProto.SubmitJobRequest submitJobRequest = Jackson.fromJSON(request, JobClusterManagerProto.SubmitJobRequest.class);
                return this.completeWithFuture(this.jobClusterRouteHandler.submit(submitJobRequest).thenApply(this::toHttpResponse));
            }
            catch (IOException e) {
                logger.warn("Error on quick submit for JobCluster {}", request, (Object)e);
                return this.complete(StatusCodes.BAD_REQUEST, "Can't find valid json in request: " + e.getMessage());
            }
        })))})), this.get(() -> this.route(new Route[]{this.pathPrefix("list", () -> this.route(new Route[]{this.pathEndOrSingleSlash(() -> {
            logger.debug("/api/namedjob/list called");
            this.jobClusterListGET.increment();
            return CachingDirectives.alwaysCache(this.cache, this.requestUriKeyer, () -> this.extractUri(uri -> this.completeAsync(this.jobClusterRouteHandler.getAllJobClusters(new JobClusterManagerProto.ListJobClustersRequest()), resp -> this.completeOK(resp.getJobClusters().stream().map(jobClusterMetadataView -> JobClusterProtoAdapter.toJobClusterInfo(jobClusterMetadataView)).collect(Collectors.toList()), Jackson.marshaller()), resp -> this.completeOK(Collections.emptyList(), Jackson.marshaller()))));
        }), this.path(PathMatchers.segment(), jobCluster -> {
            if (logger.isDebugEnabled()) {
                logger.debug("/api/namedjob/list/{} called", jobCluster);
            }
            this.jobClusterListClusterGET.increment();
            return this.completeAsync(this.jobClusterRouteHandler.getJobClusterDetails(new JobClusterManagerProto.GetJobClusterRequest((String)jobCluster)), resp -> this.completeOK(resp.getJobCluster().map(jc -> Arrays.asList(jc)).orElse(Collections.emptyList()), Jackson.marshaller()), resp -> this.completeOK(Collections.emptyList(), Jackson.marshaller()));
        })})), this.path(PathMatchers.segment((String)"listJobIds").slash(PathMatchers.segment()), jobCluster -> {
            logger.debug("/api/namedjob/listJobIds/{} called", jobCluster);
            this.jobClusterListJobIdGET.increment();
            return this.jobClusterListRoute((String)jobCluster);
        }), this.path("listJobIds", () -> {
            logger.debug("/api/namedjob/listJobIds called");
            return this.complete(StatusCodes.BAD_REQUEST, "Specify the Job cluster name '/api/namedjob/listJobIds/<JobClusterName>' to list the job Ids");
        })}))}))});
    }

    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating routes");
        ExceptionHandler genericExceptionHandler = ExceptionHandler.newBuilder().match(Exception.class, e -> {
            logger.error("got exception", (Throwable)e);
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "{\"error\": \"" + e.getMessage() + "\"}");
        }).build();
        return this.respondWithHeaders(DEFAULT_RESPONSE_HEADERS, () -> this.handleExceptions(genericExceptionHandler, () -> (Route)routeFilter.apply(this.getJobClusterRoutes())));
    }
}

