/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import akka.actor.ActorSystem;
import akka.http.caching.LfuCache;
import akka.http.caching.javadsl.Cache;
import akka.http.caching.javadsl.CachingSettings;
import akka.http.caching.javadsl.LfuCacheSettings;
import akka.http.javadsl.model.ContentType;
import akka.http.javadsl.model.ContentTypes;
import akka.http.javadsl.model.HttpEntities;
import akka.http.javadsl.model.HttpHeader;
import akka.http.javadsl.model.HttpMethods;
import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.model.RequestEntity;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.Uri;
import akka.http.javadsl.server.AllDirectives;
import akka.http.javadsl.server.ExceptionHandler;
import akka.http.javadsl.server.RequestContext;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.RouteResult;
import akka.http.javadsl.server.directives.RouteAdapter;
import akka.japi.JavaPartialFunction;
import akka.japi.pf.PFBuilder;
import akka.pattern.AskTimeoutException;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.MasterApiMetrics;
import io.mantisrx.master.api.akka.route.v1.HttpRequestMetrics;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.server.master.resourcecluster.RequestThrottledException;
import io.mantisrx.server.master.resourcecluster.ResourceCluster;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.FilterProvider;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.mantisrx.shaded.com.google.common.base.Strings;
import io.mantisrx.shaded.com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

abstract class BaseRoute
extends AllDirectives {
    private static final Logger logger = LoggerFactory.getLogger(BaseRoute.class);
    public static final String TOPLEVEL_FILTER = "topLevelFilter";
    public static final String JOBMETADATA_FILTER = "jobMetadata";
    public static final String STAGEMETADATA_FILTER = "stageMetadataList";
    public static final String WORKERMETADATA_FILTER = "workerMetadataList";
    private static final HttpHeader ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = HttpHeader.parse((String)"Access-Control-Allow-Origin", (String)"*");
    private static final Iterable<HttpHeader> DEFAULT_RESPONSE_HEADERS = Arrays.asList(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
    protected final JavaPartialFunction<RequestContext, Uri> getRequestUriKeyer = new JavaPartialFunction<RequestContext, Uri>(){

        public Uri apply(RequestContext in, boolean isCheck) {
            boolean isGet;
            HttpRequest request = in.getRequest();
            boolean bl = isGet = request.method() == HttpMethods.GET;
            if (isGet) {
                return request.getUri();
            }
            throw 1.noMatch();
        }
    };
    private String hostName;

    BaseRoute() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            this.hostName = "unknown";
        }
    }

    protected Cache<Uri, RouteResult> createCache(ActorSystem actorSystem, int initialCapacity, int maxCapacity, int ttlMillis) {
        CachingSettings defaultCachingSettings = CachingSettings.create((ActorSystem)actorSystem);
        LfuCacheSettings lfuCacheSettings = defaultCachingSettings.lfuCacheSettings().withInitialCapacity(initialCapacity).withMaxCapacity(maxCapacity).withTimeToLive((Duration)Duration.create((long)ttlMillis, (TimeUnit)TimeUnit.MILLISECONDS));
        CachingSettings cachingSettings = defaultCachingSettings.withLfuCacheSettings(lfuCacheSettings);
        return LfuCache.create((CachingSettings)cachingSettings);
    }

    protected abstract Route constructRoutes();

    public Route createRoute(Function<Route, Route> routeFilter) {
        ExceptionHandler jsonExceptionHandler = ExceptionHandler.newBuilder().match(Exception.class, x -> {
            logger.error("got exception", (Throwable)x);
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, this.generateFailureResponsePayload("caught exception: " + x.toString(), -1L));
        }).build();
        return this.respondWithHeaders(DEFAULT_RESPONSE_HEADERS, () -> this.handleExceptions(jsonExceptionHandler, () -> (Route)routeFilter.apply(this.constructRoutes())));
    }

    HttpResponse toDefaultHttpResponse(BaseResponse r) {
        switch (r.responseCode) {
            case SUCCESS: {
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, r.message)).withStatus(StatusCodes.OK);
            }
            case SUCCESS_CREATED: {
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, r.message)).withStatus(StatusCodes.CREATED);
            }
            case CLIENT_ERROR: {
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, this.generateFailureResponsePayload(r.message, r.requestId))).withStatus(StatusCodes.BAD_REQUEST);
            }
            case CLIENT_ERROR_NOT_FOUND: {
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, this.generateFailureResponsePayload(r.message, r.requestId))).withStatus(StatusCodes.NOT_FOUND);
            }
            case CLIENT_ERROR_CONFLICT: {
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, this.generateFailureResponsePayload(r.message, r.requestId))).withStatus(StatusCodes.CONFLICT);
            }
            case OPERATION_NOT_ALLOWED: {
                return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, this.generateFailureResponsePayload(r.message, r.requestId))).withStatus(StatusCodes.METHOD_NOT_ALLOWED);
            }
        }
        return ((HttpResponse)HttpResponse.create().withEntity((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, this.generateFailureResponsePayload(r.message, r.requestId))).withStatus(StatusCodes.INTERNAL_SERVER_ERROR);
    }

    <T extends BaseResponse> RouteAdapter completeAsync(CompletionStage<T> stage, Function<T, RouteAdapter> successTransform, String endpointName, HttpRequestMetrics.HttpVerb verb) {
        return this.completeAsync(stage, successTransform, r -> {
            HttpResponse response = this.toDefaultHttpResponse((BaseResponse)r);
            return this.complete(response.status(), (RequestEntity)HttpEntities.create((ContentType.NonBinary)ContentTypes.APPLICATION_JSON, (String)this.generateFailureResponsePayload(r.message, r.requestId)));
        }, endpointName, verb);
    }

    <T extends BaseResponse> RouteAdapter completeAsync(CompletionStage<T> stage, Function<T, RouteAdapter> successTransform, Function<T, RouteAdapter> clientFailureTransform, String endpointName, HttpRequestMetrics.HttpVerb verb) {
        return this.onComplete(stage, resp -> (Route)resp.map(r -> {
            HttpRequestMetrics.getInstance().incrementEndpointMetrics(endpointName, new Tag[]{new BasicTag("verb", verb.toString()), new BasicTag("responseCode", String.valueOf(r.responseCode.getValue()))});
            switch (r.responseCode) {
                case SUCCESS: 
                case SUCCESS_CREATED: {
                    MasterApiMetrics.getInstance().incrementResp2xx();
                    return (RouteAdapter)successTransform.apply(r);
                }
                case CLIENT_ERROR: 
                case CLIENT_ERROR_NOT_FOUND: 
                case CLIENT_ERROR_CONFLICT: 
                case OPERATION_NOT_ALLOWED: {
                    MasterApiMetrics.getInstance().incrementResp4xx();
                    return (RouteAdapter)clientFailureTransform.apply(r);
                }
            }
            MasterApiMetrics.getInstance().incrementResp5xx();
            logger.error("completeAsync default response code error: {}", (Object)r.message);
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, r.message);
        }).recover(new PFBuilder().match(AskTimeoutException.class, te -> {
            MasterApiMetrics.getInstance().incrementAskTimeOutCount();
            MasterApiMetrics.getInstance().incrementResp5xx();
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, this.generateFailureResponsePayload(te.toString(), -1L));
        }).matchAny(ex -> {
            MasterApiMetrics.getInstance().incrementResp5xx();
            logger.error("completeAsync matchAny ex: ", ex);
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, this.generateFailureResponsePayload(ex.toString(), -1L));
        }).build()).get());
    }

    protected String generateFailureResponsePayload(String errorMsg, long requestId) {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put("time", System.currentTimeMillis());
        node.put("host", this.hostName);
        node.put("error", errorMsg);
        node.put("requestId", requestId);
        return node.toString();
    }

    FilterProvider parseFilter(String fields, String target) {
        if (Strings.isNullOrEmpty((String)fields)) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)target)) {
            target = TOPLEVEL_FILTER;
        }
        HashSet filtersSet = Sets.newHashSet();
        StringTokenizer st = new StringTokenizer(fields, ",");
        while (st.hasMoreTokens()) {
            filtersSet.add(st.nextToken().trim());
        }
        return new SimpleFilterProvider().addFilter(TOPLEVEL_FILTER, TOPLEVEL_FILTER.equalsIgnoreCase(target) ? SimpleBeanPropertyFilter.filterOutAllExcept((Set)filtersSet) : SimpleBeanPropertyFilter.filterOutAllExcept((String[])new String[]{target})).addFilter(JOBMETADATA_FILTER, JOBMETADATA_FILTER.equalsIgnoreCase(target) ? SimpleBeanPropertyFilter.filterOutAllExcept((Set)filtersSet) : SimpleBeanPropertyFilter.serializeAll()).addFilter(STAGEMETADATA_FILTER, STAGEMETADATA_FILTER.equalsIgnoreCase(target) ? SimpleBeanPropertyFilter.filterOutAllExcept((Set)filtersSet) : SimpleBeanPropertyFilter.serializeAll()).addFilter(WORKERMETADATA_FILTER, WORKERMETADATA_FILTER.equalsIgnoreCase(target) ? SimpleBeanPropertyFilter.filterOutAllExcept((Set)filtersSet) : SimpleBeanPropertyFilter.serializeAll());
    }

    Integer parseInteger(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            return null;
        }
        return Integer.valueOf(val);
    }

    Boolean parseBoolean(String val) {
        if (Strings.isNullOrEmpty((String)val)) {
            return null;
        }
        return Boolean.valueOf(val);
    }

    protected <T> Route withFuture(CompletableFuture<T> tFuture) {
        return this.onComplete(tFuture, t -> (Route)t.fold(throwable -> {
            if (throwable instanceof ResourceCluster.TaskExecutorNotFoundException) {
                MasterApiMetrics.getInstance().incrementResp4xx();
                return this.complete(StatusCodes.NOT_FOUND);
            }
            if (throwable instanceof RequestThrottledException) {
                MasterApiMetrics.getInstance().incrementResp4xx();
                MasterApiMetrics.getInstance().incrementThrottledRequestCount();
                return this.complete(StatusCodes.TOO_MANY_REQUESTS);
            }
            if (throwable instanceof AskTimeoutException) {
                MasterApiMetrics.getInstance().incrementAskTimeOutCount();
            }
            MasterApiMetrics.getInstance().incrementResp5xx();
            logger.error("withFuture error: ", throwable);
            return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, throwable, Jackson.marshaller());
        }, r -> this.complete(StatusCodes.OK, r, Jackson.marshaller())));
    }
}

