/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.spectator.MetricId;
import io.mantisrx.common.metrics.spectator.SpectatorRegistryFactory;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.collect.Sets;
import java.util.Set;

public class HttpRequestMetrics {
    private final Registry registry = SpectatorRegistryFactory.getRegistry();
    private static String METRIC_GROUP_ID = "apiv1";
    private static HttpRequestMetrics instance;

    private HttpRequestMetrics() {
    }

    public static HttpRequestMetrics getInstance() {
        if (instance == null) {
            instance = new HttpRequestMetrics();
        }
        return instance;
    }

    public void incrementEndpointMetrics(String endpoint, Tag ... tags) {
        Preconditions.checkArgument((boolean)Endpoints.endpointSet.contains(endpoint), (Object)String.format("endpoint %s is not valid", endpoint));
        MetricId id = new MetricId(METRIC_GROUP_ID, endpoint, tags);
        this.registry.counter(id.getSpectatorId(this.registry)).increment();
    }

    public static class Endpoints {
        public static final String JOB_ARTIFACTS = "api.v1.jobArtifacts";
        public static final String JOB_ARTIFACTS_NAMES = "api.v1.jobArtifacts.names";
        public static final String JOB_CLUSTERS = "api.v1.jobClusters";
        public static final String JOB_CLUSTER_INSTANCE = "api.v1.jobClusters.instance";
        public static final String JOB_CLUSTER_INSTANCE_LATEST_JOB_DISCOVERY_INFO = "api.v1.jobClusters.instance.latestJobDiscoveryInfo";
        public static final String JOB_CLUSTER_INSTANCE_ACTION_UPDATE_ARTIFACT = "api.v1.jobClusters.instance.actions.updateArtifact";
        public static final String JOB_CLUSTER_INSTANCE_SCHEDULING_INFO_UPDATE = "api.v1.jobClusters.instance.actions.updateSchedulingInfo";
        public static final String JOB_CLUSTER_INSTANCE_ACTION_UPDATE_SLA = "api.v1.jobClusters.instance.actions.updateSla";
        public static final String JOB_CLUSTER_INSTANCE_ACTION_UPDATE_MIGRATION_STRATEGY = "api.v1.jobClusters.instance.actions.updateMigrationStrategy";
        public static final String JOB_CLUSTER_INSTANCE_ACTION_UPDATE_LABEL = "api.v1.jobClusters.instance.actions.updateLabel";
        public static final String JOB_CLUSTER_INSTANCE_ACTION_ENABLE_CLUSTER = "api.v1.jobClusters.instance.actions.enableCluster";
        public static final String JOB_CLUSTER_INSTANCE_ACTION_DISABLE_CLUSTER = "api.v1.jobClusters.instance.actions.disableCluster";
        public static final String JOBS = "api.v1.jobs";
        public static final String JOB_CLUSTER_INSTANCE_JOBS = "api.v1.jobClusters.instance.jobs";
        public static final String JOB_INSTANCE = "api.v1.jobs.instance";
        public static final String JOB_INSTANCE_ARCHIVED_WORKERS = "api.v1.jobs.instance.archivedWorkers";
        public static final String JOB_CLUSTER_INSTANCE_JOB_INSTANCE = "api.v1.jobClusters.instance.jobs.instance";
        public static final String JOB_CLUSTER_INSTANCE_JOB_INSTANCE_ARCHIVED = "api.v1.jobClusters.instance.jobs.instance.archived";
        public static final String JOBS_ACTION_QUICKSUBMIT = "api.v1.jobs.actions.quickSubmit";
        public static final String JOBS_ACTION_POST_JOB_STATUS = "api.v1.jobs.actions.postJobStatus";
        public static final String JOB_INSTANCE_ACTION_SCALE_STAGE = "api.v1.jobs.instance.actions.scaleStage";
        public static final String JOB_INSTANCE_ACTION_RESUBMIT_WORKER = "api.v1.jobs.instance.actions.resubmitWorker";
        public static final String MASTER_INFO = "api.v1.masterInfo";
        public static final String MASTER_CONFIGS = "api.v1.masterConfigs";
        public static final String AGENT_CLUSTERS = "api.v1.agentClusters";
        public static final String AGENT_CLUSTERS_JOBS = "api.v1.agentClusters.jobs";
        public static final String AGENT_CLUSTERS_AUTO_SCALE_POLICY = "api.v1.agentClusters.autoScalePolicy";
        public static final String JOB_STATUS_STREAM = "api.v1.jobStatusStream.instance";
        public static final String JOB_DISCOVERY_STREAM = "api.v1.jobDiscoveryStream.instance";
        public static final String LAST_SUBMITTED_JOB_ID_STREAM = "api.v1.lastSubmittedJobIdStream.instance";
        public static final String RESOURCE_CLUSTERS = "api.v1.resourceClusters";
        private static String[] endpoints = new String[]{"api.v1.jobArtifacts", "api.v1.jobArtifacts.names", "api.v1.jobClusters", "api.v1.jobClusters.instance", "api.v1.jobClusters.instance.latestJobDiscoveryInfo", "api.v1.jobClusters.instance.actions.updateArtifact", "api.v1.jobClusters.instance.actions.updateSla", "api.v1.jobClusters.instance.actions.updateMigrationStrategy", "api.v1.jobClusters.instance.actions.updateLabel", "api.v1.jobClusters.instance.actions.enableCluster", "api.v1.jobClusters.instance.actions.disableCluster", "api.v1.jobs", "api.v1.jobClusters.instance.jobs", "api.v1.jobs.instance", "api.v1.jobs.instance.archivedWorkers", "api.v1.jobClusters.instance.jobs.instance", "api.v1.jobClusters.instance.jobs.instance.archived", "api.v1.jobs.actions.quickSubmit", "api.v1.jobs.actions.postJobStatus", "api.v1.jobs.instance.actions.scaleStage", "api.v1.jobs.instance.actions.resubmitWorker", "api.v1.masterInfo", "api.v1.masterConfigs", "api.v1.agentClusters", "api.v1.agentClusters.jobs", "api.v1.agentClusters.autoScalePolicy", "api.v1.jobStatusStream.instance", "api.v1.jobDiscoveryStream.instance", "api.v1.lastSubmittedJobIdStream.instance", "api.v1.resourceClusters"};
        private static Set<String> endpointSet = Sets.newHashSet((Object[])endpoints);
    }

    public static enum HttpVerb {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

