/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import akka.NotUsed;
import akka.http.javadsl.model.ws.Message;
import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Route;
import akka.stream.javadsl.Flow;
import com.netflix.spectator.api.Tag;
import io.mantisrx.master.api.akka.route.handlers.JobStatusRouteHandler;
import io.mantisrx.master.api.akka.route.v1.BaseRoute;
import io.mantisrx.master.api.akka.route.v1.HttpRequestMetrics;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusStreamRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(JobStatusStreamRoute.class);
    private final JobStatusRouteHandler jobStatusRouteHandler;
    private static final PathMatcher0 JOBSTATUS_API_PREFIX = PathMatchers.segment((String)"api").slash("v1");

    public JobStatusStreamRoute(JobStatusRouteHandler jobStatusRouteHandler) {
        this.jobStatusRouteHandler = jobStatusRouteHandler;
    }

    @Override
    protected Route constructRoutes() {
        return this.pathPrefix(JOBSTATUS_API_PREFIX, () -> this.concat(this.path(PathMatchers.segment((String)"jobStatusStream").slash(PathMatchers.segment()), jobId -> this.get(() -> this.getJobStatusStreamRoute((String)jobId))), new Route[0]));
    }

    @Override
    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating /api/v1/jobStatusStream routes");
        return super.createRoute(routeFilter);
    }

    private Route getJobStatusStreamRoute(String jobId) {
        logger.info("/api/v1/jobStatusStream/{} called", (Object)jobId);
        HttpRequestMetrics.getInstance().incrementEndpointMetrics("api.v1.jobStatusStream.instance", new Tag[0]);
        Flow<Message, Message, NotUsed> webSocketFlow = this.jobStatusRouteHandler.jobStatus(jobId);
        return this.handleWebSocketMessages(webSocketFlow);
    }
}

