/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import akka.actor.ActorSystem;
import akka.http.caching.javadsl.Cache;
import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.Uri;
import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatcher1;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.RouteResult;
import akka.http.javadsl.server.directives.CachingDirectives;
import akka.http.javadsl.unmarshalling.StringUnmarshallers;
import akka.japi.Pair;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.handlers.JobClusterRouteHandler;
import io.mantisrx.master.api.akka.route.handlers.JobRouteHandler;
import io.mantisrx.master.api.akka.route.proto.JobClusterProtoAdapter;
import io.mantisrx.master.api.akka.route.utils.JobRouteUtils;
import io.mantisrx.master.api.akka.route.v1.BaseRoute;
import io.mantisrx.master.api.akka.route.v1.HttpRequestMetrics;
import io.mantisrx.master.api.akka.route.v1.ParamName;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.MantisJobMetadataView;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.jobcluster.proto.JobClusterManagerProto;
import io.mantisrx.runtime.MantisJobDefinition;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.runtime.descriptor.StageSchedulingInfo;
import io.mantisrx.server.core.PostJobStatusRequest;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.server.master.domain.DataFormatAdapter;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.http.api.CompactJobInfo;
import io.mantisrx.server.master.store.MantisWorkerMetadataWritable;
import io.mantisrx.shaded.com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.PartialFunction;

public class JobsRoute
extends BaseRoute {
    private static final Logger logger = LoggerFactory.getLogger(JobsRoute.class);
    private static final PathMatcher0 JOBS_API_PREFIX = PathMatchers.segment((String)"api").slash("v1").slash("jobs");
    private static final PathMatcher1<String> CLUSTER_JOBS_API_PREFIX = PathMatchers.segment((String)"api").slash("v1").slash("jobClusters").slash(PathMatchers.segment()).slash("jobs");
    private final JobRouteHandler jobRouteHandler;
    private final JobClusterRouteHandler clusterRouteHandler;
    private final MasterConfiguration config;
    private final Cache<Uri, RouteResult> routeResultCache;

    public JobsRoute(JobClusterRouteHandler clusterRouteHandler, JobRouteHandler jobRouteHandler, ActorSystem actorSystem) {
        this.jobRouteHandler = jobRouteHandler;
        this.clusterRouteHandler = clusterRouteHandler;
        this.config = ConfigurationProvider.getConfig();
        this.routeResultCache = this.createCache(actorSystem, this.config.getApiCacheMinSize(), this.config.getApiCacheMaxSize(), this.config.getApiCacheTtlMilliseconds());
    }

    @Override
    public Route constructRoutes() {
        return this.concat(this.pathPrefix(JOBS_API_PREFIX, () -> this.concat(this.pathEndOrSingleSlash(() -> this.concat(this.get(this::getJobsRoute), new Route[]{this.post(this::postJobsRoute)})), new Route[]{this.path(PathMatchers.segment(), jobId -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getJobInstanceRoute((String)jobId)), new Route[]{this.delete(() -> this.deleteJobInstanceRoute((String)jobId)), this.post(() -> this.complete(StatusCodes.METHOD_NOT_ALLOWED))}))), this.path(PathMatchers.segment().slash("archivedWorkers"), jobId -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getArchivedWorkers((String)jobId)), new Route[0]))), this.path(PathMatchers.segment((String)"actions").slash("quickSubmit"), () -> this.pathEndOrSingleSlash(() -> this.post(this::postJobInstanceQuickSubmitRoute))), this.path(PathMatchers.segment((String)"actions").slash("postJobStatus"), () -> this.pathEndOrSingleSlash(() -> this.post(this::postJobStatusRoute))), this.path(PathMatchers.segment().slash("actions").slash("scaleStage"), jobId -> this.pathEndOrSingleSlash(() -> this.post(() -> this.postJobInstanceScaleStageRoute((String)jobId)))), this.path(PathMatchers.segment().slash("actions").slash("resubmitWorker"), jobId -> this.pathEndOrSingleSlash(() -> this.post(() -> this.postJobInstanceResubmitWorkerRoute((String)jobId))))})), new Route[]{this.pathPrefix(CLUSTER_JOBS_API_PREFIX, cluster -> this.concat(this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getJobsRoute(Optional.of(cluster))), new Route[]{this.post(() -> this.postJobsRoute(Optional.of(cluster)))})), new Route[]{this.path(PathMatchers.segment(), jobId -> this.pathEndOrSingleSlash(() -> this.concat(this.get(() -> this.getJobInstanceRoute(Optional.of(cluster), (String)jobId)), new Route[]{this.post(() -> this.complete(StatusCodes.METHOD_NOT_ALLOWED))})))}))});
    }

    @Override
    public Route createRoute(Function<Route, Route> routeFilter) {
        logger.info("creating /api/v1/jobs routes");
        return super.createRoute(routeFilter);
    }

    private Route getJobsRoute() {
        return this.getJobsRoute(Optional.empty());
    }

    private Route getJobsRoute(Optional<String> clusterName) {
        return this.parameterOptional(StringUnmarshallers.INTEGER, ParamName.PAGINATION_LIMIT, pageSize -> this.parameterOptional(StringUnmarshallers.INTEGER, ParamName.PAGINATION_OFFSET, offset -> this.parameterOptional(StringUnmarshallers.BOOLEAN, ParamName.SORT_ASCENDING, ascending -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.SORT_BY, sortField -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.PROJECTION_FIELDS, fields -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.PROJECTION_TARGET, target -> this.parameterOptional(StringUnmarshallers.BOOLEAN, ParamName.JOB_COMPACT, isCompact -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.JOB_FILTER_MATCH, matching -> this.parameterMultiMap(params -> CachingDirectives.alwaysCache(this.routeResultCache, (PartialFunction)this.getRequestUriKeyer, () -> this.extractUri(uri -> {
            String endpoint;
            if (clusterName.isPresent()) {
                logger.debug("GET /api/v1/jobClusters/{}/jobs called", (Object)clusterName);
                endpoint = "api.v1.jobClusters.instance.jobs";
            } else {
                logger.debug("GET /api/v1/jobs called");
                endpoint = "api.v1.jobs";
            }
            JobClusterManagerProto.ListJobsRequest listJobsRequest = JobRouteUtils.createListJobsRequest(params, clusterName.map(s -> Optional.of("^" + s + "$")).orElse((Optional)matching), true);
            return this.completeAsync(this.jobRouteHandler.listJobs(listJobsRequest), resp -> this.completeOK(isCompact.isPresent() && (Boolean)isCompact.get() != false ? resp.getJobList(JobClusterProtoAdapter::toCompactJobInfo, CompactJobInfo.class, pageSize.orElse(null), offset.orElse(null), sortField.orElse(null), ascending.orElse(null), (Uri)uri) : resp.getJobList(pageSize.orElse(null), offset.orElse(null), sortField.orElse(null), ascending.orElse(null), (Uri)uri), Jackson.marshaller(super.parseFilter(fields.orElse(null), target.orElse(null)))), endpoint, HttpRequestMetrics.HttpVerb.GET);
        })))))))))));
    }

    private Route postJobsRoute() {
        return this.postJobsRoute(Optional.empty());
    }

    private Route postJobsRoute(Optional<String> clusterName) {
        return this.decodeRequest(() -> this.entity(Jackson.unmarshaller(MantisJobDefinition.class), submitJobRequest -> {
            String endpoint;
            if (clusterName.isPresent()) {
                logger.info("POST /api/v1/jobClusters/{}/jobs called {}", (Object)clusterName);
                endpoint = "api.v1.jobClusters.instance.jobs";
            } else {
                logger.info("POST /api/v1/jobs called {}", submitJobRequest);
                endpoint = "api.v1.jobs";
            }
            CompletionStage<JobClusterManagerProto.SubmitJobResponse> response = null;
            try {
                submitJobRequest.validate(true);
                Pair<Boolean, String> validationResult = this.validateSubmitJobRequest((MantisJobDefinition)submitJobRequest, clusterName);
                if (!((Boolean)validationResult.first()).booleanValue()) {
                    CompletableFuture<JobClusterManagerProto.SubmitJobResponse> resp2 = new CompletableFuture<JobClusterManagerProto.SubmitJobResponse>();
                    resp2.complete(new JobClusterManagerProto.SubmitJobResponse(-1L, BaseResponse.ResponseCode.CLIENT_ERROR, (String)validationResult.second(), Optional.empty()));
                    response = resp2;
                } else {
                    response = this.clusterRouteHandler.submit(JobClusterProtoAdapter.toSubmitJobClusterRequest(submitJobRequest));
                }
            }
            catch (Exception e) {
                logger.warn("exception in submit job request {}", submitJobRequest, (Object)e);
                CompletableFuture<JobClusterManagerProto.SubmitJobResponse> resp3 = new CompletableFuture<JobClusterManagerProto.SubmitJobResponse>();
                resp3.complete(new JobClusterManagerProto.SubmitJobResponse(-1L, BaseResponse.ResponseCode.SERVER_ERROR, e.getMessage(), Optional.empty()));
                response = resp3;
            }
            CompletionStage r = response.thenCompose(t -> {
                if (t.responseCode.getValue() >= 200 && t.responseCode.getValue() < 300) {
                    JobClusterManagerProto.GetJobDetailsRequest request = new JobClusterManagerProto.GetJobDetailsRequest(submitJobRequest.getUser(), t.getJobId().get());
                    return this.jobRouteHandler.getJobDetails(request);
                }
                CompletableFuture<JobClusterManagerProto.GetJobDetailsResponse> responseCompletableFuture = new CompletableFuture<JobClusterManagerProto.GetJobDetailsResponse>();
                responseCompletableFuture.complete(new JobClusterManagerProto.GetJobDetailsResponse(t.requestId, t.responseCode, t.message, Optional.empty()));
                return responseCompletableFuture;
            });
            return this.completeAsync(r, resp -> this.complete(StatusCodes.CREATED, resp.getJobMetadata().map(metaData -> new MantisJobMetadataView((IMantisJobMetadata)metaData, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false)), Jackson.marshaller()), endpoint, HttpRequestMetrics.HttpVerb.POST);
        }));
    }

    private Route getJobInstanceRoute(String jobId) {
        return this.getJobInstanceRoute(Optional.empty(), jobId);
    }

    private Route getJobInstanceRoute(Optional<String> clusterName, String jobId) {
        String endpoint;
        if (clusterName.isPresent()) {
            logger.info("GET /api/v1/jobClusters/{}/jobs/{} called", (Object)clusterName.get(), (Object)jobId);
            endpoint = "api.v1.jobClusters.instance.jobs";
        } else {
            logger.info("GET /api/v1/jobs/{} called", (Object)jobId);
            endpoint = "api.v1.jobs";
        }
        return this.parameterOptional(StringUnmarshallers.STRING, ParamName.PROJECTION_FIELDS, fields -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.PROJECTION_TARGET, target -> this.completeAsync(this.jobRouteHandler.getJobDetails(new JobClusterManagerProto.GetJobDetailsRequest("masterAPI", jobId)).thenCompose(r -> {
            CompletableFuture<JobClusterManagerProto.GetJobDetailsResponse> resp = new CompletableFuture<JobClusterManagerProto.GetJobDetailsResponse>();
            if (r.responseCode.getValue() >= 200 && r.responseCode.getValue() < 300 && clusterName.isPresent() && r.getJobMetadata().isPresent()) {
                if (!((String)clusterName.get()).equals(r.getJobMetadata().get().getClusterName())) {
                    String msg = String.format("JobId [%s] exists but does not belong to specified cluster [%s]", jobId, clusterName.get());
                    resp.complete(new JobClusterManagerProto.GetJobDetailsResponse(r.requestId, BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND, msg, Optional.empty()));
                } else {
                    resp.complete((JobClusterManagerProto.GetJobDetailsResponse)r);
                }
            } else {
                resp.complete((JobClusterManagerProto.GetJobDetailsResponse)r);
            }
            return resp;
        }), resp -> this.complete(StatusCodes.OK, resp.getJobMetadata().map(metaData -> new MantisJobMetadataView((IMantisJobMetadata)metaData, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false)), Jackson.marshaller(super.parseFilter(fields.orElse(null), target.orElse(null)))), endpoint, HttpRequestMetrics.HttpVerb.GET)));
    }

    private Route getArchivedWorkers(String jobId) {
        logger.info("GET /api/v1/jobs/{}/archivedWorkers called", (Object)jobId);
        Optional<JobId> parsedJobId = JobId.fromId(jobId);
        if (!parsedJobId.isPresent()) {
            return this.complete(StatusCodes.BAD_REQUEST, super.generateFailureResponsePayload("Invalid jobId in URI", -1L));
        }
        return this.parameterOptional(StringUnmarshallers.INTEGER, ParamName.PAGINATION_LIMIT, pageSize -> this.parameterOptional(StringUnmarshallers.INTEGER, ParamName.PAGINATION_OFFSET, offset -> this.parameterOptional(StringUnmarshallers.BOOLEAN, ParamName.SORT_ASCENDING, ascending -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.SORT_BY, sortField -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.PROJECTION_FIELDS, fields -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.PROJECTION_TARGET, target -> this.parameterOptional(StringUnmarshallers.INTEGER, ParamName.SERVER_FILTER_LIMIT, limit -> this.parameterMultiMap(params -> this.extractUri(uri -> {
            JobClusterManagerProto.ListArchivedWorkersRequest req = new JobClusterManagerProto.ListArchivedWorkersRequest((JobId)parsedJobId.get(), limit.orElse(100));
            return this.completeAsync(this.jobRouteHandler.listArchivedWorkers(req), resp -> this.completeOK(resp.getWorkerMetadata(DataFormatAdapter::convertMantisWorkerMetadataToMantisWorkerMetadataWritable, MantisWorkerMetadataWritable.class, pageSize.orElse(null), offset.orElse(null), sortField.orElse(null), ascending.orElse(null), (Uri)uri), Jackson.marshaller(super.parseFilter(fields.orElse(null), target.orElse(null)))), "api.v1.jobs.instance.archivedWorkers", HttpRequestMetrics.HttpVerb.GET);
        })))))))));
    }

    private Route deleteJobInstanceRoute(String jobId) {
        logger.info("DELETE /api/v1/jobs/{} called", (Object)jobId);
        return this.parameterOptional(StringUnmarshallers.STRING, ParamName.USER, user -> this.parameterOptional(StringUnmarshallers.STRING, ParamName.REASON, reason -> {
            String userStr = user.orElse(null);
            String reasonStr = reason.orElse(null);
            if (Strings.isNullOrEmpty((String)userStr)) {
                return this.complete(StatusCodes.BAD_REQUEST, "Missing required parameter 'user'");
            }
            if (Strings.isNullOrEmpty((String)reasonStr)) {
                return this.complete(StatusCodes.BAD_REQUEST, "Missing required parameter 'reason'");
            }
            return this.completeAsync(this.jobRouteHandler.kill(new JobClusterManagerProto.KillJobRequest(jobId, reasonStr, userStr)), resp -> this.complete(StatusCodes.ACCEPTED, ""), "api.v1.jobs.instance", HttpRequestMetrics.HttpVerb.DELETE);
        }));
    }

    private Route postJobInstanceQuickSubmitRoute() {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.SubmitJobRequest.class), request -> {
            logger.info("POST /api/v1/jobs/actions/quickSubmit called");
            CompletionStage response = this.clusterRouteHandler.submit((JobClusterManagerProto.SubmitJobRequest)request).thenCompose(t -> {
                if (t.responseCode.getValue() >= 200 && t.responseCode.getValue() < 300) {
                    return this.jobRouteHandler.getJobDetails(new JobClusterManagerProto.GetJobDetailsRequest(request.getSubmitter(), t.getJobId().get()));
                }
                CompletableFuture<JobClusterManagerProto.GetJobDetailsResponse> responseCompletableFuture = new CompletableFuture<JobClusterManagerProto.GetJobDetailsResponse>();
                responseCompletableFuture.complete(new JobClusterManagerProto.GetJobDetailsResponse(t.requestId, t.responseCode, t.message, Optional.empty()));
                return responseCompletableFuture;
            });
            return this.completeAsync(response, resp -> this.complete(StatusCodes.CREATED, resp.getJobMetadata().map(metaData -> new MantisJobMetadataView((IMantisJobMetadata)metaData, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false)), Jackson.marshaller()), "api.v1.jobs.actions.quickSubmit", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route postJobStatusRoute() {
        return this.entity(Jackson.unmarshaller(PostJobStatusRequest.class), request -> {
            logger.info("POST /api/v1/jobs/actions/postJobStatus called");
            return this.completeAsync(this.jobRouteHandler.workerStatus(JobRouteUtils.createWorkerStatusRequest(request)), resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobs.actions.postJobStatus", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route postJobInstanceScaleStageRoute(String jobId) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.ScaleStageRequest.class), request -> {
            logger.info("POST /api/v1/jobs/{}/actions/scaleStage called", (Object)jobId);
            CompletionStage<JobClusterManagerProto.ScaleStageResponse> response = null;
            int numWorkers = request.getNumWorkers();
            int maxWorkersPerStage = ConfigurationProvider.getConfig().getMaxWorkersPerStage();
            if (numWorkers > maxWorkersPerStage) {
                CompletableFuture<JobClusterManagerProto.ScaleStageResponse> responseCompletableFuture = new CompletableFuture<JobClusterManagerProto.ScaleStageResponse>();
                responseCompletableFuture.complete(new JobClusterManagerProto.ScaleStageResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, "num workers must be less than " + maxWorkersPerStage, -1));
                response = responseCompletableFuture;
            } else if (jobId.equals(request.getJobId().getId())) {
                response = this.jobRouteHandler.scaleStage((JobClusterManagerProto.ScaleStageRequest)request);
            } else {
                CompletableFuture<JobClusterManagerProto.ScaleStageResponse> responseCompletableFuture = new CompletableFuture<JobClusterManagerProto.ScaleStageResponse>();
                responseCompletableFuture.complete(new JobClusterManagerProto.ScaleStageResponse(request.requestId, BaseResponse.ResponseCode.CLIENT_ERROR, String.format("JobId specified in request payload [%s] does not match with resource uri [%s]", request.getJobId().getId(), jobId), -1));
                response = responseCompletableFuture;
            }
            return this.completeAsync(response, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobs.instance.actions.scaleStage", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Route postJobInstanceResubmitWorkerRoute(String jobId) {
        return this.entity(Jackson.unmarshaller(JobClusterManagerProto.V1ResubmitWorkerRequest.class), request -> {
            logger.info("POST /api/v1/jobs/{}/actions/resubmitWorker called", (Object)jobId);
            CompletionStage<JobClusterManagerProto.ResubmitWorkerResponse> response = this.jobRouteHandler.resubmitWorker(new JobClusterManagerProto.ResubmitWorkerRequest(jobId, request.getWorkerNum(), request.getUser(), request.getReason()));
            return this.completeAsync(response, resp -> this.complete(StatusCodes.NO_CONTENT, ""), "api.v1.jobs.instance.actions.resubmitWorker", HttpRequestMetrics.HttpVerb.POST);
        });
    }

    private Pair<Boolean, String> validateSubmitJobRequest(MantisJobDefinition mjd, Optional<String> clusterNameInResource) {
        Map stages;
        if (null == mjd) {
            logger.error("rejecting job submit request, job definition is malformed {}", (Object)mjd);
            return Pair.apply((Object)false, (Object)"Malformed job definition.");
        }
        if (mjd.getName() == null || mjd.getName().length() == 0) {
            logger.info("rejecting job submit request, must include name {}", (Object)mjd);
            return Pair.apply((Object)false, (Object)"Job definition must include name");
        }
        if (clusterNameInResource.isPresent() && !clusterNameInResource.get().equals(mjd.getName())) {
            String msg = String.format("Cluster name specified in request payload [%s] does not match with what specified in resource endpoint [%s]", mjd.getName(), clusterNameInResource.get());
            logger.info("rejecting job submit request, {} {}", (Object)msg, (Object)mjd);
            return Pair.apply((Object)false, (Object)msg);
        }
        SchedulingInfo schedulingInfo = mjd.getSchedulingInfo();
        if (schedulingInfo != null && (stages = schedulingInfo.getStages()) != null) {
            for (StageSchedulingInfo stageSchedInfo : stages.values()) {
                int maxWorkersPerStage;
                int maxNetworkMbps;
                int maxMemoryMB;
                int maxCpuCores;
                double cpuCores = stageSchedInfo.getMachineDefinition().getCpuCores();
                if (cpuCores > (double)(maxCpuCores = ConfigurationProvider.getConfig().getWorkerMachineDefinitionMaxCpuCores())) {
                    logger.info("rejecting job submit request, requested CPU {} > max for {} (user: {}) (stage: {})", new Object[]{cpuCores, mjd.getName(), mjd.getUser(), stages});
                    return Pair.apply((Object)false, (Object)("requested CPU cannot be more than max CPU per worker " + maxCpuCores));
                }
                double memoryMB = stageSchedInfo.getMachineDefinition().getMemoryMB();
                if (memoryMB > (double)(maxMemoryMB = ConfigurationProvider.getConfig().getWorkerMachineDefinitionMaxMemoryMB())) {
                    logger.info("rejecting job submit request, requested memory {} > max for {} (user: {}) (stage: {})", new Object[]{memoryMB, mjd.getName(), mjd.getUser(), stages});
                    return Pair.apply((Object)false, (Object)("requested memory cannot be more than max memoryMB per worker " + maxMemoryMB));
                }
                double networkMbps = stageSchedInfo.getMachineDefinition().getNetworkMbps();
                if (networkMbps > (double)(maxNetworkMbps = ConfigurationProvider.getConfig().getWorkerMachineDefinitionMaxNetworkMbps())) {
                    logger.info("rejecting job submit request, requested network {} > max for {} (user: {}) (stage: {})", new Object[]{networkMbps, mjd.getName(), mjd.getUser(), stages});
                    return Pair.apply((Object)false, (Object)("requested network cannot be more than max networkMbps per worker " + maxNetworkMbps));
                }
                int numberOfInstances = stageSchedInfo.getNumberOfInstances();
                if (numberOfInstances > (maxWorkersPerStage = ConfigurationProvider.getConfig().getMaxWorkersPerStage())) {
                    logger.info("rejecting job submit request, requested num instances {} > max for {} (user: {}) (stage: {})", new Object[]{numberOfInstances, mjd.getName(), mjd.getUser(), stages});
                    return Pair.apply((Object)false, (Object)("requested number of instances per stage cannot be more than " + maxWorkersPerStage));
                }
                StageScalingPolicy scalingPolicy = stageSchedInfo.getScalingPolicy();
                if (scalingPolicy == null || scalingPolicy.getMax() <= maxWorkersPerStage) continue;
                logger.info("rejecting job submit request, requested num instances in scaling policy {} > max for {} (user: {}) (stage: {})", new Object[]{numberOfInstances, mjd.getName(), mjd.getUser(), stages});
                return Pair.apply((Object)false, (Object)("requested number of instances per stage in scaling policy cannot be more than " + maxWorkersPerStage));
            }
        }
        return Pair.apply((Object)true, (Object)"");
    }
}

