/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.api.akka.route.v1;

import akka.http.javadsl.model.HttpRequest;
import akka.http.javadsl.model.HttpResponse;
import akka.http.javadsl.server.PathMatcher0;
import akka.http.javadsl.server.PathMatchers;
import akka.http.javadsl.server.Rejection;
import akka.http.javadsl.server.Route;
import akka.http.javadsl.server.directives.LogEntry;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.api.akka.route.v1.BaseRoute;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ResourceClusters;
import io.mantisrx.server.master.resourcecluster.TaskExecutorDisconnection;
import io.mantisrx.server.master.resourcecluster.TaskExecutorHeartbeat;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.server.master.resourcecluster.TaskExecutorStatusChange;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClustersLeaderExclusiveRoute
extends BaseRoute {
    private static final Logger log = LoggerFactory.getLogger(ResourceClustersLeaderExclusiveRoute.class);
    private static final PathMatcher0 RESOURCECLUSTERS_API_PREFIX = PathMatchers.segment((String)"api").slash("v1").slash("resourceClusters");
    private final ResourceClusters gateway;

    private Optional<LogEntry> onRequestCompletion(HttpRequest request, HttpResponse response) {
        log.debug("ResourceClustersLeaderExclusiveRoute: {} {}", (Object)request, (Object)response);
        return Optional.empty();
    }

    private Optional<LogEntry> onRequestRejection(HttpRequest request, List<Rejection> rejections) {
        return Optional.empty();
    }

    @Override
    protected Route constructRoutes() {
        return this.pathPrefix(RESOURCECLUSTERS_API_PREFIX, () -> this.logRequestResultOptional(this::onRequestCompletion, this::onRequestRejection, () -> this.concat(this.path(PathMatchers.segment().slash("actions").slash("registerTaskExecutor"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.registerTaskExecutor(this.getClusterID((String)clusterName))), new Route[0]))), new Route[]{this.path(PathMatchers.segment().slash("actions").slash("heartBeatFromTaskExecutor"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.heartbeatFromTaskExecutor(this.getClusterID((String)clusterName))), new Route[0]))), this.path(PathMatchers.segment().slash("actions").slash("notifyTaskExecutorStatusChange"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.notifyTaskExecutorStatusChange(this.getClusterID((String)clusterName))), new Route[0]))), this.path(PathMatchers.segment().slash("actions").slash("disconnectTaskExecutor"), clusterName -> this.pathEndOrSingleSlash(() -> this.concat(this.post(() -> this.disconnectTaskExecutor(this.getClusterID((String)clusterName))), new Route[0])))})));
    }

    private Route registerTaskExecutor(ClusterID clusterID) {
        return this.entity(Jackson.unmarshaller(TaskExecutorRegistration.class), request -> {
            log.info("POST /api/v1/resourceClusters/{}/actions/registerTaskExecutor called {}", (Object)clusterID, request);
            return this.withFuture(this.gateway.getClusterFor(clusterID).registerTaskExecutor(request));
        });
    }

    private Route heartbeatFromTaskExecutor(ClusterID clusterID) {
        return this.entity(Jackson.unmarshaller(TaskExecutorHeartbeat.class), request -> {
            log.debug("POST /api/v1/resourceClusters/{}/actions/heartbeatFromTaskExecutor called {}", (Object)clusterID.getResourceID(), request);
            return this.withFuture(this.gateway.getClusterFor(clusterID).heartBeatFromTaskExecutor(request));
        });
    }

    private Route disconnectTaskExecutor(ClusterID clusterID) {
        return this.entity(Jackson.unmarshaller(TaskExecutorDisconnection.class), request -> {
            log.info("POST /api/v1/resourceClusters/{}/actions/disconnectTaskExecutor called {}", (Object)clusterID.getResourceID(), request);
            return this.withFuture(this.gateway.getClusterFor(clusterID).disconnectTaskExecutor(request));
        });
    }

    private Route notifyTaskExecutorStatusChange(ClusterID clusterID) {
        return this.entity(Jackson.unmarshaller(TaskExecutorStatusChange.class), request -> {
            log.info("POST /api/v1/resourceClusters/{}/actions/notifyTaskExecutorStatusChange called {}", (Object)clusterID.getResourceID(), request);
            return this.withFuture(this.gateway.getClusterFor(clusterID).notifyTaskExecutorStatusChange(request));
        });
    }

    private ClusterID getClusterID(String clusterName) {
        return ClusterID.of((String)clusterName);
    }

    @ConstructorProperties(value={"gateway"})
    public ResourceClustersLeaderExclusiveRoute(ResourceClusters gateway) {
        this.gateway = gateway;
    }
}

