/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.events;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Terminated;
import io.mantisrx.master.api.akka.route.proto.JobStatus;
import io.mantisrx.master.events.StatusEventBrokerActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStatusConnectedWSActor
extends AbstractActor {
    private final Logger logger = LoggerFactory.getLogger(JobStatusConnectedWSActor.class);
    private final String jobId;
    private final ActorRef statusEventBrokerActor;

    public static Props props(String jobId, ActorRef statusEventBrokerActor) {
        return Props.create(JobStatusConnectedWSActor.class, (Object[])new Object[]{jobId, statusEventBrokerActor});
    }

    public JobStatusConnectedWSActor(String jobId, ActorRef statusEventBrokerActor) {
        this.jobId = jobId;
        this.statusEventBrokerActor = statusEventBrokerActor;
    }

    private final AbstractActor.Receive waitingBehavior() {
        return this.receiveBuilder().match(Connected.class, this::onConnected).build();
    }

    private void onConnected(Connected connectedMsg) {
        this.logger.info("connected {}", (Object)connectedMsg);
        this.statusEventBrokerActor.tell((Object)new StatusEventBrokerActor.JobStatusRequest(this.jobId), this.self());
        this.getContext().watch(connectedMsg.wsActor);
        AbstractActor.Receive connected = this.connectedBehavior(connectedMsg.wsActor);
        this.getContext().become(connected);
    }

    private void onTerminated(Terminated t) {
        this.logger.info("actor terminated {}", (Object)t);
        this.getSelf().tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
    }

    private AbstractActor.Receive connectedBehavior(ActorRef wsActor) {
        return this.receiveBuilder().match(JobStatus.class, js -> {
            this.logger.debug("writing to WS {}", js);
            wsActor.tell(js, this.self());
        }).match(Terminated.class, t -> this.onTerminated((Terminated)t)).build();
    }

    public AbstractActor.Receive createReceive() {
        return this.waitingBehavior();
    }

    public static class Connected {
        private final ActorRef wsActor;

        public Connected(ActorRef wsActor) {
            this.wsActor = wsActor;
        }

        public ActorRef getWsActor() {
            return this.wsActor;
        }

        public String toString() {
            return "Connected{wsActor=" + this.wsActor + '}';
        }
    }
}

