/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.events;

import io.mantisrx.master.jobcluster.WorkerInfoListHolder;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.server.core.Status;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.domain.DataFormatAdapter;
import io.mantisrx.server.master.domain.JobId;
import java.beans.ConstructorProperties;
import java.util.Optional;

public class LifecycleEventsProto {
    public static Status from(StatusEvent ev) {
        Status.TYPE type;
        switch (ev.statusEventType) {
            case INFO: {
                type = Status.TYPE.INFO;
                break;
            }
            case WARN: {
                type = Status.TYPE.WARN;
                break;
            }
            case DEBUG: {
                type = Status.TYPE.DEBUG;
                break;
            }
            case ERROR: {
                type = Status.TYPE.ERROR;
                break;
            }
            case HEARTBEAT: {
                type = Status.TYPE.HEARTBEAT;
                break;
            }
            default: {
                throw new IllegalArgumentException("status event type cannot be translated to Status Type " + ev.statusEventType.name());
            }
        }
        Status status = new Status("None", -1, -1, -1, Status.TYPE.DEBUG, "Invalid", MantisJobState.Noop);
        if (ev instanceof JobStatusEvent) {
            JobStatusEvent jse = (JobStatusEvent)ev;
            status = new Status(jse.jobId.getId(), -1, -1, -1, type, jse.getJobId() + " " + jse.message, DataFormatAdapter.convertToMantisJobState(jse.jobState));
        } else if (ev instanceof JobClusterStatusEvent) {
            JobClusterStatusEvent jcse = (JobClusterStatusEvent)ev;
            status = new Status(jcse.jobCluster, -1, -1, -1, type, jcse.getJobCluster() + " " + jcse.message, MantisJobState.Noop);
        } else if (ev instanceof WorkerStatusEvent) {
            WorkerStatusEvent wse = (WorkerStatusEvent)ev;
            status = new Status(wse.workerId.getJobId(), wse.stageNum, wse.workerId.getWorkerIndex(), wse.workerId.getWorkerNum(), type, wse.getWorkerId().getId() + " " + wse.message, DataFormatAdapter.convertWorkerStateToMantisJobState(wse.workerState));
        }
        return status;
    }

    public static class WorkerListChangedEvent {
        private final WorkerInfoListHolder workerInfoListHolder;

        public WorkerListChangedEvent(WorkerInfoListHolder workerInfoListHolder) {
            this.workerInfoListHolder = workerInfoListHolder;
        }

        public WorkerInfoListHolder getWorkerInfoListHolder() {
            return this.workerInfoListHolder;
        }

        public String toString() {
            return "WorkerListChangedEvent{workerInfoListHolder=" + this.workerInfoListHolder + '}';
        }
    }

    public static final class JobClusterStatusEvent
    extends StatusEvent {
        private final String jobCluster;

        public JobClusterStatusEvent(StatusEvent.StatusEventType type, String message, String jobCluster) {
            super(type, message);
            this.jobCluster = jobCluster;
        }

        public String getJobCluster() {
            return this.jobCluster;
        }

        @Override
        public String toString() {
            return "LifecycleEventsProto.JobClusterStatusEvent(jobCluster=" + this.getJobCluster() + ")";
        }
    }

    public static final class JobStatusEvent
    extends StatusEvent {
        private final JobId jobId;
        private final JobState jobState;

        public JobStatusEvent(StatusEvent.StatusEventType type, String message, JobId jobId, JobState jobState) {
            super(type, message);
            this.jobId = jobId;
            this.jobState = jobState;
        }

        @Override
        public String toString() {
            return "LifecycleEventsProto.JobStatusEvent(jobId=" + this.getJobId() + ", jobState=" + (Object)((Object)this.getJobState()) + ")";
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public JobState getJobState() {
            return this.jobState;
        }
    }

    public static final class WorkerStatusEvent
    extends StatusEvent {
        private final int stageNum;
        private final WorkerId workerId;
        private final WorkerState workerState;
        private final Optional<String> hostName;

        public WorkerStatusEvent(StatusEvent.StatusEventType type, String message, int stageNum, WorkerId workerId, WorkerState workerState) {
            super(type, message);
            this.stageNum = stageNum;
            this.workerId = workerId;
            this.workerState = workerState;
            this.hostName = Optional.empty();
        }

        public WorkerStatusEvent(StatusEvent.StatusEventType type, String message, int stageNum, WorkerId workerId, WorkerState workerState, long ts) {
            super(type, message, ts);
            this.stageNum = stageNum;
            this.workerId = workerId;
            this.workerState = workerState;
            this.hostName = Optional.empty();
        }

        public WorkerStatusEvent(StatusEvent.StatusEventType type, String message, int stageNum, WorkerId workerId, WorkerState workerState, String hostName, long ts) {
            super(type, message, ts);
            this.stageNum = stageNum;
            this.workerId = workerId;
            this.workerState = workerState;
            this.hostName = Optional.ofNullable(hostName);
        }

        public WorkerStatusEvent(StatusEvent.StatusEventType type, String message, int stageNum, WorkerId workerId, WorkerState workerState, Optional<String> hostName) {
            super(type, message);
            this.stageNum = stageNum;
            this.workerId = workerId;
            this.workerState = workerState;
            this.hostName = hostName;
        }

        public int getStageNum() {
            return this.stageNum;
        }

        public WorkerId getWorkerId() {
            return this.workerId;
        }

        public WorkerState getWorkerState() {
            return this.workerState;
        }

        public Optional<String> getHostName() {
            return this.hostName;
        }

        @Override
        public String toString() {
            return "LifecycleEventsProto.WorkerStatusEvent(stageNum=" + this.getStageNum() + ", workerId=" + this.getWorkerId() + ", workerState=" + (Object)((Object)this.getWorkerState()) + ", hostName=" + this.getHostName() + ")";
        }
    }

    public static class StatusEvent {
        protected final StatusEventType statusEventType;
        protected final String message;
        protected final long timestamp;

        public StatusEvent(StatusEventType type, String message) {
            this(type, message, System.currentTimeMillis());
        }

        public StatusEventType getStatusEventType() {
            return this.statusEventType;
        }

        public String getMessage() {
            return this.message;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusEvent)) {
                return false;
            }
            StatusEvent other = (StatusEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            StatusEventType this$statusEventType = this.getStatusEventType();
            StatusEventType other$statusEventType = other.getStatusEventType();
            if (this$statusEventType == null ? other$statusEventType != null : !((Object)((Object)this$statusEventType)).equals((Object)other$statusEventType)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StatusEvent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            StatusEventType $statusEventType = this.getStatusEventType();
            result = result * 59 + ($statusEventType == null ? 43 : ((Object)((Object)$statusEventType)).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @ConstructorProperties(value={"statusEventType", "message", "timestamp"})
        public StatusEvent(StatusEventType statusEventType, String message, long timestamp) {
            this.statusEventType = statusEventType;
            this.message = message;
            this.timestamp = timestamp;
        }

        public String toString() {
            return "LifecycleEventsProto.StatusEvent(statusEventType=" + (Object)((Object)this.getStatusEventType()) + ", message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public static enum StatusEventType {
            ERROR,
            WARN,
            INFO,
            DEBUG,
            HEARTBEAT;

        }
    }

    public static final class AuditEvent {
        private final AuditEventType auditEventType;
        private final String operand;
        private final String data;

        public AuditEvent(AuditEventType auditEventType, String operand, String data) {
            this.auditEventType = auditEventType;
            this.operand = operand;
            this.data = data;
        }

        public AuditEventType getAuditEventType() {
            return this.auditEventType;
        }

        public String getOperand() {
            return this.operand;
        }

        public String getData() {
            return this.data;
        }

        public String toString() {
            return "AuditEvent{auditEventType=" + (Object)((Object)this.auditEventType) + ", operand='" + this.operand + '\'' + ", data='" + this.data + '\'' + '}';
        }

        public static enum AuditEventType {
            JOB_CLUSTER_CREATE,
            JOB_CLUSTER_EXISTS,
            JOB_CLUSTER_FAILURE,
            JOB_CLUSTER_UPDATE,
            JOB_CLUSTER_DELETE,
            JOB_CLUSTER_DISABLED,
            JOB_CLUSTER_ENABLED,
            JOB_SUBMIT,
            JOB_START,
            JOB_TERMINATE,
            JOB_SHUTDOWN,
            JOB_DELETE,
            JOB_SCALE_UP,
            JOB_SCALE_DOWN,
            JOB_SCALE_UPDATE,
            JOB_FAILURE,
            WORKER_START,
            WORKER_TERMINATE,
            WORKER_RESUBMIT,
            WORKER_RESUBMITS_LIMIT,
            WORKER_STATUS_HB,
            CLUSTER_SCALE_UP,
            CLUSTER_SCALE_DOWN,
            CLUSTER_ACTIVE_VMS,
            JOB_CLUSTER_ACTOR_CREATE,
            JOB_CLUSTER_ACTOR_TERMINATE;

        }
    }
}

