/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.events;

import io.mantisrx.master.events.LifecycleEventsProto;
import io.mantisrx.master.events.StatusEventSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusEventSubscriberLoggingImpl
implements StatusEventSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(StatusEventSubscriberLoggingImpl.class);

    @Override
    public void process(LifecycleEventsProto.StatusEvent statusEvent) {
        String message = " " + (Object)((Object)statusEvent.statusEventType) + " " + statusEvent.message + " ";
        if (statusEvent instanceof LifecycleEventsProto.WorkerStatusEvent) {
            LifecycleEventsProto.WorkerStatusEvent wse = (LifecycleEventsProto.WorkerStatusEvent)statusEvent;
            message = wse.getWorkerId().getId() + message + (Object)((Object)wse.getWorkerState());
        } else if (statusEvent instanceof LifecycleEventsProto.JobStatusEvent) {
            LifecycleEventsProto.JobStatusEvent jse = (LifecycleEventsProto.JobStatusEvent)statusEvent;
            message = jse.getJobId() + message + (Object)((Object)jse.getJobState());
        } else if (statusEvent instanceof LifecycleEventsProto.JobClusterStatusEvent) {
            LifecycleEventsProto.JobClusterStatusEvent jcse = (LifecycleEventsProto.JobClusterStatusEvent)statusEvent;
            message = jcse.getJobCluster() + message;
        }
        logger.info("[STATUS] {}", (Object)message);
    }
}

