/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.events;

import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.Timer;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.master.events.LifecycleEventsProto;
import io.mantisrx.master.events.WorkerEventSubscriber;
import io.mantisrx.master.jobcluster.job.worker.IMantisWorkerMetadata;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractScheduledService;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.netty.util.internal.ConcurrentSet;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerMetricsCollector
extends AbstractScheduledService
implements WorkerEventSubscriber {
    private static final Logger log = LoggerFactory.getLogger(WorkerMetricsCollector.class);
    private final ConcurrentMap<JobId, Map<WorkerId, IMantisWorkerMetadata>> jobWorkers = new ConcurrentHashMap<JobId, Map<WorkerId, IMantisWorkerMetadata>>();
    private final ConcurrentMap<String, WorkerMetrics> clusterWorkersMetrics = new ConcurrentHashMap<String, WorkerMetrics>();
    private final ConcurrentSet<CleanupJobEvent> jobsToBeCleaned = new ConcurrentSet();
    private final Duration cleanupInterval;
    private final Duration epochDuration;
    private final Clock clock;
    private final WorkerMetricsCollectorMetrics workerMetricsCollectorMetrics = new WorkerMetricsCollectorMetrics();

    protected void runOneIteration() {
        Instant current = this.clock.instant();
        Iterator iterator = this.jobsToBeCleaned.iterator();
        while (iterator.hasNext()) {
            CleanupJobEvent event = (CleanupJobEvent)iterator.next();
            if (!current.isAfter(event.getExpiry())) continue;
            this.jobWorkers.remove(event.getJobId());
            iterator.remove();
        }
        this.workerMetricsCollectorMetrics.reportJobWorkersSize(this.jobWorkers.size());
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)this.epochDuration.toMillis(), (long)this.epochDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void process(LifecycleEventsProto.WorkerListChangedEvent event) {
        JobId jobId = event.getWorkerInfoListHolder().getJobId();
        List<IMantisWorkerMetadata> workers = event.getWorkerInfoListHolder().getWorkerMetadataList();
        this.jobWorkers.put(jobId, workers.stream().collect(Collectors.toMap(IMantisWorkerMetadata::getWorkerId, m -> m)));
        this.workerMetricsCollectorMetrics.reportJobWorkersSize(this.jobWorkers.size());
    }

    @Override
    public void process(LifecycleEventsProto.JobStatusEvent statusEvent) {
        if (statusEvent.getJobState().isTerminal()) {
            this.cleanUp(statusEvent.getJobId());
        }
    }

    private WorkerMetrics getWorkerMetrics(String clusterName) {
        return this.clusterWorkersMetrics.computeIfAbsent(clusterName, dontCare -> new WorkerMetrics(clusterName));
    }

    @Override
    public void process(LifecycleEventsProto.WorkerStatusEvent workerStatusEvent) {
        try {
            WorkerState workerState = workerStatusEvent.getWorkerState();
            JobId jobId = JobId.fromId(workerStatusEvent.getWorkerId().getJobId()).get();
            WorkerId workerId = workerStatusEvent.getWorkerId();
            Preconditions.checkNotNull(this.jobWorkers.get(jobId));
            IMantisWorkerMetadata metadata = (IMantisWorkerMetadata)((Map)this.jobWorkers.get(jobId)).get(workerId);
            if (metadata == null) {
                log.warn("Unknown workerId: {} for metrics collector in job: {}", (Object)workerId, (Object)jobId);
                return;
            }
            WorkerMetrics workerMetrics = this.getWorkerMetrics(metadata.getResourceCluster().map(ClusterID::getResourceID).orElse("mesos"));
            switch (workerState) {
                case Accepted: {
                    break;
                }
                case Launched: {
                    workerMetrics.reportSchedulingDuration(Math.max(0L, workerStatusEvent.getTimestamp() - metadata.getAcceptedAt()));
                    break;
                }
                case StartInitiated: {
                    break;
                }
                case Started: {
                    workerMetrics.reportWorkerPreparationDuration(Math.max(0L, workerStatusEvent.getTimestamp() - metadata.getLaunchedAt()));
                    break;
                }
                case Failed: 
                case Completed: {
                    workerMetrics.reportRunningDuration(Math.max(0L, workerStatusEvent.getTimestamp() - metadata.getStartedAt()));
                    break;
                }
                case Noop: {
                    break;
                }
                case Unknown: {
                    log.error("Unknown WorkerStatusEvent {}", (Object)workerStatusEvent);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to process worker status event {}", (Object)workerStatusEvent, (Object)e);
        }
    }

    private void cleanUp(JobId jobId) {
        this.jobsToBeCleaned.add((Object)new CleanupJobEvent(jobId, this.clock.instant().plus(this.cleanupInterval)));
    }

    @ConstructorProperties(value={"cleanupInterval", "epochDuration", "clock"})
    public WorkerMetricsCollector(Duration cleanupInterval, Duration epochDuration, Clock clock) {
        this.cleanupInterval = cleanupInterval;
        this.epochDuration = epochDuration;
        this.clock = clock;
    }

    private static final class CleanupJobEvent {
        private final JobId jobId;
        private final Instant expiry;

        @ConstructorProperties(value={"jobId", "expiry"})
        public CleanupJobEvent(JobId jobId, Instant expiry) {
            this.jobId = jobId;
            this.expiry = expiry;
        }

        public JobId getJobId() {
            return this.jobId;
        }

        public Instant getExpiry() {
            return this.expiry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CleanupJobEvent)) {
                return false;
            }
            CleanupJobEvent other = (CleanupJobEvent)o;
            JobId this$jobId = this.getJobId();
            JobId other$jobId = other.getJobId();
            if (this$jobId == null ? other$jobId != null : !((Object)this$jobId).equals(other$jobId)) {
                return false;
            }
            Instant this$expiry = this.getExpiry();
            Instant other$expiry = other.getExpiry();
            return !(this$expiry == null ? other$expiry != null : !((Object)this$expiry).equals(other$expiry));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JobId $jobId = this.getJobId();
            result = result * 59 + ($jobId == null ? 43 : ((Object)$jobId).hashCode());
            Instant $expiry = this.getExpiry();
            result = result * 59 + ($expiry == null ? 43 : ((Object)$expiry).hashCode());
            return result;
        }

        public String toString() {
            return "WorkerMetricsCollector.CleanupJobEvent(jobId=" + this.getJobId() + ", expiry=" + this.getExpiry() + ")";
        }
    }

    private static class WorkerMetricsCollectorMetrics {
        public static final String JOB_WORKERS_MAP_SIZE = "jobWorkersMapSize";
        private final Gauge jobWorkersMapSize;

        public WorkerMetricsCollectorMetrics() {
            MetricGroupId metricGroupId = new MetricGroupId("WorkerMetricsCollector");
            Metrics m = new Metrics.Builder().id(metricGroupId).addGauge(JOB_WORKERS_MAP_SIZE).build();
            this.jobWorkersMapSize = m.getGauge(JOB_WORKERS_MAP_SIZE);
        }

        private void reportJobWorkersSize(int size) {
            this.jobWorkersMapSize.set((long)size);
        }
    }

    private static class WorkerMetrics {
        public static final String SCHEDULING_DURATION = "schedulingDuration";
        public static final String PREPARATION_DURATION = "preparationDuration";
        public static final String RUNNING_DURATION = "runningDuration";
        private final Timer schedulingDuration;
        private final Timer preparationDuration;
        private final Timer runningDuration;

        public WorkerMetrics(String clusterName) {
            MetricGroupId metricGroupId = new MetricGroupId("WorkerMetricsCollector", new Tag[]{Tag.of((String)"cluster", (String)clusterName), Tag.of((String)"resourceCluster", (String)clusterName)});
            Metrics m = new Metrics.Builder().id(metricGroupId).addTimer(SCHEDULING_DURATION).addTimer(PREPARATION_DURATION).addTimer(RUNNING_DURATION).build();
            m = MetricsRegistry.getInstance().registerAndGet(m);
            this.schedulingDuration = m.getTimer(SCHEDULING_DURATION);
            this.preparationDuration = m.getTimer(PREPARATION_DURATION);
            this.runningDuration = m.getTimer(RUNNING_DURATION);
        }

        private void reportSchedulingDuration(long durationInMillis) {
            this.schedulingDuration.record(durationInMillis, TimeUnit.MILLISECONDS);
        }

        private void reportWorkerPreparationDuration(long durationInMillis) {
            this.preparationDuration.record(durationInMillis, TimeUnit.MILLISECONDS);
        }

        private void reportRunningDuration(long durationInMillis) {
            this.runningDuration.record(durationInMillis, TimeUnit.MILLISECONDS);
        }
    }
}

