/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster;

import io.mantisrx.master.jobcluster.JobClusterActor;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.domain.SLA;
import io.mantisrx.shaded.com.google.common.base.Preconditions;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLAEnforcer {
    private static final Logger logger = LoggerFactory.getLogger(SLAEnforcer.class);
    private final Optional<SLA> sla;
    private final Comparator<JobClusterActor.JobInfo> comparator = (o1, o2) -> {
        if (o2 == null) {
            return -1;
        }
        if (o1 == null) {
            return 1;
        }
        return Long.compare(o1.jobId.getJobNum(), o2.jobId.getJobNum());
    };

    public SLAEnforcer(SLA sla) {
        this.sla = Optional.ofNullable(sla);
    }

    public int enforceSLAMin(int activeJobsCount, int acceptedJobsCount) {
        Preconditions.checkArgument((activeJobsCount >= 0 ? 1 : 0) != 0, (Object)("Invalid activeJobsCount " + activeJobsCount));
        Preconditions.checkArgument((acceptedJobsCount >= 0 ? 1 : 0) != 0, (Object)("Invalid acceptedJobsCount " + activeJobsCount));
        if (!this.sla.isPresent() || this.sla.get().getMin() == 0) {
            logger.debug("SLA min not set nothing to enforce");
            return 0;
        }
        int jobsInActiveOrSubmittedState = activeJobsCount + acceptedJobsCount;
        if (jobsInActiveOrSubmittedState < this.sla.get().getMin()) {
            int jobsToLaunch = this.sla.get().getMin() - jobsInActiveOrSubmittedState;
            logger.info("Submit {} jobs per sla min of {}", (Object)jobsToLaunch, (Object)this.sla.get().getMin());
            return jobsToLaunch;
        }
        logger.debug("SLA min already satisfied");
        return 0;
    }

    public List<JobId> enforceSLAMax(List<JobClusterActor.JobInfo> list) {
        Preconditions.checkNotNull(list, (Object)"runningOrAcceptedJobSet is null");
        ArrayList jobsToDelete = Lists.newArrayList();
        if (!this.sla.isPresent() || this.sla.get().getMax() == 0) {
            return jobsToDelete;
        }
        TreeSet<JobClusterActor.JobInfo> sortedJobSet = new TreeSet<JobClusterActor.JobInfo>(this.comparator);
        sortedJobSet.addAll(list);
        JobClusterActor.JobInfo[] jobIdArray = sortedJobSet.toArray(new JobClusterActor.JobInfo[list.size()]);
        int activeJobCount = 0;
        int slaMax = this.sla.get().getMax();
        boolean addToDeleteList = false;
        for (int i = jobIdArray.length - 1; i >= 0; --i) {
            JobClusterActor.JobInfo jInfo = jobIdArray[i];
            if (addToDeleteList) {
                jobsToDelete.add(jInfo.jobId);
                continue;
            }
            if (!jInfo.state.equals((Object)JobState.Launched) || ++activeJobCount != slaMax) continue;
            addToDeleteList = true;
        }
        return jobsToDelete;
    }

    public boolean hasSLA() {
        return this.sla.isPresent() && this.sla != null && (this.sla.get().getMin() != 0 || this.sla.get().getMax() != 0);
    }

    Set<JobClusterActor.JobInfo> sortJobsByIdDesc(List<JobClusterActor.JobInfo> list) {
        TreeSet<JobClusterActor.JobInfo> sortedJobSet = new TreeSet<JobClusterActor.JobInfo>(this.comparator);
        sortedJobSet.addAll(list);
        return sortedJobSet;
    }
}

