/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job;

import io.mantisrx.common.Label;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.IMantisStageMetadata;
import io.mantisrx.master.jobcluster.job.JobState;
import io.mantisrx.master.jobcluster.job.MantisStageMetadataImpl;
import io.mantisrx.master.jobcluster.job.worker.JobWorker;
import io.mantisrx.runtime.JobSla;
import io.mantisrx.runtime.descriptor.SchedulingInfo;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.domain.Costs;
import io.mantisrx.server.master.domain.DataFormatAdapter;
import io.mantisrx.server.master.domain.JobDefinition;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.server.master.persistence.exceptions.InvalidJobException;
import io.mantisrx.server.master.persistence.exceptions.InvalidJobStateChangeException;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFilter;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonFilter(value="topLevelFilter")
public class MantisJobMetadataImpl
implements IMantisJobMetadata {
    private static final Logger logger = LoggerFactory.getLogger(MantisJobMetadataImpl.class);
    private final JobId jobId;
    private final long submittedAt;
    private final long heartbeatIntervalSecs;
    private final long workerTimeoutSecs;
    private long startedAt = 0L;
    private long endedAt = 0L;
    private JobState state;
    private int nextWorkerNumberToUse;
    private final JobDefinition jobDefinition;
    private Costs jobCosts;
    @JsonIgnore
    private final Map<Integer, IMantisStageMetadata> stageMetadataMap = new HashMap<Integer, IMantisStageMetadata>();
    @JsonIgnore
    private final Map<Integer, Integer> workerNumberToStageMap = new HashMap<Integer, Integer>();

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisJobMetadataImpl(@JsonProperty(value="jobId") JobId jobId, @JsonProperty(value="submittedAt") long submittedAt, @JsonProperty(value="startedAt") long startedAt, @JsonProperty(value="jobDefinition") JobDefinition jobDefinition, @JsonProperty(value="state") JobState state, @JsonProperty(value="nextWorkerNumberToUse") int nextWorkerNumberToUse, @JsonProperty(value="heartbeatIntervalSecs") long heartbeatIntervalSecs, @JsonProperty(value="workerTimeoutSecs") long workerTimeoutSecs) {
        this.jobId = jobId;
        this.submittedAt = submittedAt;
        this.startedAt = startedAt;
        this.state = state == null ? JobState.Accepted : state;
        this.nextWorkerNumberToUse = nextWorkerNumberToUse;
        this.heartbeatIntervalSecs = heartbeatIntervalSecs;
        this.workerTimeoutSecs = workerTimeoutSecs;
        this.jobDefinition = jobDefinition;
    }

    @Override
    public JobId getJobId() {
        return this.jobId;
    }

    @Override
    public String getClusterName() {
        return this.jobDefinition.getName();
    }

    @Override
    @JsonIgnore
    public Instant getSubmittedAtInstant() {
        return Instant.ofEpochMilli(this.submittedAt);
    }

    public long getSubmittedAt() {
        return this.submittedAt;
    }

    @Override
    public long getSubscriptionTimeoutSecs() {
        return this.jobDefinition.getSubscriptionTimeoutSecs();
    }

    @Override
    public int getNextWorkerNumberToUse() {
        return this.nextWorkerNumberToUse;
    }

    public void setNextWorkerNumberToUse(int n, MantisJobStore store) throws Exception {
        this.nextWorkerNumberToUse = n;
        store.updateJob(this);
    }

    @Override
    public JobState getState() {
        return this.state;
    }

    @Override
    public JobDefinition getJobDefinition() {
        return this.jobDefinition;
    }

    @Override
    public String getUser() {
        return this.jobDefinition.getUser();
    }

    @Override
    public Optional<JobSla> getSla() {
        return Optional.ofNullable(this.jobDefinition.getJobSla());
    }

    @Override
    public List<Parameter> getParameters() {
        return this.jobDefinition.getParameters();
    }

    @Override
    public List<Label> getLabels() {
        return this.jobDefinition.getLabels();
    }

    @Override
    @JsonIgnore
    public int getTotalStages() {
        return this.getJobDefinition().getNumberOfStages();
    }

    @Override
    @JsonIgnore
    public String getArtifactName() {
        return this.jobDefinition.getArtifactName();
    }

    void setJobState(JobState state, MantisJobStore store) throws Exception {
        logger.info("Updating job State from {} to {} ", (Object)this.state, (Object)state);
        if (!this.state.isValidStateChgTo(state)) {
            throw new InvalidJobStateChangeException(this.jobId.getId(), this.state, state);
        }
        this.state = state;
        if (this.state.isTerminal()) {
            this.endedAt = System.currentTimeMillis();
        }
        store.updateJob(this);
    }

    void setStartedAt(long startedAt, MantisJobStore store) throws Exception {
        logger.info("Updating job start time  to {} ", (Object)startedAt);
        this.startedAt = startedAt;
        store.updateJob(this);
    }

    void setJobCosts(Costs jobCosts) {
        this.jobCosts = jobCosts;
    }

    public boolean addJobStageIfAbsent(IMantisStageMetadata msmd) {
        if (logger.isTraceEnabled()) {
            logger.trace("Adding stage {} ", (Object)msmd);
        }
        boolean result = this.stageMetadataMap.put(msmd.getStageNum(), msmd) == null;
        msmd.getAllWorkers().forEach(worker -> this.workerNumberToStageMap.put(worker.getMetadata().getWorkerNumber(), msmd.getStageNum()));
        return result;
    }

    @Override
    @JsonIgnore
    public Map<Integer, ? extends IMantisStageMetadata> getStageMetadata() {
        return Collections.unmodifiableMap(this.stageMetadataMap);
    }

    public final Map<Integer, Integer> getWorkerNumberToStageMap() {
        return Collections.unmodifiableMap(this.workerNumberToStageMap);
    }

    @Override
    @JsonIgnore
    public Optional<IMantisStageMetadata> getStageMetadata(int stageNum) {
        return Optional.ofNullable(this.stageMetadataMap.get(stageNum));
    }

    boolean replaceWorkerMetaData(int stageNum, JobWorker newWorker, JobWorker oldWorker, MantisJobStore jobStore) throws Exception {
        boolean result = true;
        ((MantisStageMetadataImpl)this.stageMetadataMap.get(stageNum)).replaceWorkerIndex(newWorker, oldWorker, jobStore);
        this.removeWorkerMetadata(oldWorker.getMetadata().getWorkerNumber());
        Integer integer = this.workerNumberToStageMap.put(newWorker.getMetadata().getWorkerNumber(), stageNum);
        if (integer != null && integer != stageNum) {
            logger.error("Unexpected to put worker number mapping from {} to stage {} for job {}, prev mapping to stage {}", new Object[]{newWorker.getMetadata().getWorkerNumber(), stageNum, newWorker.getMetadata().getJobId(), integer});
        }
        return result;
    }

    public boolean addWorkerMetadata(int stageNum, JobWorker newWorker) {
        boolean result;
        if (logger.isTraceEnabled()) {
            logger.trace("Adding workerMetadata {} for stage {}", (Object)stageNum, (Object)newWorker);
        }
        if (!this.stageMetadataMap.containsKey(stageNum)) {
            logger.warn("No such stage {}", (Object)stageNum);
        }
        if (result = ((MantisStageMetadataImpl)this.stageMetadataMap.get(stageNum)).addWorkerIndex(newWorker)) {
            Integer integer = this.workerNumberToStageMap.put(newWorker.getMetadata().getWorkerNumber(), stageNum);
            if (integer != null && integer != stageNum) {
                logger.error("Unexpected to put worker number mapping from {} to stage {} for job {}, prev mapping to stage {}", new Object[]{newWorker.getMetadata().getWorkerNumber(), stageNum, newWorker.getMetadata().getJobId(), integer});
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Exit addworkerMeta {}", this.workerNumberToStageMap);
            }
        }
        return result;
    }

    boolean removeWorkerMetadata(int workerNumber) {
        if (this.workerNumberToStageMap.containsKey(workerNumber)) {
            this.workerNumberToStageMap.remove(workerNumber);
            return true;
        }
        return false;
    }

    @Override
    @JsonIgnore
    public Optional<JobWorker> getWorkerByIndex(int stageNumber, int workerIndex) throws InvalidJobException {
        Optional<IMantisStageMetadata> stage = this.getStageMetadata(stageNumber);
        if (stage.isPresent()) {
            return Optional.ofNullable(stage.get().getWorkerByIndex(workerIndex));
        }
        return Optional.empty();
    }

    @Override
    @JsonIgnore
    public Optional<JobWorker> getWorkerByNumber(int workerNumber) throws InvalidJobException {
        Integer stageNumber = this.workerNumberToStageMap.get(workerNumber);
        if (stageNumber == null) {
            return Optional.empty();
        }
        IMantisStageMetadata stage = this.stageMetadataMap.get(stageNumber);
        if (stage == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(stage.getWorkerByWorkerNumber(workerNumber));
    }

    @JsonIgnore
    public int getMaxWorkerNumber() {
        int max = -1;
        for (int id : this.workerNumberToStageMap.keySet()) {
            if (max >= id) continue;
            max = id;
        }
        return max;
    }

    @Override
    @JsonIgnore
    public SchedulingInfo getSchedulingInfo() {
        return this.jobDefinition.getSchedulingInfo();
    }

    @Override
    public long getMinRuntimeSecs() {
        return this.jobDefinition.getJobSla().getMinRuntimeSecs();
    }

    @Override
    @Deprecated
    public URL getJobJarUrl() {
        try {
            return DataFormatAdapter.generateURL(this.getArtifactName());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Instant> getStartedAtInstant() {
        if (this.startedAt == 0L) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochMilli(this.startedAt));
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    @Override
    public Optional<Instant> getEndedAtInstant() {
        if (this.endedAt == 0L) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochMilli(this.endedAt));
    }

    public long getEndedAt() {
        return this.endedAt;
    }

    public String toString() {
        return "MantisJobMetadataImpl{jobId=" + this.jobId + ", submittedAt=" + this.submittedAt + ", startedAt=" + this.startedAt + ", endedAt=" + this.endedAt + ", state=" + (Object)((Object)this.state) + ", nextWorkerNumberToUse=" + this.nextWorkerNumberToUse + ", jobDefinition=" + this.jobDefinition + ", stageMetadataMap=" + this.stageMetadataMap + ", heartbeatIntervalSecs=" + this.heartbeatIntervalSecs + ", workerTimeoutSecs=" + this.workerTimeoutSecs + ", workerNumberToStageMap=" + this.workerNumberToStageMap + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MantisJobMetadataImpl that = (MantisJobMetadataImpl)o;
        return this.submittedAt == that.submittedAt && this.startedAt == that.startedAt && this.endedAt == that.endedAt && this.nextWorkerNumberToUse == that.nextWorkerNumberToUse && this.heartbeatIntervalSecs == that.heartbeatIntervalSecs && Objects.equals(this.jobId, that.jobId) && this.state == that.state && Objects.equals(this.jobDefinition, that.jobDefinition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.submittedAt, this.startedAt, this.endedAt, this.state, this.nextWorkerNumberToUse, this.heartbeatIntervalSecs, this.jobDefinition});
    }

    @Override
    public Costs getJobCosts() {
        return this.jobCosts;
    }

    @Override
    public long getHeartbeatIntervalSecs() {
        return this.heartbeatIntervalSecs;
    }

    @Override
    public long getWorkerTimeoutSecs() {
        return this.workerTimeoutSecs;
    }

    public static class Builder {
        JobId jobId;
        String user;
        JobDefinition jobDefinition;
        long submittedAt;
        long startedAt;
        JobState state;
        int nextWorkerNumberToUse = 1;
        long heartbeatIntervalSecs = 0L;
        long workerTimeoutSecs = 0L;
        Costs jobCosts;

        public Builder() {
        }

        public Builder(MantisJobMetadataImpl mJob) {
            this.jobId = mJob.getJobId();
            this.jobDefinition = mJob.getJobDefinition();
            this.submittedAt = mJob.getSubmittedAt();
            this.state = mJob.getState();
            this.nextWorkerNumberToUse = mJob.getNextWorkerNumberToUse();
            this.heartbeatIntervalSecs = mJob.getHeartbeatIntervalSecs();
            this.workerTimeoutSecs = mJob.getWorkerTimeoutSecs();
            this.jobCosts = mJob.getJobCosts();
        }

        public Builder withJobId(JobId jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder withJobDefinition(JobDefinition jD) {
            this.jobDefinition = jD;
            return this;
        }

        public Builder withSubmittedAt(long submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public Builder withSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt.toEpochMilli();
            return this;
        }

        public Builder withStartedAt(Instant startedAt) {
            this.startedAt = startedAt.toEpochMilli();
            return this;
        }

        public Builder withJobState(JobState state) {
            this.state = state;
            return this;
        }

        public Builder withNextWorkerNumToUse(int workerNum) {
            this.nextWorkerNumberToUse = workerNum;
            return this;
        }

        public Builder withJobCost(Costs costs) {
            this.jobCosts = costs;
            return this;
        }

        public Builder withHeartbeatIntervalSecs(long secs) {
            this.heartbeatIntervalSecs = secs;
            return this;
        }

        public Builder withWorkerTimeoutSecs(long secs) {
            this.workerTimeoutSecs = secs;
            return this;
        }

        public Builder from(MantisJobMetadataImpl mJob) {
            this.jobId = mJob.getJobId();
            this.jobDefinition = mJob.getJobDefinition();
            this.submittedAt = mJob.getSubmittedAt();
            this.state = mJob.getState();
            this.jobCosts = mJob.getJobCosts();
            this.nextWorkerNumberToUse = mJob.getNextWorkerNumberToUse();
            this.heartbeatIntervalSecs = mJob.getHeartbeatIntervalSecs();
            this.workerTimeoutSecs = mJob.getWorkerTimeoutSecs();
            return this;
        }

        public MantisJobMetadataImpl build() {
            return new MantisJobMetadataImpl(this.jobId, this.submittedAt, this.startedAt, this.jobDefinition, this.state, this.nextWorkerNumberToUse, this.heartbeatIntervalSecs, this.workerTimeoutSecs);
        }
    }
}

