/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job;

import io.mantisrx.master.jobcluster.job.FilterableMantisJobMetadataWritable;
import io.mantisrx.master.jobcluster.job.FilterableMantisStageMetadataWritable;
import io.mantisrx.master.jobcluster.job.FilterableMantisWorkerMetadataWritable;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.IMantisStageMetadata;
import io.mantisrx.master.jobcluster.job.worker.IMantisWorkerMetadata;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.server.master.domain.DataFormatAdapter;
import io.mantisrx.server.master.store.MantisJobMetadata;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonFilter;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.mantisrx.shaded.com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonFilter(value="topLevelFilter")
public class MantisJobMetadataView {
    @JsonIgnore
    private static final ObjectMapper mapper = new ObjectMapper();
    @JsonIgnore
    private static final Logger logger = LoggerFactory.getLogger(MantisJobMetadataView.class);
    private FilterableMantisJobMetadataWritable jobMetadata;
    private long terminatedAt = -1L;
    private List<FilterableMantisStageMetadataWritable> stageMetadataList = Lists.newArrayList();
    private List<FilterableMantisWorkerMetadataWritable> workerMetadataList = Lists.newArrayList();
    private String version = "";

    public MantisJobMetadataView() {
    }

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisJobMetadataView(@JsonDeserialize(as=FilterableMantisJobMetadataWritable.class) @JsonProperty(value="jobMetadata") FilterableMantisJobMetadataWritable jobMeta, @JsonProperty(value="stageMetadataList") List<FilterableMantisStageMetadataWritable> stageMetadata, @JsonProperty(value="workerMetadataList") List<FilterableMantisWorkerMetadataWritable> workerMetadata) {
        this.jobMetadata = jobMeta;
        this.stageMetadataList = stageMetadata;
        this.workerMetadataList = workerMetadata;
    }

    public MantisJobMetadataView(IMantisJobMetadata jobMeta, long terminatedAt, List<Integer> stageNumberList, List<Integer> workerIndexList, List<Integer> workerNumberList, List<WorkerState.MetaState> workerStateList, boolean jobIdOnly) {
        if (logger.isTraceEnabled()) {
            logger.trace("Enter MantisJobMetadataView ctor jobMeta {} workerIndexList {} workerNumberList workerStateList {} jobIdOnly {}", new Object[]{workerIndexList, workerNumberList, workerStateList, jobIdOnly});
        }
        this.jobMetadata = DataFormatAdapter.convertMantisJobMetadataToFilterableMantisJobMetadataWriteable(jobMeta);
        this.terminatedAt = terminatedAt;
        this.version = jobMeta.getJobDefinition().getVersion();
        if (logger.isDebugEnabled()) {
            logger.debug("MantisJobMetadataView.terminatedAt set to {}, version set to {}", (Object)terminatedAt, (Object)this.version);
        }
        if (!jobIdOnly) {
            if (logger.isDebugEnabled()) {
                logger.debug("MantisJobMetadataView.jobIdOnly is {}", (Object)jobIdOnly);
            }
            this.stageMetadataList = jobMeta.getStageMetadata().values().stream().filter(mantisStageMetadata -> this.stageFilter((IMantisStageMetadata)mantisStageMetadata, stageNumberList)).map(DataFormatAdapter::convertFilterableMantisStageMetadataToMantisStageMetadataWriteable).collect(Collectors.toList());
            this.workerMetadataList = jobMeta.getStageMetadata().values().stream().map(IMantisStageMetadata::getAllWorkers).flatMap(jobWorkers -> jobWorkers.stream().map(jw -> jw.getMetadata()).filter(workerMetadata -> this.workerFilter((IMantisWorkerMetadata)workerMetadata, workerIndexList, workerNumberList, workerStateList)).map(DataFormatAdapter::convertMantisWorkerMetadataToFilterableMantisWorkerMetadataWritable)).collect(Collectors.toList());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Exit MantisJobMetadataView ctor");
        }
    }

    public MantisJobMetadataView(IMantisJobMetadata jobMeta, List<Integer> stageNumberList, List<Integer> workerIndexList, List<Integer> workerNumberList, List<WorkerState.MetaState> workerStateList, boolean jobIdOnly) {
        this(jobMeta, -1L, stageNumberList, workerIndexList, workerNumberList, workerStateList, jobIdOnly);
    }

    private boolean stageFilter(IMantisStageMetadata msmd, List<Integer> stageNumberList) {
        if (logger.isTraceEnabled()) {
            logger.trace("Enter MantisJobMetadataView:stageFilter Stage {} stageNumberList {}", (Object)msmd, stageNumberList);
        }
        if (stageNumberList.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Exit stageFilter with true for stage {}", (Object)msmd);
            }
            return true;
        }
        for (int stageNumber : stageNumberList) {
            if (stageNumber != msmd.getStageNum()) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Exit stageFilter with true for stage {}", (Object)msmd);
            }
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Exit stageFilter with false for stage {}", (Object)msmd);
        }
        return false;
    }

    private boolean workerFilter(IMantisWorkerMetadata mwmd, List<Integer> workerIndexList, List<Integer> workerNumberList, List<WorkerState.MetaState> workerStateList) {
        if (logger.isTraceEnabled()) {
            logger.trace("Enter MantisJobMetadataView:workerFilter worker {} indexList {} numberList {} stateList {}", new Object[]{mwmd, workerIndexList, workerNumberList, workerStateList});
        }
        boolean match = false;
        if (workerIndexList.isEmpty() && workerNumberList.isEmpty() && workerStateList.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Exit workerFilter1 with true for worker {}", (Object)mwmd);
            }
            return true;
        }
        for (Integer workerIndex : workerIndexList) {
            if (workerIndex.intValue() == mwmd.getWorkerIndex()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Exit workerFilter2 with true for worker {}", (Object)mwmd);
                }
                match = true;
            }
            if (match) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Exit workerFilter3 with true for worker {}", (Object)mwmd);
            }
            return false;
        }
        for (Integer workerNumber : workerNumberList) {
            match = workerNumber.intValue() == mwmd.getWorkerNumber();
            if (match) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Exit workerFilter4 with false for worker {}", (Object)mwmd);
            }
            return false;
        }
        for (WorkerState.MetaState state : workerStateList) {
            match = false;
            try {
                match = WorkerState.toMetaState(mwmd.getState()).equals((Object)state);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (!match) {
            if (logger.isTraceEnabled()) {
                logger.trace("Exit workerFilter5 with false for worker {}", (Object)mwmd);
            }
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Exit workerFilter6 with true for worker {}", (Object)mwmd);
        }
        return true;
    }

    public MantisJobMetadata getJobMetadata() {
        return this.jobMetadata;
    }

    public List<FilterableMantisStageMetadataWritable> getStageMetadataList() {
        return this.stageMetadataList;
    }

    public List<FilterableMantisWorkerMetadataWritable> getWorkerMetadataList() {
        return this.workerMetadataList;
    }

    public long getTerminatedAt() {
        return this.terminatedAt;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "MantisJobMetadataView [jobMetadata=" + this.jobMetadata + ", stageMetadataList=" + this.stageMetadataList + ", workerMetadataList=" + this.workerMetadataList + "]";
        }
    }
}

