/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job;

import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.master.jobcluster.job.IMantisStageMetadata;
import io.mantisrx.master.jobcluster.job.worker.IMantisWorkerMetadata;
import io.mantisrx.master.jobcluster.job.worker.JobWorker;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.master.jobcluster.job.worker.WorkerTerminate;
import io.mantisrx.runtime.JobConstraints;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.descriptor.StageScalingPolicy;
import io.mantisrx.server.core.JobCompletedReason;
import io.mantisrx.server.master.WorkerRequest;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.server.master.persistence.exceptions.InvalidJobException;
import io.mantisrx.server.master.persistence.exceptions.InvalidWorkerStateChangeException;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisStageMetadataImpl
implements IMantisStageMetadata {
    private final JobId jobId;
    private final int stageNum;
    private final int numStages;
    private final MachineDefinition machineDefinition;
    private int numWorkers;
    @JsonIgnore
    private boolean isSubscribed = false;
    private final List<JobConstraints> hardConstraints;
    private final List<JobConstraints> softConstraints;
    private final StageScalingPolicy scalingPolicy;
    private final boolean scalable;
    private final String sizeAttribute;
    @JsonIgnore
    private final ConcurrentMap<Integer, JobWorker> workerByIndexMetadataSet;
    @JsonIgnore
    private final ConcurrentMap<Integer, JobWorker> workerByNumberMetadataSet;
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisStageMetadataImpl.class);

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public MantisStageMetadataImpl(@JsonProperty(value="jobId") JobId jobId, @JsonProperty(value="stageNum") int stageNum, @JsonProperty(value="numStages") int numStages, @JsonProperty(value="machineDefinition") MachineDefinition machineDefinition, @JsonProperty(value="numWorkers") int numWorkers, @JsonProperty(value="hardConstraints") List<JobConstraints> hardConstraints, @JsonProperty(value="softConstraints") List<JobConstraints> softConstraints, @JsonProperty(value="scalingPolicy") StageScalingPolicy scalingPolicy, @JsonProperty(value="scalable") boolean scalable, @JsonProperty(value="sizeAttribute") String sizeAttribute) {
        this.jobId = jobId;
        this.stageNum = stageNum;
        this.numStages = numStages;
        this.machineDefinition = machineDefinition;
        this.numWorkers = numWorkers;
        this.hardConstraints = hardConstraints;
        this.softConstraints = softConstraints;
        this.scalingPolicy = scalingPolicy;
        this.scalable = scalable;
        this.sizeAttribute = sizeAttribute;
        this.workerByIndexMetadataSet = new ConcurrentHashMap<Integer, JobWorker>();
        this.workerByNumberMetadataSet = new ConcurrentHashMap<Integer, JobWorker>();
    }

    @Override
    public JobId getJobId() {
        return this.jobId;
    }

    @Override
    public int getStageNum() {
        return this.stageNum;
    }

    @Override
    public int getNumStages() {
        return this.numStages;
    }

    @Override
    public int getNumWorkers() {
        return this.numWorkers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MantisStageMetadataImpl that = (MantisStageMetadataImpl)o;
        return this.stageNum == that.stageNum && this.numStages == that.numStages && this.numWorkers == that.numWorkers && this.scalable == that.scalable && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.machineDefinition, that.machineDefinition) && Objects.equals(this.hardConstraints, that.hardConstraints) && Objects.equals(this.softConstraints, that.softConstraints) && Objects.equals(this.scalingPolicy, that.scalingPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.stageNum, this.numStages, this.machineDefinition, this.numWorkers, this.hardConstraints, this.softConstraints, this.scalingPolicy, this.scalable);
    }

    public void unsafeSetNumWorkers(int numWorkers, MantisJobStore store) throws Exception {
        this.numWorkers = numWorkers;
        store.updateStage(this);
    }

    public boolean unsafeRemoveWorker(int index, int number, MantisJobStore store) {
        JobWorker removedIdx = (JobWorker)this.workerByIndexMetadataSet.remove(index);
        JobWorker removedNum = (JobWorker)this.workerByNumberMetadataSet.remove(number);
        if (removedIdx != null && removedNum != null && removedIdx.getMetadata().getWorkerNumber() == number && removedNum.getMetadata().getWorkerIndex() == index) {
            LOGGER.info("Worker index {} - number {} marked for deletion", (Object)index, (Object)number);
            try {
                this.archiveWorker(removedIdx.getMetadata(), store);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public List<JobConstraints> getHardConstraints() {
        return Collections.unmodifiableList(this.hardConstraints);
    }

    @Override
    public List<JobConstraints> getSoftConstraints() {
        return Collections.unmodifiableList(this.softConstraints);
    }

    @Override
    public StageScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    @Override
    public boolean getScalable() {
        return this.scalable;
    }

    @Override
    public MachineDefinition getMachineDefinition() {
        return this.machineDefinition;
    }

    @Override
    @Deprecated
    @JsonIgnore
    public Collection<JobWorker> getWorkerByIndexMetadataSet() {
        return Collections.unmodifiableCollection(this.workerByIndexMetadataSet.values());
    }

    @Override
    @JsonIgnore
    public Collection<JobWorker> getAllWorkers() {
        return Collections.unmodifiableCollection(this.workerByNumberMetadataSet.values());
    }

    @Override
    @JsonIgnore
    public JobWorker getWorkerByIndex(int workerId) throws InvalidJobException {
        JobWorker worker = (JobWorker)this.workerByIndexMetadataSet.get(workerId);
        if (worker == null) {
            throw new InvalidJobException(this.jobId, -1, workerId);
        }
        return worker;
    }

    @Override
    @JsonIgnore
    public JobWorker getWorkerByWorkerNumber(int workerNumber) throws InvalidJobException {
        JobWorker worker = (JobWorker)this.workerByNumberMetadataSet.get(workerNumber);
        if (worker == null) {
            throw new InvalidJobException(this.jobId, -1, workerNumber);
        }
        return worker;
    }

    @Override
    public Optional<String> getSizeAttribute() {
        return Optional.ofNullable(this.sizeAttribute);
    }

    JobWorker removeWorkerInFinalState(int workerNumber) {
        JobWorker worker = (JobWorker)this.workerByNumberMetadataSet.get(workerNumber);
        if (worker != null && WorkerState.isTerminalState(worker.getMetadata().getState())) {
            this.workerByNumberMetadataSet.remove(workerNumber);
            return worker;
        }
        return null;
    }

    public Collection<JobWorker> removeArchiveableWorkers() {
        LinkedList<JobWorker> removedWorkers = new LinkedList<JobWorker>();
        HashSet workerNumbers = new HashSet(this.workerByNumberMetadataSet.keySet());
        for (Integer w : workerNumbers) {
            JobWorker worker = (JobWorker)this.workerByNumberMetadataSet.get(w);
            JobWorker wi = (JobWorker)this.workerByIndexMetadataSet.get(worker.getMetadata().getWorkerIndex());
            if (wi != null && wi.getMetadata().getWorkerNumber() == worker.getMetadata().getWorkerNumber()) continue;
            this.workerByNumberMetadataSet.remove(w);
            removedWorkers.add(worker);
        }
        return removedWorkers;
    }

    public void replaceWorkerIndex(JobWorker newWorker, JobWorker oldWorker, MantisJobStore jobStore) throws Exception {
        Preconditions.checkNotNull((Object)newWorker, (String)"Replacement worker cannot be null");
        Preconditions.checkNotNull((Object)oldWorker, (String)"old worker cannot be null");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("In MantisStageMetadataImpl:replaceWorkerIndex oldWorker {} new Worker {} for Job {}", new Object[]{oldWorker, newWorker, this.getJobId()});
        }
        IMantisWorkerMetadata newWorkerMetadata = newWorker.getMetadata();
        IMantisWorkerMetadata oldWorkerMetadata = oldWorker.getMetadata();
        int index = newWorkerMetadata.getWorkerIndex();
        boolean result = true;
        if (WorkerState.isErrorState(newWorkerMetadata.getState())) {
            String errMsg = String.format("New worker cannot be in error state %s", new Object[]{newWorkerMetadata.getState()});
            LOGGER.error(errMsg);
            throw new IllegalStateException(errMsg);
        }
        if (!this.workerByIndexMetadataSet.containsKey(index)) {
            String errMsg = String.format("Index %d does not exist in workerByIndexMetadataSet %s for job %s", index, this.workerByIndexMetadataSet, this.jobId);
            throw new IllegalArgumentException(errMsg);
        }
        if (oldWorkerMetadata.getWorkerIndex() != index) {
            String errMsg = String.format("While replacing worker in Job %s, Old worker index %d does not match new %d", this.jobId, oldWorkerMetadata.getWorkerIndex(), index);
            LOGGER.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        LOGGER.debug("workerByIndexMetadatSet {}", this.workerByIndexMetadataSet);
        JobWorker worker = (JobWorker)this.workerByIndexMetadataSet.get(index);
        if (worker.getMetadata().getWorkerNumber() != oldWorkerMetadata.getWorkerNumber()) {
            String errMsg = String.format("Did not replace worker %d with %d for index %d of job %s, different worker %d exists already", oldWorkerMetadata.getWorkerNumber(), newWorkerMetadata.getWorkerNumber(), newWorkerMetadata.getWorkerIndex(), this.jobId, worker.getMetadata().getWorkerNumber());
            throw new IllegalArgumentException(errMsg);
        }
        this.processWorkerEvent(new WorkerTerminate(oldWorkerMetadata.getWorkerId(), WorkerState.Failed, JobCompletedReason.Relaunched, System.currentTimeMillis()), jobStore);
        this.workerByIndexMetadataSet.put(index, newWorker);
        this.removeWorkerInFinalState(oldWorkerMetadata.getWorkerNumber());
        jobStore.replaceTerminatedWorker(oldWorkerMetadata, newWorkerMetadata);
        this.workerByNumberMetadataSet.put(newWorkerMetadata.getWorkerNumber(), newWorker);
        try {
            this.archiveWorker(oldWorkerMetadata, jobStore);
        }
        catch (Exception e) {
            LOGGER.error("Exception archiving worker", (Throwable)e);
        }
        LOGGER.info("Replaced worker {} with {} for index {} of job {}", new Object[]{oldWorkerMetadata.getWorkerNumber(), newWorkerMetadata.getWorkerNumber(), newWorkerMetadata.getWorkerIndex(), this.jobId});
    }

    private void archiveWorker(IMantisWorkerMetadata worker, MantisJobStore jobStore) throws IOException {
        jobStore.archiveWorker(worker);
    }

    public boolean addWorkerIndex(JobWorker newWorker) {
        IMantisWorkerMetadata newWorkerMetadata = newWorker.getMetadata();
        if (this.workerByIndexMetadataSet.putIfAbsent(newWorkerMetadata.getWorkerIndex(), newWorker) != null) {
            LOGGER.warn("WorkerIndex {} already exists. Existing worker={} ", (Object)newWorkerMetadata.getWorkerIndex(), this.workerByIndexMetadataSet.get(newWorkerMetadata.getWorkerIndex()));
            return false;
        }
        this.workerByNumberMetadataSet.put(newWorkerMetadata.getWorkerNumber(), newWorker);
        return true;
    }

    public Optional<JobWorker> processWorkerEvent(WorkerEvent event, MantisJobStore jobStore) {
        try {
            JobWorker worker = this.getWorkerByIndex(event.getWorkerId().getWorkerIndex());
            try {
                worker.processEvent(event, jobStore);
            }
            catch (InvalidWorkerStateChangeException wex) {
                LOGGER.warn("InvalidWorkerStateChangeException from: ", (Throwable)wex);
            }
            return Optional.of(worker);
        }
        catch (Exception e) {
            LOGGER.warn("Exception saving worker update", (Throwable)e);
            return Optional.empty();
        }
    }

    @JsonIgnore
    public boolean isAllWorkerStarted() {
        for (JobWorker w : this.workerByIndexMetadataSet.values()) {
            if (w.getMetadata().getState().equals((Object)WorkerState.Started)) continue;
            return false;
        }
        return true;
    }

    @JsonIgnore
    public boolean isAllWorkerCompleted() {
        for (JobWorker w : this.workerByIndexMetadataSet.values()) {
            if (WorkerState.isTerminalState(w.getMetadata().getState())) continue;
            LOGGER.debug("isAllWorkerCompleted returns false");
            return false;
        }
        LOGGER.info("isAllWorkerCompleted returns true");
        return true;
    }

    @JsonIgnore
    public int getNumStartedWorkers() {
        int startedCount = 0;
        for (JobWorker w : this.workerByIndexMetadataSet.values()) {
            if (!w.getMetadata().getState().equals((Object)WorkerState.Started)) continue;
            ++startedCount;
        }
        return startedCount;
    }

    public String toString() {
        return "MantisStageMetadataImpl [jobId=" + this.jobId + ", stageNum=" + this.stageNum + ", numStages=" + this.numStages + ", machineDefinition=" + this.machineDefinition + ", numWorkers=" + this.numWorkers + ", hardConstraints=" + this.hardConstraints + ", softConstraints=" + this.softConstraints + ", scalingPolicy=" + this.scalingPolicy + ", scalable=" + this.scalable + ", workerByIndexMetadataSet=" + this.workerByIndexMetadataSet + ", workerByNumberMetadataSet=" + this.workerByNumberMetadataSet + "]";
    }

    public static class Builder {
        private JobId jobId;
        private int stageNum = -1;
        private int numStages = 0;
        private MachineDefinition machineDefinition;
        private int numWorkers = 0;
        private List<JobConstraints> hardConstraints = Collections.emptyList();
        private List<JobConstraints> softConstraints = Collections.emptyList();
        private StageScalingPolicy scalingPolicy;
        private boolean scalable;
        private String sizeAttribute;

        public Builder withJobId(JobId jId) {
            this.jobId = jId;
            return this;
        }

        public Builder withStageNum(int stageNum) {
            this.stageNum = stageNum;
            return this;
        }

        public Builder withNumStages(int numStages) {
            this.numStages = numStages;
            return this;
        }

        public Builder withMachineDefinition(MachineDefinition md) {
            this.machineDefinition = md;
            return this;
        }

        public Builder withNumWorkers(int numWorkers) {
            this.numWorkers = numWorkers;
            return this;
        }

        public Builder withHardConstraints(List<JobConstraints> hardC) {
            if (hardC != null) {
                this.hardConstraints = hardC;
            }
            return this;
        }

        public Builder withSoftConstraints(List<JobConstraints> softC) {
            if (softC != null) {
                this.softConstraints = softC;
            }
            return this;
        }

        public Builder withScalingPolicy(StageScalingPolicy pol) {
            this.scalingPolicy = pol;
            return this;
        }

        public Builder isScalable(boolean s) {
            this.scalable = s;
            return this;
        }

        public Builder withSizeAttribute(String s) {
            this.sizeAttribute = s;
            return this;
        }

        public Builder from(WorkerRequest workerRequest) {
            Objects.requireNonNull(workerRequest);
            this.jobId = JobId.fromId(workerRequest.getJobId()).orElse(null);
            this.stageNum = workerRequest.getWorkerStage();
            this.numStages = workerRequest.getTotalStages();
            this.machineDefinition = workerRequest.getDefinition();
            this.numWorkers = workerRequest.getNumInstancesAtStage();
            this.hardConstraints = workerRequest.getHardConstraints() != null ? workerRequest.getHardConstraints() : new ArrayList<JobConstraints>();
            this.softConstraints = workerRequest.getSoftConstraints() != null ? workerRequest.getSoftConstraints() : new ArrayList<JobConstraints>();
            this.scalingPolicy = workerRequest.getSchedulingInfo().forStage(workerRequest.getWorkerStage()).getScalingPolicy();
            this.scalable = workerRequest.getSchedulingInfo().forStage(workerRequest.getWorkerStage()).getScalable();
            this.sizeAttribute = Optional.ofNullable(workerRequest.getSchedulingInfo().forStage(workerRequest.getWorkerStage()).getContainerAttributes()).map(attrs -> (String)attrs.get("_mantis.stageContainerSizeName")).orElse(null);
            return this;
        }

        public IMantisStageMetadata build() {
            Objects.requireNonNull(this.jobId, "JobId cannot be null");
            if (this.stageNum <= -1) {
                throw new IllegalArgumentException(String.format("Invalid stage number %d", this.stageNum));
            }
            if (this.numStages <= 0) {
                throw new IllegalArgumentException(String.format("Invalid no of stages %d", this.numStages));
            }
            return new MantisStageMetadataImpl(this.jobId, this.stageNum, this.numStages, this.machineDefinition, this.numWorkers, this.hardConstraints, this.softConstraints, this.scalingPolicy, this.scalable, this.sizeAttribute);
        }
    }
}

