/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job.worker;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.common.WorkerPorts;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.master.api.akka.route.Jackson;
import io.mantisrx.master.events.LifecycleEventPublisher;
import io.mantisrx.master.events.LifecycleEventsProto;
import io.mantisrx.master.jobcluster.job.IMantisWorkerEventProcessor;
import io.mantisrx.master.jobcluster.job.worker.IMantisWorkerMetadata;
import io.mantisrx.master.jobcluster.job.worker.MantisWorkerMetadataImpl;
import io.mantisrx.master.jobcluster.job.worker.WorkerHeartbeat;
import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.master.jobcluster.job.worker.WorkerStatus;
import io.mantisrx.master.jobcluster.job.worker.WorkerTerminate;
import io.mantisrx.master.scheduler.WorkerStateAdapter;
import io.mantisrx.server.core.JobCompletedReason;
import io.mantisrx.server.core.Status;
import io.mantisrx.server.core.StatusPayloads;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.server.master.persistence.exceptions.InvalidWorkerStateChangeException;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.scheduler.WorkerEvent;
import io.mantisrx.server.master.scheduler.WorkerLaunchFailed;
import io.mantisrx.server.master.scheduler.WorkerLaunched;
import io.mantisrx.server.master.scheduler.WorkerOnDisabledVM;
import io.mantisrx.server.master.scheduler.WorkerResourceStatus;
import io.mantisrx.server.master.scheduler.WorkerUnscheduleable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorker
implements IMantisWorkerEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorker.class);
    private final IMantisWorkerMetadata metadata;
    private final LifecycleEventPublisher eventPublisher;
    private final Metrics metrics;
    private final MetricGroupId metricsGroupId;
    private final Counter numWorkerLaunched;
    private final Counter numWorkerTerminated;
    private final Counter numWorkerLaunchFailed;
    private final Counter numWorkerUnschedulable;
    private final Counter numWorkersDisabledVM;
    private final Counter numHeartBeatsReceived;
    private final Gauge lastWorkerLaunchToStartMillis;

    public JobWorker(IMantisWorkerMetadata metadata, LifecycleEventPublisher eventPublisher) {
        Preconditions.checkNotNull((Object)metadata, (String)"metadata");
        this.metadata = metadata;
        this.eventPublisher = eventPublisher;
        this.metricsGroupId = new MetricGroupId("JobWorker", new Tag[]{new BasicTag("jobId", this.metadata.getJobId())});
        Metrics m = new Metrics.Builder().id(this.metricsGroupId).addCounter("numWorkerLaunched").addCounter("numWorkerTerminated").addCounter("numWorkerLaunchFailed").addCounter("numWorkerUnschedulable").addCounter("numWorkersDisabledVM").addCounter("numHeartBeatsReceived").addGauge("lastWorkerLaunchToStartMillis").build();
        this.metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.numWorkerLaunched = this.metrics.getCounter("numWorkerLaunched");
        this.numWorkerTerminated = this.metrics.getCounter("numWorkerTerminated");
        this.numWorkerLaunchFailed = this.metrics.getCounter("numWorkerLaunchFailed");
        this.numWorkerUnschedulable = this.metrics.getCounter("numWorkerUnschedulable");
        this.numWorkersDisabledVM = this.metrics.getCounter("numWorkersDisabledVM");
        this.numHeartBeatsReceived = this.metrics.getCounter("numHeartBeatsReceived");
        this.lastWorkerLaunchToStartMillis = this.metrics.getGauge("lastWorkerLaunchToStartMillis");
    }

    public IMantisWorkerMetadata getMetadata() {
        return this.metadata;
    }

    private MantisWorkerMetadataImpl mutableMetadata() {
        if (this.metadata instanceof MantisWorkerMetadataImpl) {
            return (MantisWorkerMetadataImpl)this.metadata;
        }
        throw new IllegalStateException();
    }

    private void setState(WorkerState newState, long when, JobCompletedReason reason) throws InvalidWorkerStateChangeException {
        this.mutableMetadata().setState(newState, when, reason);
    }

    private void setLastHeartbeatAt(long lastHeartbeatAt) {
        this.mutableMetadata().setLastHeartbeatAt(lastHeartbeatAt);
    }

    private void setSlave(String slave) {
        this.mutableMetadata().setSlave(slave);
    }

    private void setSlaveID(String slaveID) {
        this.mutableMetadata().setSlaveID(slaveID);
    }

    private void setCluster(Optional<String> cluster) {
        this.mutableMetadata().setCluster(cluster);
    }

    private void setResourceCluster(ClusterID clusterID) {
        this.mutableMetadata().setResourceCluster(clusterID);
    }

    void setIsSubscribed(boolean isSub) {
        this.mutableMetadata().setIsSubscribed(isSub);
    }

    void addPorts(WorkerPorts ports) {
        this.mutableMetadata().addPorts(ports);
    }

    public boolean processEvent(WorkerEvent workerEvent) throws InvalidWorkerStateChangeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing event {} for worker {}", (Object)workerEvent, (Object)this.metadata.getWorkerId());
        }
        boolean persistStateRequired = false;
        if (workerEvent instanceof WorkerLaunched) {
            persistStateRequired = this.onWorkerLaunched((WorkerLaunched)workerEvent);
        } else if (workerEvent instanceof WorkerLaunchFailed) {
            persistStateRequired = this.onWorkerLaunchFailed((WorkerLaunchFailed)workerEvent);
        } else if (workerEvent instanceof WorkerUnscheduleable) {
            persistStateRequired = this.onWorkerUnscheduleable((WorkerUnscheduleable)workerEvent);
        } else if (workerEvent instanceof WorkerResourceStatus) {
            persistStateRequired = this.onWorkerResourceStatus((WorkerResourceStatus)workerEvent);
        } else if (workerEvent instanceof WorkerHeartbeat) {
            persistStateRequired = this.onHeartBeat((WorkerHeartbeat)workerEvent);
        } else if (workerEvent instanceof WorkerTerminate) {
            persistStateRequired = this.onTerminate((WorkerTerminate)workerEvent);
        } else if (workerEvent instanceof WorkerOnDisabledVM) {
            persistStateRequired = this.onDisabledVM((WorkerOnDisabledVM)workerEvent);
        } else if (workerEvent instanceof WorkerStatus) {
            persistStateRequired = this.onWorkerStatus((WorkerStatus)workerEvent);
        }
        return persistStateRequired;
    }

    private boolean onWorkerStatus(WorkerStatus workerEvent) throws InvalidWorkerStateChangeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("on WorkerStatus for {}", (Object)workerEvent);
        }
        switch (workerEvent.getState()) {
            case StartInitiated: 
            case Started: 
            case Completed: 
            case Failed: {
                this.setState(workerEvent.getState(), workerEvent.getEventTimeMs(), workerEvent.getStatus().getReason());
                this.eventPublisher.publishStatusEvent(new LifecycleEventsProto.WorkerStatusEvent(LifecycleEventsProto.StatusEvent.StatusEventType.INFO, "worker status update", this.metadata.getStageNum(), workerEvent.getWorkerId(), workerEvent.getState()));
                return true;
            }
        }
        LOGGER.warn("unexpected worker state {} in WorkerStatus update", (Object)workerEvent.getState().name());
        return false;
    }

    private boolean onDisabledVM(WorkerOnDisabledVM workerEvent) {
        this.numWorkersDisabledVM.increment();
        LOGGER.info("on WorkerDisabledVM for {}", (Object)workerEvent);
        return false;
    }

    private boolean onTerminate(WorkerTerminate workerEvent) throws InvalidWorkerStateChangeException {
        this.numWorkerTerminated.increment();
        this.setState(workerEvent.getFinalState(), workerEvent.getEventTimeMs(), workerEvent.getReason());
        this.eventPublisher.publishStatusEvent(new LifecycleEventsProto.WorkerStatusEvent(LifecycleEventsProto.StatusEvent.StatusEventType.INFO, "worker terminated", -1, workerEvent.getWorkerId(), WorkerState.Failed, Optional.ofNullable(this.metadata.getSlave())));
        return true;
    }

    private boolean onWorkerLaunched(WorkerLaunched workerEvent) throws InvalidWorkerStateChangeException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing for worker {} with id {}", (Object)workerEvent, (Object)this.metadata.getWorkerId());
        }
        this.setSlave(workerEvent.getHostname());
        this.addPorts(workerEvent.getPorts());
        this.setSlaveID(workerEvent.getVmId());
        this.setCluster(workerEvent.getClusterName());
        workerEvent.getResourceCluster().ifPresent(this::setResourceCluster);
        this.setState(WorkerState.Launched, workerEvent.getEventTimeMs(), JobCompletedReason.Normal);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Worker {} state changed to Launched", (Object)workerEvent.getWorkerId());
        }
        this.numWorkerLaunched.increment();
        try {
            this.eventPublisher.publishStatusEvent(new LifecycleEventsProto.WorkerStatusEvent(LifecycleEventsProto.StatusEvent.StatusEventType.INFO, "scheduled on " + workerEvent.getHostname() + " with ports " + Jackson.toJson(workerEvent.getPorts()), workerEvent.getStageNum(), workerEvent.getWorkerId(), WorkerState.Launched));
        }
        catch (IOException e) {
            LOGGER.warn("Error publishing status event for worker {} launch", (Object)workerEvent.getWorkerId(), (Object)e);
        }
        return true;
    }

    private boolean onWorkerResourceStatus(WorkerResourceStatus workerEvent) throws InvalidWorkerStateChangeException {
        WorkerState workerStateFromEvent = WorkerStateAdapter.from(workerEvent.getState());
        if (WorkerState.isRunningState(workerStateFromEvent) && WorkerState.isTerminalState(this.metadata.getState())) {
            this.numWorkerTerminated.increment();
        }
        if (WorkerState.isTerminalState(workerStateFromEvent) && !WorkerState.isTerminalState(this.metadata.getState())) {
            LOGGER.info("Worker {} state changed to {}", (Object)this, (Object)workerEvent.getState());
            this.setState(workerStateFromEvent, workerEvent.getEventTimeMs(), JobCompletedReason.Normal);
            this.eventPublisher.publishStatusEvent(new LifecycleEventsProto.WorkerStatusEvent(LifecycleEventsProto.StatusEvent.StatusEventType.INFO, "worker resource state " + workerEvent.getMessage(), -1, workerEvent.getWorkerId(), workerStateFromEvent, Optional.ofNullable(this.metadata.getSlave())));
            return true;
        }
        return false;
    }

    private boolean onHeartBeat(WorkerHeartbeat workerEvent) throws InvalidWorkerStateChangeException {
        this.numHeartBeatsReceived.increment();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Job {} Processing onHeartBeat for {}", (Object)this.metadata.getJobId(), (Object)this.metadata.getWorkerId());
        }
        WorkerState workerState = this.metadata.getState();
        this.setLastHeartbeatAt(workerEvent.getEventTimeMs());
        boolean persistStateRequired = false;
        if (workerState != WorkerState.Started) {
            this.setState(WorkerState.Started, workerEvent.getEventTimeMs(), JobCompletedReason.Normal);
            persistStateRequired = true;
            long startLatency = workerEvent.getEventTimeMs() - this.metadata.getLaunchedAt();
            if (startLatency > 0L) {
                this.lastWorkerLaunchToStartMillis.set(startLatency);
            } else {
                LOGGER.info("Unexpected error when computing startlatency for {} start time {} launch time {}", new Object[]{workerEvent.getWorkerId().getId(), workerEvent.getEventTimeMs(), this.metadata.getLaunchedAt()});
            }
            LOGGER.info("Job {} Worker {} started ", (Object)this.metadata.getJobId(), (Object)this.metadata.getWorkerId());
            this.eventPublisher.publishStatusEvent(new LifecycleEventsProto.WorkerStatusEvent(LifecycleEventsProto.StatusEvent.StatusEventType.INFO, "setting worker Started on heartbeat", workerEvent.getStatus().getStageNum(), workerEvent.getWorkerId(), WorkerState.Started, Optional.ofNullable(this.metadata.getSlave())));
        }
        List payloads = workerEvent.getStatus().getPayloads();
        for (Status.Payload payload : payloads) {
            if (!payload.getType().equals(StatusPayloads.Type.SubscriptionState.toString())) continue;
            String data = payload.getData();
            try {
                boolean subscriptionStatus = Boolean.parseBoolean(data);
                if (this.getMetadata().getIsSubscribed() == subscriptionStatus) continue;
                this.setIsSubscribed(subscriptionStatus);
                persistStateRequired = true;
            }
            catch (Exception e) {
                LOGGER.warn("Exception parsing subscription payload", (Throwable)e);
            }
        }
        return persistStateRequired;
    }

    private boolean onWorkerLaunchFailed(WorkerLaunchFailed workerEvent) throws InvalidWorkerStateChangeException {
        this.numWorkerLaunchFailed.increment();
        this.setState(WorkerState.Failed, workerEvent.getEventTimeMs(), JobCompletedReason.Error);
        this.eventPublisher.publishStatusEvent(new LifecycleEventsProto.WorkerStatusEvent(LifecycleEventsProto.StatusEvent.StatusEventType.ERROR, "worker launch failed, reason: " + workerEvent.getErrorMessage(), workerEvent.getStageNum(), workerEvent.getWorkerId(), WorkerState.Failed));
        return true;
    }

    private boolean onWorkerUnscheduleable(WorkerUnscheduleable workerEvent) {
        this.numWorkerUnschedulable.increment();
        return true;
    }

    @Override
    public void processEvent(WorkerEvent event, MantisJobStore jobStore) throws InvalidWorkerStateChangeException, IOException {
        if (event.getWorkerId().equals((Object)this.metadata.getWorkerId())) {
            boolean persistStateRequired = this.processEvent(event);
            if (persistStateRequired) {
                jobStore.updateWorker(this.metadata);
            }
        } else {
            LOGGER.warn("Current workerId is " + this.metadata.getWorkerId() + " event received from workerId " + event.getWorkerId() + " ignoring");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobWorker jobWorker = (JobWorker)o;
        return Objects.equals(this.metadata, jobWorker.metadata) && Objects.equals(this.eventPublisher, jobWorker.eventPublisher);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.eventPublisher);
    }

    public String toString() {
        return "JobWorker{metadata=" + this.metadata + '}';
    }

    public static class Builder {
        private static final int INVALID_VALUE = -1;
        private int workerIndex = -1;
        private int workerNumber = -1;
        private String jobId = null;
        private int stageNum = -1;
        private int numberOfPorts = -1;
        private WorkerPorts workerPorts = null;
        private WorkerState state = WorkerState.Accepted;
        private String slave = null;
        private String slaveID = null;
        private long acceptedAt = System.currentTimeMillis();
        private long launchedAt = -1L;
        private long startingAt = -1L;
        private long startedAt = -1L;
        private long completedAt = -1L;
        private JobCompletedReason reason = JobCompletedReason.Normal;
        private int resubmitOf = 0;
        private int totalResubmitCount = 0;
        private Optional<String> preferredCluster = Optional.empty();
        private Optional<ClusterID> resourceCluster = Optional.empty();
        private IMantisWorkerMetadata metadata;
        private LifecycleEventPublisher eventPublisher;

        public Builder withWorkerIndex(int ind) {
            this.workerIndex = ind;
            return this;
        }

        public Builder withWorkerNumber(int num) {
            this.workerNumber = num;
            return this;
        }

        public Builder withResubmitCount(int c) {
            this.totalResubmitCount = c;
            return this;
        }

        public Builder withResubmitOf(int r) {
            this.resubmitOf = r;
            return this;
        }

        public Builder withJobId(String jid) {
            this.jobId = jid;
            return this;
        }

        public Builder withJobId(JobId jid) {
            this.jobId = jid.getId();
            return this;
        }

        public Builder withStageNum(int num) {
            this.stageNum = num;
            return this;
        }

        public Builder withNumberOfPorts(int portNums) {
            this.numberOfPorts = portNums;
            return this;
        }

        public Builder withWorkerPorts(WorkerPorts workerP) {
            this.workerPorts = workerP;
            return this;
        }

        public Builder withState(WorkerState state) {
            this.state = state;
            return this;
        }

        public Builder withSlave(String slave) {
            this.slave = slave;
            return this;
        }

        public Builder withSlaveID(String slaveid) {
            this.slaveID = slaveid;
            return this;
        }

        public Builder withAcceptedAt(long acc) {
            this.acceptedAt = acc;
            return this;
        }

        public Builder withLaunchedAt(long la) {
            this.launchedAt = la;
            return this;
        }

        public Builder withStartingAt(long sa) {
            this.startingAt = sa;
            return this;
        }

        public Builder withStartedAt(long sa) {
            this.startedAt = sa;
            return this;
        }

        public Builder withCompletedAt(long ca) {
            this.completedAt = ca;
            return this;
        }

        public Builder withPreferredCluster(Optional<String> preferredCluster) {
            this.preferredCluster = preferredCluster;
            return this;
        }

        public Builder withResourceCluster(ClusterID resourceCluster) {
            this.resourceCluster = Optional.of(resourceCluster);
            return this;
        }

        public Builder withJobCompletedReason(JobCompletedReason reason) {
            this.reason = reason;
            return this;
        }

        public Builder withLifecycleEventsPublisher(LifecycleEventPublisher publisher) {
            this.eventPublisher = publisher;
            return this;
        }

        public Builder from(IMantisWorkerMetadata cloneFrom) {
            this.workerIndex = cloneFrom.getWorkerIndex();
            this.workerNumber = cloneFrom.getWorkerNumber();
            this.jobId = cloneFrom.getJobId();
            this.stageNum = cloneFrom.getStageNum();
            this.numberOfPorts = cloneFrom.getNumberOfPorts();
            if (cloneFrom.getPorts().isPresent()) {
                this.workerPorts = cloneFrom.getPorts().get();
            }
            this.state = cloneFrom.getState();
            this.slave = cloneFrom.getSlave();
            this.slaveID = cloneFrom.getSlaveID();
            this.acceptedAt = cloneFrom.getAcceptedAt();
            this.launchedAt = cloneFrom.getLaunchedAt();
            this.startingAt = cloneFrom.getStartingAt();
            this.startedAt = cloneFrom.getStartedAt();
            this.completedAt = cloneFrom.getCompletedAt();
            this.reason = cloneFrom.getReason();
            this.resubmitOf = cloneFrom.getResubmitOf();
            this.totalResubmitCount = cloneFrom.getTotalResubmitCount();
            this.preferredCluster = cloneFrom.getPreferredClusterOptional();
            this.resourceCluster = cloneFrom.getResourceCluster();
            return this;
        }

        public JobWorker build() {
            Objects.requireNonNull(this.jobId, "Job Id cannot be null");
            if (this.workerIndex <= -1) {
                IllegalArgumentException ex = new IllegalArgumentException(String.format("Invalid workerIndex %d specified", this.workerIndex));
                LOGGER.error("Invalid worker index specified {}", (Object)this.workerIndex, (Object)ex);
                throw ex;
            }
            if (this.workerNumber <= -1) {
                LOGGER.error("Invalid worker number specified {}", (Object)this.workerNumber);
                throw new IllegalArgumentException(String.format("Invalid workerNumber %d specified", this.workerNumber));
            }
            if (this.stageNum <= -1) {
                LOGGER.error("Invalid stage num specified {}", (Object)this.stageNum);
                throw new IllegalArgumentException(String.format("Invalid stageNum %d specified", this.stageNum));
            }
            if (this.numberOfPorts <= -1) {
                LOGGER.error("Invalid num ports specified {}", (Object)this.numberOfPorts);
                throw new IllegalArgumentException(String.format("Invalid no of Ports %d specified", this.numberOfPorts));
            }
            if (this.totalResubmitCount < 0) {
                LOGGER.error("Invalid resubmit count specified {}", (Object)this.totalResubmitCount);
                throw new IllegalArgumentException(String.format("Invalid resubmit Count %d specified", this.totalResubmitCount));
            }
            if (this.eventPublisher == null) {
                IllegalArgumentException ex = new IllegalArgumentException("lifecycle event publisher cannot be null");
                LOGGER.error("lifecycle event publisher is null", (Throwable)ex);
                throw ex;
            }
            this.metadata = new MantisWorkerMetadataImpl(this.workerIndex, this.workerNumber, this.jobId, this.stageNum, this.numberOfPorts, this.workerPorts, this.state, this.slave, this.slaveID, this.acceptedAt, this.launchedAt, this.startingAt, this.startedAt, this.completedAt, this.reason, this.resubmitOf, this.totalResubmitCount, this.preferredCluster, this.resourceCluster);
            return new JobWorker(this.metadata, this.eventPublisher);
        }
    }
}

