/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.jobcluster.job.worker;

import io.mantisrx.master.jobcluster.job.worker.WorkerState;
import io.mantisrx.server.core.JobCompletedReason;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.scheduler.WorkerEvent;

public class WorkerTerminate
implements WorkerEvent {
    private final JobCompletedReason reason;
    private final WorkerId workerId;
    private final long eventTime;
    private final WorkerState finalState;

    public WorkerTerminate(WorkerId workerId, WorkerState state, JobCompletedReason reason, long time) {
        this.workerId = workerId;
        this.reason = reason;
        this.finalState = state;
        this.eventTime = time;
    }

    public WorkerTerminate(WorkerId workerId, WorkerState state, JobCompletedReason reason) {
        this(workerId, state, reason, System.currentTimeMillis());
    }

    @Override
    public WorkerId getWorkerId() {
        return this.workerId;
    }

    @Override
    public long getEventTimeMs() {
        return this.eventTime;
    }

    public JobCompletedReason getReason() {
        return this.reason;
    }

    public WorkerState getFinalState() {
        return this.finalState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.eventTime ^ this.eventTime >>> 32);
        result = 31 * result + (this.finalState == null ? 0 : this.finalState.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.workerId == null ? 0 : this.workerId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WorkerTerminate other = (WorkerTerminate)obj;
        if (this.eventTime != other.eventTime) {
            return false;
        }
        if (this.finalState != other.finalState) {
            return false;
        }
        if (this.reason != other.reason) {
            return false;
        }
        return !(this.workerId == null ? other.workerId != null : !this.workerId.equals((Object)other.workerId));
    }

    public String toString() {
        return "WorkerTerminate [reason=" + this.reason + ", workerId=" + this.workerId + ", eventTime=" + this.eventTime + ", finalState=" + (Object)((Object)this.finalState) + "]";
    }
}

