/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import io.mantisrx.master.resourcecluster.ExecutorStateManager;
import io.mantisrx.master.resourcecluster.ResourceClusterActor;
import io.mantisrx.master.resourcecluster.TaskExecutorState;
import io.mantisrx.master.resourcecluster.proto.GetClusterIdleInstancesRequest;
import io.mantisrx.master.resourcecluster.proto.GetClusterUsageResponse;
import io.mantisrx.master.scheduler.CpuWeightedFitnessCalculator;
import io.mantisrx.master.scheduler.FitnessCalculator;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.core.scheduler.SchedulingConstraints;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.server.master.resourcecluster.ResourceCluster;
import io.mantisrx.server.master.resourcecluster.TaskExecutorAllocationRequest;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.shaded.com.google.common.cache.Cache;
import io.mantisrx.shaded.com.google.common.cache.CacheBuilder;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.util.Precision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExecutorStateManagerImpl
implements ExecutorStateManager {
    private static final Logger log = LoggerFactory.getLogger(ExecutorStateManagerImpl.class);
    private final Map<TaskExecutorID, TaskExecutorState> taskExecutorStateMap = new HashMap<TaskExecutorID, TaskExecutorState>();
    Cache<String, JobRequirements> pendingJobRequests = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).removalListener(notification -> log.info("Removing key {} from pending job requests due to reason {}", notification.getKey(), (Object)notification.getCause())).build();
    private final Map<TaskExecutorRegistration.TaskExecutorGroupKey, NavigableSet<TaskExecutorHolder>> executorsByGroup = new HashMap<TaskExecutorRegistration.TaskExecutorGroupKey, NavigableSet<TaskExecutorHolder>>();
    private final FitnessCalculator fitnessCalculator;
    private final Map<String, String> schedulingAttributes;
    private final Cache<TaskExecutorID, TaskExecutorState> archivedState = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(24L, TimeUnit.HOURS).removalListener(notification -> log.info("Archived TaskExecutor: {} removed due to: {}", notification.getKey(), (Object)notification.getCause())).build();

    ExecutorStateManagerImpl(Map<String, String> schedulingAttributes) {
        this.schedulingAttributes = schedulingAttributes;
        this.fitnessCalculator = new CpuWeightedFitnessCalculator();
    }

    ExecutorStateManagerImpl(Map<String, String> schedulingAttributes, FitnessCalculator fitnessCalculator) {
        this.schedulingAttributes = schedulingAttributes;
        this.fitnessCalculator = fitnessCalculator;
    }

    @Override
    public void trackIfAbsent(TaskExecutorID taskExecutorID, TaskExecutorState state) {
        this.taskExecutorStateMap.putIfAbsent(taskExecutorID, state);
        if (this.archivedState.getIfPresent((Object)taskExecutorID) != null) {
            log.info("Reviving archived executor: {}", (Object)taskExecutorID);
            this.archivedState.invalidate((Object)taskExecutorID);
        }
        this.tryMarkAvailable(taskExecutorID, state);
    }

    private boolean tryMarkAvailable(TaskExecutorID taskExecutorID, TaskExecutorState state) {
        if (state.isAvailable() && state.getRegistration() != null) {
            TaskExecutorHolder teHolder = TaskExecutorHolder.of(taskExecutorID, state.getRegistration());
            log.debug("Marking executor {} as available for matching.", (Object)teHolder);
            TaskExecutorRegistration.TaskExecutorGroupKey taskExecutorGroupKey = state.getRegistration().getGroup();
            if (!this.executorsByGroup.containsKey(taskExecutorGroupKey)) {
                log.info("[executorsByGroup] adding {} from TE: {}", (Object)taskExecutorGroupKey, (Object)teHolder);
                this.executorsByGroup.putIfAbsent(taskExecutorGroupKey, new TreeSet<TaskExecutorHolder>(TaskExecutorHolder.generationFirstComparator));
            }
            log.info("Assign {} to available.", (Object)teHolder.getId());
            return this.executorsByGroup.get(taskExecutorGroupKey).add(teHolder);
        }
        log.debug("Ignore unavailable TE: {}", (Object)taskExecutorID);
        return false;
    }

    @Override
    public boolean tryMarkAvailable(TaskExecutorID taskExecutorID) {
        if (!this.taskExecutorStateMap.containsKey(taskExecutorID)) {
            log.warn("marking invalid executor as available: {}", (Object)taskExecutorID);
            return false;
        }
        TaskExecutorState taskExecutorState = this.taskExecutorStateMap.get(taskExecutorID);
        return this.tryMarkAvailable(taskExecutorID, taskExecutorState);
    }

    @Override
    public boolean tryMarkUnavailable(TaskExecutorID taskExecutorID) {
        TaskExecutorState taskExecutorState;
        if (this.taskExecutorStateMap.containsKey(taskExecutorID) && (taskExecutorState = this.taskExecutorStateMap.get(taskExecutorID)).getRegistration() != null) {
            TaskExecutorRegistration.TaskExecutorGroupKey taskExecutorGroupKey = taskExecutorState.getRegistration().getGroup();
            if (this.executorsByGroup.containsKey(taskExecutorGroupKey)) {
                this.executorsByGroup.get(taskExecutorGroupKey).remove(TaskExecutorHolder.of(taskExecutorID, taskExecutorState.getRegistration()));
            }
            return true;
        }
        log.warn("invalid task executor to mark as unavailable: {}", (Object)taskExecutorID);
        return false;
    }

    @Override
    public ResourceCluster.ResourceOverview getResourceOverview() {
        long numRegistered = this.taskExecutorStateMap.values().stream().filter(TaskExecutorState::isRegistered).count();
        long numAvailable = this.taskExecutorStateMap.values().stream().filter(TaskExecutorState::isAvailable).count();
        long numOccupied = this.taskExecutorStateMap.values().stream().filter(TaskExecutorState::isRunningTask).count();
        long numAssigned = this.taskExecutorStateMap.values().stream().filter(TaskExecutorState::isAssigned).count();
        long numDisabled = this.taskExecutorStateMap.values().stream().filter(TaskExecutorState::isDisabled).count();
        return new ResourceCluster.ResourceOverview(numRegistered, numAvailable, numOccupied, numAssigned, numDisabled);
    }

    @Override
    public List<TaskExecutorID> getIdleInstanceList(GetClusterIdleInstancesRequest req) {
        return this.taskExecutorStateMap.entrySet().stream().filter(kv -> {
            if (((TaskExecutorState)kv.getValue()).getRegistration() == null) {
                return false;
            }
            Optional skuIdO = ((TaskExecutorState)kv.getValue()).getRegistration().getTaskExecutorContainerDefinitionId();
            return skuIdO.isPresent() && ((ContainerSkuID)skuIdO.get()).equals((Object)req.getSkuId());
        }).filter(isAvailable).map(Map.Entry::getKey).limit(req.getMaxInstanceCount()).collect(Collectors.toList());
    }

    @Override
    public TaskExecutorState get(TaskExecutorID taskExecutorID) {
        return this.taskExecutorStateMap.get(taskExecutorID);
    }

    @Override
    public TaskExecutorState getIncludeArchived(TaskExecutorID taskExecutorID) {
        if (this.taskExecutorStateMap.containsKey(taskExecutorID)) {
            return this.taskExecutorStateMap.get(taskExecutorID);
        }
        return (TaskExecutorState)this.archivedState.getIfPresent((Object)taskExecutorID);
    }

    @Override
    public TaskExecutorState archive(TaskExecutorID taskExecutorID) {
        if (this.taskExecutorStateMap.containsKey(taskExecutorID)) {
            this.archivedState.put((Object)taskExecutorID, (Object)this.taskExecutorStateMap.get(taskExecutorID));
            this.taskExecutorStateMap.remove(taskExecutorID);
            return (TaskExecutorState)this.archivedState.getIfPresent((Object)taskExecutorID);
        }
        log.warn("archiving invalid TaskExecutor: {}", (Object)taskExecutorID);
        return null;
    }

    @Override
    public List<TaskExecutorID> getTaskExecutors(Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> predicate) {
        return this.taskExecutorStateMap.entrySet().stream().filter(predicate).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public List<String> getActiveJobs(ResourceClusterActor.GetActiveJobsRequest req) {
        return this.taskExecutorStateMap.values().stream().map(TaskExecutorState::getWorkerId).filter(Objects::nonNull).map(WorkerId::getJobId).distinct().sorted(String::compareToIgnoreCase).skip(req.getStartingIndex().orElse(0).intValue()).limit(req.getPageSize().orElse(3000).intValue()).collect(Collectors.toList());
    }

    @Override
    public Optional<Map.Entry<TaskExecutorID, TaskExecutorState>> findFirst(Predicate<Map.Entry<TaskExecutorID, TaskExecutorState>> predicate) {
        return this.taskExecutorStateMap.entrySet().stream().filter(predicate).findFirst();
    }

    @Override
    public Optional<ResourceClusterActor.BestFit> findBestFit(ResourceClusterActor.TaskExecutorBatchAssignmentRequest request) {
        if (request.getAllocationRequests().isEmpty()) {
            log.warn("TaskExecutorBatchAssignmentRequest {} with empty allocation requests.", (Object)request);
            return Optional.empty();
        }
        boolean noResourcesAvailable = false;
        ResourceClusterActor.BestFit bestFit = new ResourceClusterActor.BestFit();
        boolean isJobIdAlreadyPending = this.pendingJobRequests.getIfPresent((Object)request.getJobId()) != null;
        for (Map.Entry<SchedulingConstraints, List<TaskExecutorAllocationRequest>> entry : request.getGroupedBySchedulingConstraints().entrySet()) {
            List<TaskExecutorAllocationRequest> allocationRequests;
            SchedulingConstraints schedulingConstraints = entry.getKey();
            Optional<Map<TaskExecutorID, TaskExecutorState>> taskExecutors = this.findTaskExecutorsFor(request, schedulingConstraints, allocationRequests = entry.getValue(), isJobIdAlreadyPending, bestFit);
            if (!taskExecutors.isPresent()) {
                noResourcesAvailable = true;
                break;
            }
            int index = 0;
            for (Map.Entry<TaskExecutorID, TaskExecutorState> taskToStateEntry : taskExecutors.get().entrySet()) {
                bestFit.add(allocationRequests.get(index), (Pair<TaskExecutorID, TaskExecutorState>)Pair.of((Object)taskToStateEntry.getKey(), (Object)taskToStateEntry.getValue()));
                ++index;
            }
        }
        if (noResourcesAvailable) {
            log.warn("Not all scheduling constraints had enough workers available to fulfill the request {}", (Object)request);
            return Optional.empty();
        }
        return Optional.of(bestFit);
    }

    private Optional<Map<TaskExecutorID, TaskExecutorState>> findBestFitFor(ResourceClusterActor.TaskExecutorBatchAssignmentRequest request, SchedulingConstraints schedulingConstraints, Integer numWorkers, ResourceClusterActor.BestFit currentBestFit) {
        Optional<TaskExecutorRegistration.TaskExecutorGroupKey> bestFitTeGroupKey = this.findBestGroup(schedulingConstraints);
        if (!bestFitTeGroupKey.isPresent()) {
            log.warn("Cannot find any matching sku for request: {}", (Object)request);
            return Optional.empty();
        }
        log.info("Applying assignment request: {} to constraints {}.", (Object)request, bestFitTeGroupKey);
        if (!this.executorsByGroup.containsKey(bestFitTeGroupKey.get())) {
            log.warn("No available TE found for constraints: {}, request: {}", (Object)bestFitTeGroupKey.get(), (Object)request);
            return Optional.empty();
        }
        return Optional.of(this.executorsByGroup.get(bestFitTeGroupKey.get()).descendingSet().stream().filter(teHolder -> {
            if (!this.taskExecutorStateMap.containsKey(teHolder.getId())) {
                return false;
            }
            if (currentBestFit.contains(teHolder.getId())) {
                return false;
            }
            TaskExecutorState st = this.taskExecutorStateMap.get(teHolder.getId());
            return st.isAvailable() && st.getRegistration() != null;
        }).limit(numWorkers.intValue()).map(TaskExecutorHolder::getId).collect(Collectors.toMap(taskExecutorID -> taskExecutorID, this.taskExecutorStateMap::get)));
    }

    public boolean areSchedulingAttributeConstraintsSatisfied(SchedulingConstraints constraints, Map<String, String> teAssignmentAttributes) {
        Map<String, String> teAssignmentAttributesLowercased = teAssignmentAttributes.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
        Map<String, String> constraintsAttributesLowercased = constraints.getSchedulingAttributes().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
        return this.schedulingAttributes.entrySet().stream().allMatch(entry -> {
            String lowerCaseKey = ((String)entry.getKey()).toLowerCase();
            return ((String)teAssignmentAttributesLowercased.getOrDefault(lowerCaseKey, (String)entry.getValue())).equalsIgnoreCase((String)constraintsAttributesLowercased.getOrDefault(lowerCaseKey, (String)entry.getValue()));
        });
    }

    @Override
    public Set<Map.Entry<TaskExecutorID, TaskExecutorState>> getActiveExecutorEntry() {
        return this.taskExecutorStateMap.entrySet();
    }

    @Override
    public GetClusterUsageResponse getClusterUsage(ResourceClusterActor.GetClusterUsageRequest req) {
        HashMap pendingCountByGroupKey = new HashMap();
        HashMap<String, Pair> usageByGroupKey = new HashMap<String, Pair>();
        HashMap<String, List> jobIdToMachineDef = new HashMap<String, List>();
        this.taskExecutorStateMap.forEach((key, value) -> {
            if (value == null || value.getRegistration() == null) {
                log.info("Empty registration: {}, {}. Skip usage request.", (Object)req.getClusterID(), key);
                return;
            }
            if (value.isDisabled()) {
                return;
            }
            Optional<String> groupKeyO = req.getGroupKeyFunc().apply(value.getRegistration());
            if (!groupKeyO.isPresent()) {
                log.info("Empty groupKey from: {}, {}. Skip usage request.", (Object)req.getClusterID(), key);
                return;
            }
            String groupKey = groupKeyO.get();
            Pair kvState = Pair.of((Object)(value.isAvailable() ? 1 : 0), (Object)(value.isRegistered() ? 1 : 0));
            if (usageByGroupKey.containsKey(groupKey)) {
                Pair prevState = (Pair)usageByGroupKey.get(groupKey);
                usageByGroupKey.put(groupKey, Pair.of((Object)((Integer)kvState.getLeft() + (Integer)prevState.getLeft()), (Object)((Integer)kvState.getRight() + (Integer)prevState.getRight())));
            } else {
                usageByGroupKey.put(groupKey, kvState);
            }
            if ((value.isAssigned() || value.isRunningTask()) && value.getWorkerId() != null && this.pendingJobRequests.getIfPresent((Object)value.getWorkerId().getJobId()) != null) {
                List workers = jobIdToMachineDef.getOrDefault(value.getWorkerId().getJobId(), new ArrayList());
                workers.add(value.getRegistration().getMachineDefinition());
                jobIdToMachineDef.put(value.getWorkerId().getJobId(), workers);
            }
            if (!pendingCountByGroupKey.containsKey(groupKey)) {
                pendingCountByGroupKey.put(groupKey, this.getPendingCountByTaskExecutorGroup(value.getRegistration().getGroup()));
            }
        });
        jobIdToMachineDef.forEach((jobId, workers) -> {
            JobRequirements jobStats = (JobRequirements)this.pendingJobRequests.getIfPresent(jobId);
            if (jobStats != null && jobStats.getTotalWorkers() <= workers.size()) {
                log.info("Removing job {} from pending requests", jobId);
                this.pendingJobRequests.invalidate(jobId);
            }
        });
        GetClusterUsageResponse.GetClusterUsageResponseBuilder resBuilder = GetClusterUsageResponse.builder().clusterID(req.getClusterID());
        usageByGroupKey.forEach((key, value) -> resBuilder.usage(GetClusterUsageResponse.UsageByGroupKey.builder().usageGroupKey((String)key).idleCount((Integer)value.getLeft() - (Integer)pendingCountByGroupKey.get(key)).totalCount((Integer)value.getRight()).build()));
        GetClusterUsageResponse res = resBuilder.build();
        log.info("Usage result: {}", (Object)res);
        return res;
    }

    private int getPendingCountByTaskExecutorGroup(TaskExecutorRegistration.TaskExecutorGroupKey teGroup) {
        return this.pendingJobRequests.asMap().values().stream().map(req -> req.getGroupToTaskExecutorCount().getOrDefault(teGroup, 0)).reduce(Integer::sum).orElse(0);
    }

    private Optional<Map<TaskExecutorID, TaskExecutorState>> findTaskExecutorsFor(ResourceClusterActor.TaskExecutorBatchAssignmentRequest request, SchedulingConstraints schedulingConstraints, List<TaskExecutorAllocationRequest> allocationRequests, boolean isJobIdAlreadyPending, ResourceClusterActor.BestFit currentBestFit) {
        Optional<Map<TaskExecutorID, TaskExecutorState>> taskExecutors = this.findBestFitFor(request, schedulingConstraints, allocationRequests.size(), currentBestFit);
        if (taskExecutors.isPresent() && taskExecutors.get().size() == allocationRequests.size()) {
            return taskExecutors;
        }
        log.warn("Not enough available TEs found for scheduling constraints {}, request: {}", (Object)schedulingConstraints, (Object)request);
        if (!isJobIdAlreadyPending && request.getAllocationRequests().size() > 2 && this.pendingJobRequests.getIfPresent((Object)request.getJobId()) == null) {
            log.info("Adding job {} to pending requests for {} scheduling constraints {}", new Object[]{request.getJobId(), allocationRequests.size(), schedulingConstraints});
            this.pendingJobRequests.put((Object)request.getJobId(), (Object)new JobRequirements(request.getGroupedBySchedulingConstraints()));
        }
        return Optional.empty();
    }

    private Optional<TaskExecutorRegistration.TaskExecutorGroupKey> findBestGroup(SchedulingConstraints requestedConstraints) {
        Optional<TaskExecutorRegistration.TaskExecutorGroupKey> bestGroupBySizeName = this.findBestGroupBySizeNameMatch(requestedConstraints);
        return bestGroupBySizeName.isPresent() ? bestGroupBySizeName : this.findBestGroupByFitnessCalculator(requestedConstraints);
    }

    private Optional<TaskExecutorRegistration.TaskExecutorGroupKey> findBestGroupBySizeNameMatch(SchedulingConstraints requestedConstraints) {
        return this.executorsByGroup.keySet().stream().filter(group -> group.getSizeName().isPresent()).filter(group -> requestedConstraints.getSizeName().isPresent()).filter(group -> ((String)group.getSizeName().get()).equalsIgnoreCase((String)requestedConstraints.getSizeName().get())).filter(taskExecutorGroupKey -> this.areSchedulingAttributeConstraintsSatisfied(requestedConstraints, taskExecutorGroupKey.getSchedulingAttributes())).max(Comparator.comparing(taskExecutorGroupKey -> {
            NavigableSet<TaskExecutorHolder> holders = this.executorsByGroup.get(taskExecutorGroupKey);
            if (holders.isEmpty()) {
                return null;
            }
            return ((TaskExecutorHolder)holders.last()).getGeneration();
        }, Comparator.nullsLast(Comparator.reverseOrder())));
    }

    private Optional<TaskExecutorRegistration.TaskExecutorGroupKey> findBestGroupByFitnessCalculator(SchedulingConstraints requestedConstraints) {
        log.info("Falling back to find best group by fitness calculator for constraints: {}", (Object)requestedConstraints);
        return this.executorsByGroup.keySet().stream().filter(taskExecutorGroupKey -> {
            Optional teGroupSizeName = taskExecutorGroupKey.getSizeName();
            Optional requestSizeName = requestedConstraints.getSizeName();
            return !teGroupSizeName.isPresent() || !requestSizeName.isPresent() || ((String)teGroupSizeName.get()).equalsIgnoreCase((String)requestSizeName.get());
        }).filter(taskExecutorGroupKey -> this.areSchedulingAttributeConstraintsSatisfied(requestedConstraints, taskExecutorGroupKey.getSchedulingAttributes())).map(key -> new AbstractMap.SimpleEntry<TaskExecutorRegistration.TaskExecutorGroupKey, Double>((TaskExecutorRegistration.TaskExecutorGroupKey)key, this.fitnessCalculator.calculate(requestedConstraints.getMachineDefinition(), key.getMachineDefinition()))).filter(entry -> (Double)entry.getValue() > 0.0).sorted((entry1, entry2) -> {
            int fitnessComparison = Precision.compareTo((double)((Double)entry2.getValue()), (double)((Double)entry1.getValue()), (double)1.0E-4);
            if (fitnessComparison != 0) {
                return fitnessComparison;
            }
            NavigableSet<TaskExecutorHolder> holders1 = this.executorsByGroup.get(entry1.getKey());
            NavigableSet<TaskExecutorHolder> holders2 = this.executorsByGroup.get(entry2.getKey());
            String generation1 = holders1.isEmpty() ? null : ((TaskExecutorHolder)holders1.last()).getGeneration();
            String generation2 = holders2.isEmpty() ? null : ((TaskExecutorHolder)holders2.last()).getGeneration();
            return Comparator.nullsLast(Comparator.reverseOrder()).compare(generation1, generation2);
        }).map(AbstractMap.SimpleEntry::getKey).findFirst();
    }

    protected static final class TaskExecutorHolder {
        private final TaskExecutorID Id;
        private final String generation;
        static Comparator<TaskExecutorHolder> generationFirstComparator = Comparator.comparing(TaskExecutorHolder::getGeneration).thenComparing(teh -> teh.getId().getResourceId());

        static TaskExecutorHolder of(TaskExecutorID id, TaskExecutorRegistration reg) {
            String generation = reg.getAttributeByKey("MANTIS_WORKER_CONTAINER_GENERATION").orElse(reg.getAttributeByKey("NETFLIX_AUTO_SCALE_GROUP").orElse("empty-generation"));
            return TaskExecutorHolder.builder().Id(id).generation(generation).build();
        }

        @ConstructorProperties(value={"Id", "generation"})
        TaskExecutorHolder(TaskExecutorID Id2, String generation) {
            this.Id = Id2;
            this.generation = generation;
        }

        public static TaskExecutorHolderBuilder builder() {
            return new TaskExecutorHolderBuilder();
        }

        public TaskExecutorID getId() {
            return this.Id;
        }

        public String getGeneration() {
            return this.generation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskExecutorHolder)) {
                return false;
            }
            TaskExecutorHolder other = (TaskExecutorHolder)o;
            TaskExecutorID this$Id = this.getId();
            TaskExecutorID other$Id = other.getId();
            if (this$Id == null ? other$Id != null : !this$Id.equals(other$Id)) {
                return false;
            }
            String this$generation = this.getGeneration();
            String other$generation = other.getGeneration();
            return !(this$generation == null ? other$generation != null : !this$generation.equals(other$generation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskExecutorID $Id = this.getId();
            result = result * 59 + ($Id == null ? 43 : $Id.hashCode());
            String $generation = this.getGeneration();
            result = result * 59 + ($generation == null ? 43 : $generation.hashCode());
            return result;
        }

        public String toString() {
            return "ExecutorStateManagerImpl.TaskExecutorHolder(Id=" + this.getId() + ", generation=" + this.getGeneration() + ")";
        }

        public static class TaskExecutorHolderBuilder {
            private TaskExecutorID Id;
            private String generation;

            TaskExecutorHolderBuilder() {
            }

            public TaskExecutorHolderBuilder Id(TaskExecutorID Id2) {
                this.Id = Id2;
                return this;
            }

            public TaskExecutorHolderBuilder generation(String generation) {
                this.generation = generation;
                return this;
            }

            public TaskExecutorHolder build() {
                return new TaskExecutorHolder(this.Id, this.generation);
            }

            public String toString() {
                return "ExecutorStateManagerImpl.TaskExecutorHolder.TaskExecutorHolderBuilder(Id=" + this.Id + ", generation=" + this.generation + ")";
            }
        }
    }

    class JobRequirements {
        private final Map<TaskExecutorRegistration.TaskExecutorGroupKey, Integer> groupToTaskExecutorCount;

        JobRequirements(Map<SchedulingConstraints, List<TaskExecutorAllocationRequest>> constraintsToTaskAllocationRequests) {
            this.groupToTaskExecutorCount = constraintsToTaskAllocationRequests.entrySet().stream().collect(Collectors.toMap(entry -> this.findBestFitGroupOrDefault((SchedulingConstraints)entry.getKey()), entry -> ((List)entry.getValue()).size(), Integer::sum));
        }

        public int getTotalWorkers() {
            return this.groupToTaskExecutorCount.values().stream().mapToInt(Integer::intValue).sum();
        }

        private TaskExecutorRegistration.TaskExecutorGroupKey findBestFitGroupOrDefault(SchedulingConstraints constraints) {
            Optional bestGroup = ExecutorStateManagerImpl.this.findBestGroup(constraints);
            if (!bestGroup.isPresent()) {
                log.warn("No fitting group found for provided constraints {}", (Object)constraints);
            }
            return bestGroup.orElse(new TaskExecutorRegistration.TaskExecutorGroupKey(constraints.getMachineDefinition(), constraints.getSizeName(), constraints.getSchedulingAttributes()));
        }

        public Map<TaskExecutorRegistration.TaskExecutorGroupKey, Integer> getGroupToTaskExecutorCount() {
            return this.groupToTaskExecutorCount;
        }

        public String toString() {
            return "ExecutorStateManagerImpl.JobRequirements(groupToTaskExecutorCount=" + this.getGroupToTaskExecutorCount() + ")";
        }
    }
}

