/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import akka.japi.pf.FI;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import io.mantisrx.common.metrics.spectator.MetricId;
import io.mantisrx.common.metrics.spectator.SpectatorRegistryFactory;
import io.mantisrx.master.resourcecluster.ResourceClusterActor;
import io.mantisrx.master.resourcecluster.proto.GetClusterIdleInstancesRequest;
import io.mantisrx.server.master.resourcecluster.TaskExecutorDisconnection;
import io.mantisrx.server.master.resourcecluster.TaskExecutorHeartbeat;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.shaded.com.google.common.collect.ImmutableMap;
import io.vavr.Tuple2;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceClusterActorMetrics {
    private static final Logger log = LoggerFactory.getLogger(ResourceClusterActorMetrics.class);
    private static final String METRIC_GROUP_ID = "ResourceClusterActor";
    public static final String NUM_REGISTERED_TE = "numRegisteredTaskExecutors";
    public static final String NUM_BUSY_TE = "numBusyTaskExecutors";
    public static final String NUM_AVAILABLE_TE = "numAvailableTaskExecutors";
    public static final String NUM_DISABLED_TE = "numDisabledTaskExecutors";
    public static final String NUM_UNREGISTERED_TE = "numUnregisteredTaskExecutors";
    public static final String NUM_ASSIGNED_TE = "numAssignedTaskExecutors";
    public static final String NO_RESOURCES_AVAILABLE = "noResourcesAvailable";
    public static final String HEARTBEAT_TIMEOUT = "taskExecutorHeartbeatTimeout";
    public static final String TE_CONNECTION_FAILURE = "taskExecutorConnectionFailure";
    public static final String RC_ACTOR_RESTART = "resourceClusterActorRestart";
    public static final String MAX_JOB_ARTIFACTS_TO_CACHE_REACHED = "maxJobArtifactsToCacheReached";
    private final Registry registry = SpectatorRegistryFactory.getRegistry();
    private final Map<Class<?>, Tuple2<Counter, Timer>> messageMetrics = ImmutableMap.of(TaskExecutorRegistration.class, this.getBoth("TaskExecutorRegistration"), ResourceClusterActor.InitializeTaskExecutorRequest.class, this.getBoth("InitializeTaskExecutorRequest"), TaskExecutorHeartbeat.class, this.getBoth("TaskExecutorHeartbeat"), TaskExecutorDisconnection.class, this.getBoth("TaskExecutorDisconnection"), ResourceClusterActor.HeartbeatTimeout.class, this.getBoth("HeartbeatTimeout"), ResourceClusterActor.TaskExecutorBatchAssignmentRequest.class, this.getBoth("TaskExecutorBatchAssignmentRequest"), ResourceClusterActor.TaskExecutorGatewayRequest.class, this.getBoth("TaskExecutorGatewayRequest"), ResourceClusterActor.CacheJobArtifactsOnTaskExecutorRequest.class, this.getBoth("CacheJobArtifactsOnTaskExecutorRequest"), ResourceClusterActor.GetClusterUsageRequest.class, this.getBoth("GetClusterUsageRequest"), GetClusterIdleInstancesRequest.class, this.getBoth("GetClusterIdleInstancesRequest"));
    private final Tuple2<Counter, Timer> unknownMessageMetrics = this.getBoth("UnknownMessage");

    private Id getMessageReceivedId(String messageName) {
        return new MetricId(METRIC_GROUP_ID, "messagesReceived", new Tag[]{Tag.of((String)"messageType", (String)messageName)}).getSpectatorId(this.registry);
    }

    private Id getMessageProcessingLatencyId(String messageName) {
        return new MetricId(METRIC_GROUP_ID, "messageProcessingLatency", new Tag[]{Tag.of((String)"messageType", (String)messageName)}).getSpectatorId(this.registry);
    }

    private Tuple2<Counter, Timer> getBoth(String messageName) {
        return new Tuple2((Object)this.registry.counter(this.getMessageReceivedId(messageName)), (Object)this.registry.timer(this.getMessageProcessingLatencyId(messageName)));
    }

    public void setGauge(String metric, long value, Iterable<Tag> tags) {
        this.registry.gauge(new MetricId(METRIC_GROUP_ID, metric, tags).getSpectatorId(this.registry)).set((double)value);
    }

    public void incrementCounter(String metric, Iterable<Tag> tags) {
        this.registry.counter(new MetricId(METRIC_GROUP_ID, metric, tags).getSpectatorId(this.registry)).increment();
    }

    public <P> FI.UnitApply<P> withTracking(FI.UnitApply<P> apply) {
        return p -> {
            long start = System.nanoTime();
            try {
                apply.apply(p);
            }
            finally {
                Class<?> pClass = p.getClass();
                this.messageMetrics.getOrDefault(pClass, this.unknownMessageMetrics).apply((counter, timer) -> {
                    counter.increment();
                    timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                    return null;
                });
            }
        };
    }
}

