/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.Props;
import akka.japi.pf.ReceiveBuilder;
import akka.pattern.Patterns;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.master.resourcecluster.proto.GetResourceClusterSpecRequest;
import io.mantisrx.master.resourcecluster.proto.ListResourceClusterRequest;
import io.mantisrx.master.resourcecluster.proto.MantisResourceClusterSpec;
import io.mantisrx.master.resourcecluster.proto.ProvisionResourceClusterRequest;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterAPIProto;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterProvisionSubmissionResponse;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterScaleRuleProto;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterScaleSpec;
import io.mantisrx.master.resourcecluster.proto.ScaleResourceRequest;
import io.mantisrx.master.resourcecluster.proto.UpgradeClusterContainersRequest;
import io.mantisrx.master.resourcecluster.proto.UpgradeClusterContainersResponse;
import io.mantisrx.master.resourcecluster.resourceprovider.ResourceClusterProvider;
import io.mantisrx.master.resourcecluster.resourceprovider.ResourceClusterProviderUpgradeRequest;
import io.mantisrx.master.resourcecluster.writable.RegisteredResourceClustersWritable;
import io.mantisrx.master.resourcecluster.writable.ResourceClusterScaleRulesWritable;
import io.mantisrx.master.resourcecluster.writable.ResourceClusterSpecWritable;
import io.mantisrx.server.master.persistence.IMantisPersistenceProvider;
import io.mantisrx.shaded.com.google.common.base.Strings;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;

public class ResourceClustersHostManagerActor
extends AbstractActorWithTimers {
    private static final Logger log = LoggerFactory.getLogger(ResourceClustersHostManagerActor.class);
    private final ResourceClusterProvider resourceClusterProvider;
    private final IMantisPersistenceProvider resourceClusterStorageProvider;

    public static Props props(ResourceClusterProvider resourceClusterProvider, IMantisPersistenceProvider persistenceProvider) {
        return Props.create(ResourceClustersHostManagerActor.class, (Object[])new Object[]{resourceClusterProvider, persistenceProvider});
    }

    public ResourceClustersHostManagerActor(ResourceClusterProvider resourceClusterProvider, IMantisPersistenceProvider resourceStorageProvider) {
        this.resourceClusterProvider = resourceClusterProvider;
        this.resourceClusterStorageProvider = resourceStorageProvider;
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(ProvisionResourceClusterRequest.class, this::onProvisionResourceClusterRequest).match(ListResourceClusterRequest.class, this::onListResourceClusterRequest).match(GetResourceClusterSpecRequest.class, this::onGetResourceClusterSpecRequest).match(ResourceClusterAPIProto.DeleteResourceClusterRequest.class, this::onDeleteResourceCluster).match(ResourceClusterScaleRuleProto.CreateAllResourceClusterScaleRulesRequest.class, this::onCreateAllResourceClusterScaleRulesRequest).match(ResourceClusterScaleRuleProto.CreateResourceClusterScaleRuleRequest.class, this::onCreateResourceClusterScaleRuleRequest).match(ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesRequest.class, this::onGetResourceClusterScaleRulesRequest).match(ResourceClusterProvisionSubmissionResponse.class, this::onResourceClusterProvisionResponse).match(ScaleResourceRequest.class, this::onScaleResourceClusterRequest).match(UpgradeClusterContainersRequest.class, this::onUpgradeClusterContainersRequest).match(UpgradeClusterContainersResponse.class, this::onUpgradeClusterContainersResponse).build();
    }

    private void onCreateResourceClusterScaleRuleRequest(ResourceClusterScaleRuleProto.CreateResourceClusterScaleRuleRequest req) {
        try {
            ResourceClusterScaleSpec ruleSpec = ResourceClusterScaleSpec.builder().maxSize(req.getRule().getMaxSize()).minSize(req.getRule().getMinSize()).minIdleToKeep(req.getRule().getMinIdleToKeep()).maxIdleToKeep(req.getRule().getMaxIdleToKeep()).coolDownSecs(req.getRule().getCoolDownSecs()).skuId(req.getRule().getSkuId()).clusterId(req.getRule().getClusterId()).build();
            this.getSender().tell((Object)ResourceClustersHostManagerActor.toGetResourceClusterScaleRulesResponse(this.resourceClusterStorageProvider.registerResourceClusterScaleRule(ruleSpec)), this.getSelf());
        }
        catch (Exception err) {
            log.error("Error from registerResourceClusterScaleRule: {}", (Object)req, (Object)err);
            ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse response = ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse.builder().message(err.getMessage()).responseCode(BaseResponse.ResponseCode.SERVER_ERROR).build();
            this.getSender().tell((Object)response, this.getSelf());
        }
    }

    private void onGetResourceClusterScaleRulesRequest(ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesRequest req) {
        try {
            ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse response = ResourceClustersHostManagerActor.toGetResourceClusterScaleRulesResponse(this.resourceClusterStorageProvider.getResourceClusterScaleRules(req.getClusterId()));
            this.getSender().tell((Object)response, this.getSelf());
        }
        catch (IOException e) {
            log.error("Error from getResourceClusterScaleRules: {}", (Object)req, (Object)e);
            ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse errorResponse = ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse.builder().message(e.getMessage()).responseCode(BaseResponse.ResponseCode.SERVER_ERROR).build();
            this.getSender().tell((Object)errorResponse, this.getSelf());
        }
    }

    private void onCreateAllResourceClusterScaleRulesRequest(ResourceClusterScaleRuleProto.CreateAllResourceClusterScaleRulesRequest req) {
        ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse response;
        ResourceClusterScaleRulesWritable.ResourceClusterScaleRulesWritableBuilder rulesBuilder = ResourceClusterScaleRulesWritable.builder().clusterId(req.getClusterId());
        req.getRules().forEach(r -> rulesBuilder.scaleRule(r.getSkuId().getResourceID(), ResourceClusterScaleSpec.builder().maxSize(r.getMaxSize()).minSize(r.getMinSize()).minIdleToKeep(r.getMinIdleToKeep()).maxIdleToKeep(r.getMaxIdleToKeep()).coolDownSecs(r.getCoolDownSecs()).skuId(r.getSkuId()).clusterId(r.getClusterId()).build()));
        try {
            response = ResourceClustersHostManagerActor.toGetResourceClusterScaleRulesResponse(this.resourceClusterStorageProvider.registerResourceClusterScaleRule(rulesBuilder.build()));
        }
        catch (IOException e) {
            log.error("Error from registerResourceClusterScaleRule: {}", (Object)req, (Object)e);
            response = ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse.builder().message(e.getMessage()).responseCode(BaseResponse.ResponseCode.SERVER_ERROR).build();
        }
        this.sender().tell((Object)response, this.self());
    }

    private static ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse toGetResourceClusterScaleRulesResponse(ResourceClusterScaleRulesWritable rules) {
        return ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse.builder().responseCode(BaseResponse.ResponseCode.SUCCESS).clusterId(rules.getClusterId()).rules(rules.getScaleRules().entrySet().stream().map(kv -> ResourceClusterScaleRuleProto.ResourceClusterScaleRule.builder().clusterId(((ResourceClusterScaleSpec)kv.getValue()).getClusterId()).coolDownSecs(((ResourceClusterScaleSpec)kv.getValue()).getCoolDownSecs()).maxIdleToKeep(((ResourceClusterScaleSpec)kv.getValue()).getMaxIdleToKeep()).minIdleToKeep(((ResourceClusterScaleSpec)kv.getValue()).getMinIdleToKeep()).maxSize(((ResourceClusterScaleSpec)kv.getValue()).getMaxSize()).minSize(((ResourceClusterScaleSpec)kv.getValue()).getMinSize()).skuId(((ResourceClusterScaleSpec)kv.getValue()).getSkuId()).build()).collect(Collectors.toList())).build();
    }

    private void onResourceClusterProvisionResponse(ResourceClusterProvisionSubmissionResponse resp) {
        this.resourceClusterProvider.getResponseHandler().handleProvisionResponse(resp);
    }

    private void onUpgradeClusterContainersResponse(UpgradeClusterContainersResponse resp) {
        if (resp.responseCode.getValue() >= 300) {
            log.error("Unexpected error response from upgradeClusterContainers: {}", (Object)resp);
        } else {
            log.info("Success response from upgradeClusterContainers request: {}", (Object)resp);
        }
    }

    private void onDeleteResourceCluster(ResourceClusterAPIProto.DeleteResourceClusterRequest req) {
        try {
            this.resourceClusterStorageProvider.deregisterCluster(req.getClusterId());
            ResourceClusterAPIProto.DeleteResourceClusterResponse response = ResourceClusterAPIProto.DeleteResourceClusterResponse.builder().responseCode(BaseResponse.ResponseCode.SUCCESS).build();
            this.getSender().tell((Object)response, this.getSelf());
        }
        catch (IOException err) {
            ResourceClusterAPIProto.DeleteResourceClusterResponse response = ResourceClusterAPIProto.DeleteResourceClusterResponse.builder().message(err.getMessage()).responseCode(BaseResponse.ResponseCode.SERVER_ERROR).build();
            this.getSender().tell((Object)response, this.getSelf());
        }
    }

    private void onListResourceClusterRequest(ListResourceClusterRequest req) {
        try {
            RegisteredResourceClustersWritable clustersW = this.resourceClusterStorageProvider.getRegisteredResourceClustersWritable();
            ResourceClusterAPIProto.ListResourceClustersResponse response = ResourceClusterAPIProto.ListResourceClustersResponse.builder().responseCode(BaseResponse.ResponseCode.SUCCESS).registeredResourceClusters(clustersW.getClusters().entrySet().stream().map(kv -> ResourceClusterAPIProto.ListResourceClustersResponse.RegisteredResourceCluster.builder().id(((RegisteredResourceClustersWritable.ClusterRegistration)kv.getValue()).getClusterId()).version(((RegisteredResourceClustersWritable.ClusterRegistration)kv.getValue()).getVersion()).build()).collect(Collectors.toList())).build();
            this.getSender().tell((Object)response, this.getSelf());
        }
        catch (IOException err) {
            ResourceClusterAPIProto.ListResourceClustersResponse response = ResourceClusterAPIProto.ListResourceClustersResponse.builder().message(err.getMessage()).responseCode(BaseResponse.ResponseCode.SERVER_ERROR).build();
            this.getSender().tell((Object)response, this.getSelf());
        }
    }

    private void onGetResourceClusterSpecRequest(GetResourceClusterSpecRequest req) {
        try {
            ResourceClusterSpecWritable specW = this.resourceClusterStorageProvider.getResourceClusterSpecWritable(req.getId());
            ResourceClusterAPIProto.GetResourceClusterResponse response = specW == null ? ResourceClusterAPIProto.GetResourceClusterResponse.builder().responseCode(BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND).build() : ResourceClusterAPIProto.GetResourceClusterResponse.builder().responseCode(BaseResponse.ResponseCode.SUCCESS).clusterSpec(specW.getClusterSpec()).build();
            this.getSender().tell((Object)response, this.getSelf());
        }
        catch (IOException err) {
            ResourceClusterAPIProto.GetResourceClusterResponse response = ResourceClusterAPIProto.GetResourceClusterResponse.builder().responseCode(BaseResponse.ResponseCode.SERVER_ERROR).message(err.getMessage()).build();
            this.getSender().tell((Object)response, this.getSelf());
        }
    }

    private void onProvisionResourceClusterRequest(ProvisionResourceClusterRequest req) {
        ResourceClusterAPIProto.GetResourceClusterResponse response;
        log.info("Entering onProvisionResourceClusterRequest: " + req);
        Optional<String> validationResultO = ResourceClustersHostManagerActor.validateClusterSpec(req);
        if (validationResultO.isPresent()) {
            Patterns.pipe(CompletableFuture.completedFuture(ResourceClusterAPIProto.GetResourceClusterResponse.builder().responseCode(BaseResponse.ResponseCode.CLIENT_ERROR).message(validationResultO.get()).build()), (ExecutionContext)this.getContext().dispatcher()).to(this.getSender());
            log.info("Invalid cluster spec, return client error. Req: {}", (Object)req.getClusterId());
            log.debug("Full invalid Req: {}", (Object)req);
            return;
        }
        ResourceClusterSpecWritable specWritable = ResourceClusterSpecWritable.builder().clusterSpec(req.getClusterSpec()).version("").id(req.getClusterId()).build();
        try {
            ResourceClusterSpecWritable specW = this.resourceClusterStorageProvider.registerAndUpdateClusterSpec(specWritable);
            response = ResourceClusterAPIProto.GetResourceClusterResponse.builder().responseCode(BaseResponse.ResponseCode.SUCCESS).clusterSpec(specW.getClusterSpec()).build();
        }
        catch (IOException err2) {
            response = ResourceClusterAPIProto.GetResourceClusterResponse.builder().responseCode(BaseResponse.ResponseCode.SERVER_ERROR).message(err2.getMessage()).build();
        }
        this.getSender().tell((Object)response, this.getSelf());
        if (response.responseCode.equals((Object)BaseResponse.ResponseCode.SUCCESS)) {
            CompletionStage<ResourceClusterProvisionSubmissionResponse> provisionFut = this.resourceClusterProvider.provisionClusterIfNotPresent(req).exceptionally(err -> ResourceClusterProvisionSubmissionResponse.builder().error((Throwable)err).build());
            Patterns.pipe(provisionFut, (ExecutionContext)this.getContext().getDispatcher()).to(this.getSelf());
        }
    }

    private void onScaleResourceClusterRequest(ScaleResourceRequest req) {
        log.info("Entering onScaleResourceClusterRequest: " + req);
        Patterns.pipe(this.resourceClusterProvider.scaleResource(req), (ExecutionContext)this.getContext().dispatcher()).to(this.getSender());
    }

    private void onUpgradeClusterContainersRequest(UpgradeClusterContainersRequest req) {
        CompletionStage<UpgradeClusterContainersResponse> upgradeFut;
        block5: {
            log.info("Entering onUpgradeClusterContainersRequest: {}", (Object)req);
            if (req.isEnableSkuSpecUpgrade()) {
                try {
                    ResourceClusterSpecWritable specW = this.resourceClusterStorageProvider.getResourceClusterSpecWritable(req.getClusterId());
                    if (specW == null) {
                        upgradeFut = CompletableFuture.completedFuture(UpgradeClusterContainersResponse.builder().responseCode(BaseResponse.ResponseCode.CLIENT_ERROR_NOT_FOUND).build());
                        break block5;
                    }
                    ResourceClusterProviderUpgradeRequest enrichedReq = ResourceClusterProviderUpgradeRequest.from(req, specW.getClusterSpec());
                    upgradeFut = this.resourceClusterProvider.upgradeContainerResource(enrichedReq);
                }
                catch (IOException err) {
                    upgradeFut = CompletableFuture.completedFuture(UpgradeClusterContainersResponse.builder().responseCode(BaseResponse.ResponseCode.SERVER_ERROR).message(err.getMessage()).build());
                }
            } else {
                log.info("Upgrading cluster image only: {}", (Object)req.getClusterId());
                upgradeFut = this.resourceClusterProvider.upgradeContainerResource(ResourceClusterProviderUpgradeRequest.from(req));
            }
        }
        Patterns.pipe(upgradeFut, (ExecutionContext)this.getContext().getDispatcher()).to(this.getSelf());
        this.getSender().tell((Object)UpgradeClusterContainersResponse.builder().responseCode(BaseResponse.ResponseCode.SUCCESS).message("Upgrade request submitted").clusterId(req.getClusterId()).optionalSkuId(req.getOptionalSkuId()).optionalEnvType(req.getOptionalEnvType()).region(req.getRegion()).build(), this.getSelf());
    }

    private static Optional<String> validateClusterSpec(ProvisionResourceClusterRequest req) {
        if (req.getClusterSpec() == null) {
            log.error("Empty request without cluster spec: {}", (Object)req.getClusterId());
            return Optional.of("cluster spec cannot be null");
        }
        if (!req.getClusterId().equals((Object)req.getClusterSpec().getId())) {
            log.error("Mismatch cluster id: {}, {}", (Object)req.getClusterId(), (Object)req.getClusterSpec().getId());
            return Optional.of("cluster spec id doesn't match cluster id");
        }
        Optional<MantisResourceClusterSpec.SkuTypeSpec> invalidSku = req.getClusterSpec().getSkuSpecs().stream().filter(sku -> sku.getSkuId() == null || sku.getCapacity() == null || sku.getCpuCoreCount() < 1 || sku.getDiskSizeInMB() < 1 || sku.getMemorySizeInMB() < 1 || sku.getNetworkMbps() < 1 || Strings.isNullOrEmpty((String)sku.getImageId())).findAny();
        if (invalidSku.isPresent()) {
            log.error("Invalid request for cluster spec: {}, {}", (Object)req.getClusterId(), (Object)invalidSku.get());
            return Optional.of("Invalid sku definition");
        }
        Optional<MantisResourceClusterSpec.SkuTypeSpec> invalidSkuNameSpec = req.getClusterSpec().getSkuSpecs().stream().filter(sku -> Character.isDigit(sku.getSkuId().getResourceID().charAt(sku.getSkuId().getResourceID().length() - 1))).findAny();
        if (invalidSkuNameSpec.isPresent()) {
            log.error("Invalid request for cluster spec sku id (cannot end with number): {}, {}", (Object)req.getClusterId(), (Object)invalidSkuNameSpec.get());
            return Optional.of("Invalid skuID (cannot end with number): " + invalidSkuNameSpec.get().getSkuId());
        }
        return Optional.empty();
    }
}

