/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster;

import io.mantisrx.master.resourcecluster.ResourceClusterActor;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.resourcecluster.TaskExecutorHeartbeat;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.server.master.resourcecluster.TaskExecutorReport;
import io.mantisrx.server.master.resourcecluster.TaskExecutorStatusChange;
import io.mantisrx.server.master.scheduler.JobMessageRouter;
import io.mantisrx.server.master.scheduler.WorkerOnDisabledVM;
import io.mantisrx.server.worker.TaskExecutorGateway;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rpc.RpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskExecutorState {
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorState.class);
    private RegistrationState state;
    @Nullable
    private TaskExecutorRegistration registration;
    @Nullable
    private ResourceClusterActor.AvailabilityState availabilityState;
    private boolean disabled;
    private Instant lastActivity;
    private final Clock clock;
    private final RpcService rpcService;
    private final JobMessageRouter jobMessageRouter;

    static TaskExecutorState of(Clock clock, RpcService rpcService, JobMessageRouter jobMessageRouter) {
        return new TaskExecutorState(RegistrationState.Unregistered, null, null, false, clock.instant(), clock, rpcService, jobMessageRouter);
    }

    boolean isRegistered() {
        return this.state == RegistrationState.Registered;
    }

    boolean isDisconnected() {
        return !this.isRegistered();
    }

    boolean isDisabled() {
        return this.disabled;
    }

    boolean onRegistration(TaskExecutorRegistration registration) {
        if (this.state == RegistrationState.Registered) {
            return false;
        }
        this.state = RegistrationState.Registered;
        this.registration = registration;
        this.updateTicker();
        return true;
    }

    boolean onDisconnection() {
        if (this.state == RegistrationState.Unregistered) {
            return false;
        }
        this.state = RegistrationState.Unregistered;
        this.registration = null;
        this.setAvailabilityState(null);
        this.updateTicker();
        return true;
    }

    private static ResourceClusterActor.AvailabilityState from(TaskExecutorReport report) {
        if (report instanceof TaskExecutorReport.Available) {
            return ResourceClusterActor.AvailabilityState.pending();
        }
        if (report instanceof TaskExecutorReport.Occupied) {
            return ResourceClusterActor.AvailabilityState.running(((TaskExecutorReport.Occupied)report).getWorkerId());
        }
        throw new RuntimeException(String.format("TaskExecutorReport=%s was unexpected", report));
    }

    boolean onAssignment(WorkerId workerId) throws IllegalStateException {
        if (!this.isRegistered()) {
            this.throwNotRegistered(String.format("assignment to %s", workerId));
        }
        if (this.availabilityState == null) {
            throw new IllegalStateException("availability state was null when unassignmentas was issued");
        }
        return this.setAvailabilityState(this.availabilityState.onAssignment(workerId));
    }

    boolean onUnassignment() throws IllegalStateException {
        if (this.availabilityState == null) {
            throw new IllegalStateException("availability state was null when unassignment was issued");
        }
        return this.setAvailabilityState(this.availabilityState.onUnassignment());
    }

    boolean onNodeDisabled() {
        if (!this.disabled) {
            this.disabled = true;
            if (this.availabilityState instanceof ResourceClusterActor.Running) {
                this.jobMessageRouter.routeWorkerEvent(new WorkerOnDisabledVM(this.availabilityState.getWorkerId()));
            }
            return true;
        }
        return false;
    }

    boolean onHeartbeat(TaskExecutorHeartbeat heartbeat) throws IllegalStateException {
        if (!this.isRegistered()) {
            this.throwNotRegistered(String.format("heartbeat %s", heartbeat));
        }
        boolean result = this.handleStatusChange(heartbeat.getTaskExecutorReport());
        this.updateTicker();
        return result;
    }

    boolean onTaskExecutorStatusChange(TaskExecutorStatusChange statusChange) {
        if (!this.isRegistered()) {
            this.throwNotRegistered(String.format("status change %s", statusChange));
        }
        boolean result = this.handleStatusChange(statusChange.getTaskExecutorReport());
        this.updateTicker();
        return result;
    }

    private boolean handleStatusChange(TaskExecutorReport report) throws IllegalStateException {
        if (this.availabilityState == null) {
            return this.setAvailabilityState(TaskExecutorState.from(report));
        }
        return this.setAvailabilityState(this.availabilityState.onTaskExecutorStatusChange(report));
    }

    private boolean setAvailabilityState(ResourceClusterActor.AvailabilityState newState) {
        if (this.availabilityState != newState) {
            this.availabilityState = newState;
            if (this.availabilityState instanceof ResourceClusterActor.Running && this.isDisabled()) {
                this.jobMessageRouter.routeWorkerEvent(new WorkerOnDisabledVM(newState.getWorkerId()));
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected WorkerId getWorkerId() {
        if (this.availabilityState != null) {
            return this.availabilityState.getWorkerId();
        }
        return null;
    }

    private void throwNotRegistered(String message) throws IllegalStateException {
        throw new IllegalStateException(String.format("Task Executor un-registered when it received %s", message));
    }

    private void updateTicker() {
        this.lastActivity = this.clock.instant();
    }

    boolean isAvailable() {
        return this.availabilityState instanceof ResourceClusterActor.Pending && !this.isDisabled();
    }

    boolean isRunningTask() {
        return this.availabilityState instanceof ResourceClusterActor.Running;
    }

    boolean isAssigned() {
        return this.availabilityState instanceof ResourceClusterActor.Assigned;
    }

    boolean isRunningOrAssigned(WorkerId workerId) {
        return this.getWorkerId() != null && this.getWorkerId().equals((Object)workerId);
    }

    Instant getLastActivity() {
        return this.lastActivity;
    }

    TaskExecutorRegistration getRegistration() {
        return this.registration;
    }

    protected CompletableFuture<TaskExecutorGateway> getGatewayAsync() {
        if (this.registration == null || this.state == RegistrationState.Unregistered) {
            throw new IllegalStateException("TE is unregistered");
        }
        return this.rpcService.connect(this.registration.getTaskExecutorAddress(), TaskExecutorGateway.class).whenComplete((gateway, throwable) -> {
            if (throwable != null) {
                log.error("Failed to connect to the gateway", throwable);
            }
        });
    }

    boolean containsAttributes(Map<String, String> attributes) {
        return this.registration != null && this.registration.containsAttributes(attributes);
    }

    @ConstructorProperties(value={"state", "registration", "availabilityState", "disabled", "lastActivity", "clock", "rpcService", "jobMessageRouter"})
    public TaskExecutorState(RegistrationState state, @Nullable TaskExecutorRegistration registration, @Nullable ResourceClusterActor.AvailabilityState availabilityState, boolean disabled, Instant lastActivity, Clock clock, RpcService rpcService, JobMessageRouter jobMessageRouter) {
        this.state = state;
        this.registration = registration;
        this.availabilityState = availabilityState;
        this.disabled = disabled;
        this.lastActivity = lastActivity;
        this.clock = clock;
        this.rpcService = rpcService;
        this.jobMessageRouter = jobMessageRouter;
    }

    static enum RegistrationState {
        Registered,
        Unregistered;

    }
}

