/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.proto;

import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GetClusterIdleInstancesResponse {
    private final ClusterID clusterId;
    private final ContainerSkuID skuId;
    private final List<TaskExecutorID> instanceIds;
    private final int desireSize;

    @ConstructorProperties(value={"clusterId", "skuId", "instanceIds", "desireSize"})
    GetClusterIdleInstancesResponse(ClusterID clusterId, ContainerSkuID skuId, List<TaskExecutorID> instanceIds, int desireSize) {
        this.clusterId = clusterId;
        this.skuId = skuId;
        this.instanceIds = instanceIds;
        this.desireSize = desireSize;
    }

    public static GetClusterIdleInstancesResponseBuilder builder() {
        return new GetClusterIdleInstancesResponseBuilder();
    }

    public ClusterID getClusterId() {
        return this.clusterId;
    }

    public ContainerSkuID getSkuId() {
        return this.skuId;
    }

    public List<TaskExecutorID> getInstanceIds() {
        return this.instanceIds;
    }

    public int getDesireSize() {
        return this.desireSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetClusterIdleInstancesResponse)) {
            return false;
        }
        GetClusterIdleInstancesResponse other = (GetClusterIdleInstancesResponse)o;
        if (this.getDesireSize() != other.getDesireSize()) {
            return false;
        }
        ClusterID this$clusterId = this.getClusterId();
        ClusterID other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        ContainerSkuID this$skuId = this.getSkuId();
        ContainerSkuID other$skuId = other.getSkuId();
        if (this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId)) {
            return false;
        }
        List<TaskExecutorID> this$instanceIds = this.getInstanceIds();
        List<TaskExecutorID> other$instanceIds = other.getInstanceIds();
        return !(this$instanceIds == null ? other$instanceIds != null : !((Object)this$instanceIds).equals(other$instanceIds));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDesireSize();
        ClusterID $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        ContainerSkuID $skuId = this.getSkuId();
        result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
        List<TaskExecutorID> $instanceIds = this.getInstanceIds();
        result = result * 59 + ($instanceIds == null ? 43 : ((Object)$instanceIds).hashCode());
        return result;
    }

    public String toString() {
        return "GetClusterIdleInstancesResponse(clusterId=" + this.getClusterId() + ", skuId=" + this.getSkuId() + ", instanceIds=" + this.getInstanceIds() + ", desireSize=" + this.getDesireSize() + ")";
    }

    public static class GetClusterIdleInstancesResponseBuilder {
        private ClusterID clusterId;
        private ContainerSkuID skuId;
        private ArrayList<TaskExecutorID> instanceIds;
        private int desireSize;

        GetClusterIdleInstancesResponseBuilder() {
        }

        public GetClusterIdleInstancesResponseBuilder clusterId(ClusterID clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public GetClusterIdleInstancesResponseBuilder skuId(ContainerSkuID skuId) {
            this.skuId = skuId;
            return this;
        }

        public GetClusterIdleInstancesResponseBuilder instanceId(TaskExecutorID instanceId) {
            if (this.instanceIds == null) {
                this.instanceIds = new ArrayList();
            }
            this.instanceIds.add(instanceId);
            return this;
        }

        public GetClusterIdleInstancesResponseBuilder instanceIds(Collection<? extends TaskExecutorID> instanceIds) {
            if (instanceIds == null) {
                throw new NullPointerException("instanceIds cannot be null");
            }
            if (this.instanceIds == null) {
                this.instanceIds = new ArrayList();
            }
            this.instanceIds.addAll(instanceIds);
            return this;
        }

        public GetClusterIdleInstancesResponseBuilder clearInstanceIds() {
            if (this.instanceIds != null) {
                this.instanceIds.clear();
            }
            return this;
        }

        public GetClusterIdleInstancesResponseBuilder desireSize(int desireSize) {
            this.desireSize = desireSize;
            return this;
        }

        public GetClusterIdleInstancesResponse build() {
            List<TaskExecutorID> instanceIds;
            switch (this.instanceIds == null ? 0 : this.instanceIds.size()) {
                case 0: {
                    instanceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    instanceIds = Collections.singletonList(this.instanceIds.get(0));
                    break;
                }
                default: {
                    instanceIds = Collections.unmodifiableList(new ArrayList<TaskExecutorID>(this.instanceIds));
                }
            }
            return new GetClusterIdleInstancesResponse(this.clusterId, this.skuId, instanceIds, this.desireSize);
        }

        public String toString() {
            return "GetClusterIdleInstancesResponse.GetClusterIdleInstancesResponseBuilder(clusterId=" + this.clusterId + ", skuId=" + this.skuId + ", instanceIds=" + this.instanceIds + ", desireSize=" + this.desireSize + ")";
        }
    }
}

