/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.proto;

import com.netflix.spectator.impl.Preconditions;
import io.mantisrx.master.jobcluster.proto.BaseRequest;
import io.mantisrx.master.jobcluster.proto.BaseResponse;
import io.mantisrx.server.core.domain.ArtifactID;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.ContainerSkuID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class ResourceClusterScaleRuleProto {

    public static final class JobArtifactsToCacheRequest
    extends BaseRequest {
        private final ClusterID clusterID;
        @NonNull
        private final List<ArtifactID> artifacts;

        public JobArtifactsToCacheRequest(@JsonProperty(value="clusterID") ClusterID clusterID, @JsonProperty(value="artifacts") List<ArtifactID> artifacts) {
            Preconditions.checkNotNull((Object)clusterID, (String)"clusterID cannot be null");
            Preconditions.checkNotNull(artifacts, (String)"artifacts cannot be null");
            this.clusterID = clusterID;
            this.artifacts = artifacts;
        }

        public ClusterID getClusterID() {
            return this.clusterID;
        }

        @NonNull
        public List<ArtifactID> getArtifacts() {
            return this.artifacts;
        }

        public String toString() {
            return "ResourceClusterScaleRuleProto.JobArtifactsToCacheRequest(clusterID=" + this.getClusterID() + ", artifacts=" + this.getArtifacts() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobArtifactsToCacheRequest)) {
                return false;
            }
            JobArtifactsToCacheRequest other = (JobArtifactsToCacheRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClusterID this$clusterID = this.getClusterID();
            ClusterID other$clusterID = other.getClusterID();
            if (this$clusterID == null ? other$clusterID != null : !this$clusterID.equals(other$clusterID)) {
                return false;
            }
            List<ArtifactID> this$artifacts = this.getArtifacts();
            List<ArtifactID> other$artifacts = other.getArtifacts();
            return !(this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobArtifactsToCacheRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ClusterID $clusterID = this.getClusterID();
            result = result * 59 + ($clusterID == null ? 43 : $clusterID.hashCode());
            List<ArtifactID> $artifacts = this.getArtifacts();
            result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
            return result;
        }
    }

    public static final class ResourceClusterScaleRule {
        private final ClusterID clusterId;
        private final ContainerSkuID skuId;
        private final int minIdleToKeep;
        private final int minSize;
        private final int maxIdleToKeep;
        private final int maxSize;
        private final long coolDownSecs;

        @ConstructorProperties(value={"clusterId", "skuId", "minIdleToKeep", "minSize", "maxIdleToKeep", "maxSize", "coolDownSecs"})
        ResourceClusterScaleRule(ClusterID clusterId, ContainerSkuID skuId, int minIdleToKeep, int minSize, int maxIdleToKeep, int maxSize, long coolDownSecs) {
            this.clusterId = clusterId;
            this.skuId = skuId;
            this.minIdleToKeep = minIdleToKeep;
            this.minSize = minSize;
            this.maxIdleToKeep = maxIdleToKeep;
            this.maxSize = maxSize;
            this.coolDownSecs = coolDownSecs;
        }

        public static ResourceClusterScaleRuleBuilder builder() {
            return new ResourceClusterScaleRuleBuilder();
        }

        public ClusterID getClusterId() {
            return this.clusterId;
        }

        public ContainerSkuID getSkuId() {
            return this.skuId;
        }

        public int getMinIdleToKeep() {
            return this.minIdleToKeep;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getMaxIdleToKeep() {
            return this.maxIdleToKeep;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public long getCoolDownSecs() {
            return this.coolDownSecs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceClusterScaleRule)) {
                return false;
            }
            ResourceClusterScaleRule other = (ResourceClusterScaleRule)o;
            if (this.getMinIdleToKeep() != other.getMinIdleToKeep()) {
                return false;
            }
            if (this.getMinSize() != other.getMinSize()) {
                return false;
            }
            if (this.getMaxIdleToKeep() != other.getMaxIdleToKeep()) {
                return false;
            }
            if (this.getMaxSize() != other.getMaxSize()) {
                return false;
            }
            if (this.getCoolDownSecs() != other.getCoolDownSecs()) {
                return false;
            }
            ClusterID this$clusterId = this.getClusterId();
            ClusterID other$clusterId = other.getClusterId();
            if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
                return false;
            }
            ContainerSkuID this$skuId = this.getSkuId();
            ContainerSkuID other$skuId = other.getSkuId();
            return !(this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinIdleToKeep();
            result = result * 59 + this.getMinSize();
            result = result * 59 + this.getMaxIdleToKeep();
            result = result * 59 + this.getMaxSize();
            long $coolDownSecs = this.getCoolDownSecs();
            result = result * 59 + (int)($coolDownSecs >>> 32 ^ $coolDownSecs);
            ClusterID $clusterId = this.getClusterId();
            result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
            ContainerSkuID $skuId = this.getSkuId();
            result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScaleRuleProto.ResourceClusterScaleRule(clusterId=" + this.getClusterId() + ", skuId=" + this.getSkuId() + ", minIdleToKeep=" + this.getMinIdleToKeep() + ", minSize=" + this.getMinSize() + ", maxIdleToKeep=" + this.getMaxIdleToKeep() + ", maxSize=" + this.getMaxSize() + ", coolDownSecs=" + this.getCoolDownSecs() + ")";
        }

        public static class ResourceClusterScaleRuleBuilder {
            private ClusterID clusterId;
            private ContainerSkuID skuId;
            private int minIdleToKeep;
            private int minSize;
            private int maxIdleToKeep;
            private int maxSize;
            private long coolDownSecs;

            ResourceClusterScaleRuleBuilder() {
            }

            public ResourceClusterScaleRuleBuilder clusterId(ClusterID clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public ResourceClusterScaleRuleBuilder skuId(ContainerSkuID skuId) {
                this.skuId = skuId;
                return this;
            }

            public ResourceClusterScaleRuleBuilder minIdleToKeep(int minIdleToKeep) {
                this.minIdleToKeep = minIdleToKeep;
                return this;
            }

            public ResourceClusterScaleRuleBuilder minSize(int minSize) {
                this.minSize = minSize;
                return this;
            }

            public ResourceClusterScaleRuleBuilder maxIdleToKeep(int maxIdleToKeep) {
                this.maxIdleToKeep = maxIdleToKeep;
                return this;
            }

            public ResourceClusterScaleRuleBuilder maxSize(int maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            public ResourceClusterScaleRuleBuilder coolDownSecs(long coolDownSecs) {
                this.coolDownSecs = coolDownSecs;
                return this;
            }

            public ResourceClusterScaleRule build() {
                return new ResourceClusterScaleRule(this.clusterId, this.skuId, this.minIdleToKeep, this.minSize, this.maxIdleToKeep, this.maxSize, this.coolDownSecs);
            }

            public String toString() {
                return "ResourceClusterScaleRuleProto.ResourceClusterScaleRule.ResourceClusterScaleRuleBuilder(clusterId=" + this.clusterId + ", skuId=" + this.skuId + ", minIdleToKeep=" + this.minIdleToKeep + ", minSize=" + this.minSize + ", maxIdleToKeep=" + this.maxIdleToKeep + ", maxSize=" + this.maxSize + ", coolDownSecs=" + this.coolDownSecs + ")";
            }
        }
    }

    public static final class CreateAllResourceClusterScaleRulesRequest {
        private final ClusterID clusterId;
        @NonNull
        private final List<ResourceClusterScaleRule> rules;

        @ConstructorProperties(value={"clusterId", "rules"})
        CreateAllResourceClusterScaleRulesRequest(ClusterID clusterId, @NonNull List<ResourceClusterScaleRule> rules) {
            if (rules == null) {
                throw new NullPointerException("rules is marked non-null but is null");
            }
            this.clusterId = clusterId;
            this.rules = rules;
        }

        public static CreateAllResourceClusterScaleRulesRequestBuilder builder() {
            return new CreateAllResourceClusterScaleRulesRequestBuilder();
        }

        public ClusterID getClusterId() {
            return this.clusterId;
        }

        @NonNull
        public List<ResourceClusterScaleRule> getRules() {
            return this.rules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateAllResourceClusterScaleRulesRequest)) {
                return false;
            }
            CreateAllResourceClusterScaleRulesRequest other = (CreateAllResourceClusterScaleRulesRequest)o;
            ClusterID this$clusterId = this.getClusterId();
            ClusterID other$clusterId = other.getClusterId();
            if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
                return false;
            }
            List<ResourceClusterScaleRule> this$rules = this.getRules();
            List<ResourceClusterScaleRule> other$rules = other.getRules();
            return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterId = this.getClusterId();
            result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
            List<ResourceClusterScaleRule> $rules = this.getRules();
            result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScaleRuleProto.CreateAllResourceClusterScaleRulesRequest(clusterId=" + this.getClusterId() + ", rules=" + this.getRules() + ")";
        }

        public static class CreateAllResourceClusterScaleRulesRequestBuilder {
            private ClusterID clusterId;
            private ArrayList<ResourceClusterScaleRule> rules;

            CreateAllResourceClusterScaleRulesRequestBuilder() {
            }

            public CreateAllResourceClusterScaleRulesRequestBuilder clusterId(ClusterID clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public CreateAllResourceClusterScaleRulesRequestBuilder rule(ResourceClusterScaleRule rule) {
                if (this.rules == null) {
                    this.rules = new ArrayList();
                }
                this.rules.add(rule);
                return this;
            }

            public CreateAllResourceClusterScaleRulesRequestBuilder rules(Collection<? extends ResourceClusterScaleRule> rules) {
                if (rules == null) {
                    throw new NullPointerException("rules cannot be null");
                }
                if (this.rules == null) {
                    this.rules = new ArrayList();
                }
                this.rules.addAll(rules);
                return this;
            }

            public CreateAllResourceClusterScaleRulesRequestBuilder clearRules() {
                if (this.rules != null) {
                    this.rules.clear();
                }
                return this;
            }

            public CreateAllResourceClusterScaleRulesRequest build() {
                List<ResourceClusterScaleRule> rules;
                switch (this.rules == null ? 0 : this.rules.size()) {
                    case 0: {
                        rules = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        rules = Collections.singletonList(this.rules.get(0));
                        break;
                    }
                    default: {
                        rules = Collections.unmodifiableList(new ArrayList<ResourceClusterScaleRule>(this.rules));
                    }
                }
                return new CreateAllResourceClusterScaleRulesRequest(this.clusterId, rules);
            }

            public String toString() {
                return "ResourceClusterScaleRuleProto.CreateAllResourceClusterScaleRulesRequest.CreateAllResourceClusterScaleRulesRequestBuilder(clusterId=" + this.clusterId + ", rules=" + this.rules + ")";
            }
        }
    }

    public static final class CreateResourceClusterScaleRuleRequest {
        private final ClusterID clusterId;
        private final ResourceClusterScaleRule rule;

        @ConstructorProperties(value={"clusterId", "rule"})
        CreateResourceClusterScaleRuleRequest(ClusterID clusterId, ResourceClusterScaleRule rule) {
            this.clusterId = clusterId;
            this.rule = rule;
        }

        public static CreateResourceClusterScaleRuleRequestBuilder builder() {
            return new CreateResourceClusterScaleRuleRequestBuilder();
        }

        public ClusterID getClusterId() {
            return this.clusterId;
        }

        public ResourceClusterScaleRule getRule() {
            return this.rule;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateResourceClusterScaleRuleRequest)) {
                return false;
            }
            CreateResourceClusterScaleRuleRequest other = (CreateResourceClusterScaleRuleRequest)o;
            ClusterID this$clusterId = this.getClusterId();
            ClusterID other$clusterId = other.getClusterId();
            if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
                return false;
            }
            ResourceClusterScaleRule this$rule = this.getRule();
            ResourceClusterScaleRule other$rule = other.getRule();
            return !(this$rule == null ? other$rule != null : !((Object)this$rule).equals(other$rule));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterId = this.getClusterId();
            result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
            ResourceClusterScaleRule $rule = this.getRule();
            result = result * 59 + ($rule == null ? 43 : ((Object)$rule).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScaleRuleProto.CreateResourceClusterScaleRuleRequest(clusterId=" + this.getClusterId() + ", rule=" + this.getRule() + ")";
        }

        public static class CreateResourceClusterScaleRuleRequestBuilder {
            private ClusterID clusterId;
            private ResourceClusterScaleRule rule;

            CreateResourceClusterScaleRuleRequestBuilder() {
            }

            public CreateResourceClusterScaleRuleRequestBuilder clusterId(ClusterID clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public CreateResourceClusterScaleRuleRequestBuilder rule(ResourceClusterScaleRule rule) {
                this.rule = rule;
                return this;
            }

            public CreateResourceClusterScaleRuleRequest build() {
                return new CreateResourceClusterScaleRuleRequest(this.clusterId, this.rule);
            }

            public String toString() {
                return "ResourceClusterScaleRuleProto.CreateResourceClusterScaleRuleRequest.CreateResourceClusterScaleRuleRequestBuilder(clusterId=" + this.clusterId + ", rule=" + this.rule + ")";
            }
        }
    }

    public static final class GetResourceClusterScaleRulesResponse
    extends BaseResponse {
        private final ClusterID clusterId;
        private final List<ResourceClusterScaleRule> rules;

        @JsonCreator
        public GetResourceClusterScaleRulesResponse(@JsonProperty(value="requestId") long requestId, @JsonProperty(value="responseCode") BaseResponse.ResponseCode responseCode, @JsonProperty(value="message") String message, @JsonProperty(value="clusterId") ClusterID clusterId, @JsonProperty(value="rules") List<ResourceClusterScaleRule> rules) {
            super(requestId, responseCode, message);
            this.rules = rules;
            this.clusterId = clusterId;
        }

        public static GetResourceClusterScaleRulesResponseBuilder builder() {
            return new GetResourceClusterScaleRulesResponseBuilder();
        }

        public ClusterID getClusterId() {
            return this.clusterId;
        }

        public List<ResourceClusterScaleRule> getRules() {
            return this.rules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetResourceClusterScaleRulesResponse)) {
                return false;
            }
            GetResourceClusterScaleRulesResponse other = (GetResourceClusterScaleRulesResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClusterID this$clusterId = this.getClusterId();
            ClusterID other$clusterId = other.getClusterId();
            if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
                return false;
            }
            List<ResourceClusterScaleRule> this$rules = this.getRules();
            List<ResourceClusterScaleRule> other$rules = other.getRules();
            return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GetResourceClusterScaleRulesResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterId = this.getClusterId();
            result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
            List<ResourceClusterScaleRule> $rules = this.getRules();
            result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse(clusterId=" + this.getClusterId() + ", rules=" + this.getRules() + ")";
        }

        public static class GetResourceClusterScaleRulesResponseBuilder {
            private long requestId;
            private BaseResponse.ResponseCode responseCode;
            private String message;
            private ClusterID clusterId;
            private List<ResourceClusterScaleRule> rules;

            GetResourceClusterScaleRulesResponseBuilder() {
            }

            public GetResourceClusterScaleRulesResponseBuilder requestId(long requestId) {
                this.requestId = requestId;
                return this;
            }

            public GetResourceClusterScaleRulesResponseBuilder responseCode(BaseResponse.ResponseCode responseCode) {
                this.responseCode = responseCode;
                return this;
            }

            public GetResourceClusterScaleRulesResponseBuilder message(String message) {
                this.message = message;
                return this;
            }

            public GetResourceClusterScaleRulesResponseBuilder clusterId(ClusterID clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public GetResourceClusterScaleRulesResponseBuilder rules(List<ResourceClusterScaleRule> rules) {
                this.rules = rules;
                return this;
            }

            public GetResourceClusterScaleRulesResponse build() {
                return new GetResourceClusterScaleRulesResponse(this.requestId, this.responseCode, this.message, this.clusterId, this.rules);
            }

            public String toString() {
                return "ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesResponse.GetResourceClusterScaleRulesResponseBuilder(requestId=" + this.requestId + ", responseCode=" + (Object)((Object)this.responseCode) + ", message=" + this.message + ", clusterId=" + this.clusterId + ", rules=" + this.rules + ")";
            }
        }
    }

    public static final class GetResourceClusterScaleRulesRequest {
        private final ClusterID clusterId;

        @ConstructorProperties(value={"clusterId"})
        GetResourceClusterScaleRulesRequest(ClusterID clusterId) {
            this.clusterId = clusterId;
        }

        public static GetResourceClusterScaleRulesRequestBuilder builder() {
            return new GetResourceClusterScaleRulesRequestBuilder();
        }

        public ClusterID getClusterId() {
            return this.clusterId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetResourceClusterScaleRulesRequest)) {
                return false;
            }
            GetResourceClusterScaleRulesRequest other = (GetResourceClusterScaleRulesRequest)o;
            ClusterID this$clusterId = this.getClusterId();
            ClusterID other$clusterId = other.getClusterId();
            return !(this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterId = this.getClusterId();
            result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesRequest(clusterId=" + this.getClusterId() + ")";
        }

        public static class GetResourceClusterScaleRulesRequestBuilder {
            private ClusterID clusterId;

            GetResourceClusterScaleRulesRequestBuilder() {
            }

            public GetResourceClusterScaleRulesRequestBuilder clusterId(ClusterID clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public GetResourceClusterScaleRulesRequest build() {
                return new GetResourceClusterScaleRulesRequest(this.clusterId);
            }

            public String toString() {
                return "ResourceClusterScaleRuleProto.GetResourceClusterScaleRulesRequest.GetResourceClusterScaleRulesRequestBuilder(clusterId=" + this.clusterId + ")";
            }
        }
    }
}

