/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.resourceprovider;

import akka.actor.ActorSystem;
import io.mantisrx.master.resourcecluster.proto.ProvisionResourceClusterRequest;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterProvisionSubmissionResponse;
import io.mantisrx.master.resourcecluster.proto.ScaleResourceRequest;
import io.mantisrx.master.resourcecluster.proto.ScaleResourceResponse;
import io.mantisrx.master.resourcecluster.proto.UpgradeClusterContainersResponse;
import io.mantisrx.master.resourcecluster.resourceprovider.ResourceClusterProvider;
import io.mantisrx.master.resourcecluster.resourceprovider.ResourceClusterProviderUpgradeRequest;
import io.mantisrx.master.resourcecluster.resourceprovider.ResourceClusterResponseHandler;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClusterProviderAdapter
implements ResourceClusterProvider {
    private static final Logger log = LoggerFactory.getLogger(ResourceClusterProviderAdapter.class);
    private final ResourceClusterProvider providerImpl;

    public ResourceClusterProviderAdapter(String providerClassStr, ActorSystem system) {
        boolean fallBackToEmptyCtor = false;
        ResourceClusterProvider provider = null;
        try {
            provider = (ResourceClusterProvider)Class.forName(providerClassStr).getConstructor(ActorSystem.class).newInstance(system);
        }
        catch (NoSuchMethodException ex) {
            log.warn("Could not find ctor with actorSystem param: {}", (Object)providerClassStr);
            fallBackToEmptyCtor = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create ResourceClusterProvider from " + providerClassStr, e);
        }
        if (fallBackToEmptyCtor) {
            try {
                log.info("Building ResourceClusterProvider with empty ctor: {}", (Object)providerClassStr);
                provider = (ResourceClusterProvider)Class.forName(providerClassStr).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create ResourceClusterProvider from " + providerClassStr, e);
            }
        }
        this.providerImpl = provider;
    }

    @Override
    public CompletionStage<ResourceClusterProvisionSubmissionResponse> provisionClusterIfNotPresent(ProvisionResourceClusterRequest clusterSpec) {
        return this.providerImpl.provisionClusterIfNotPresent(clusterSpec);
    }

    @Override
    public CompletionStage<ScaleResourceResponse> scaleResource(ScaleResourceRequest scaleRequest) {
        return this.providerImpl.scaleResource(scaleRequest);
    }

    @Override
    public CompletionStage<UpgradeClusterContainersResponse> upgradeContainerResource(ResourceClusterProviderUpgradeRequest request) {
        return this.providerImpl.upgradeContainerResource(request);
    }

    @Override
    public ResourceClusterResponseHandler getResponseHandler() {
        return this.providerImpl.getResponseHandler();
    }
}

