/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.writable;

import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RegisteredResourceClustersWritable {
    private final Map<String, ClusterRegistration> clusters;

    @JsonCreator
    public RegisteredResourceClustersWritable(@JsonProperty(value="clusters") Map<String, ClusterRegistration> clusters) {
        this.clusters = clusters;
    }

    public static RegisteredResourceClustersWritableBuilder builder() {
        return new RegisteredResourceClustersWritableBuilder();
    }

    public RegisteredResourceClustersWritableBuilder toBuilder() {
        RegisteredResourceClustersWritableBuilder builder = new RegisteredResourceClustersWritableBuilder();
        if (this.clusters != null) {
            builder.clusters(this.clusters);
        }
        return builder;
    }

    public Map<String, ClusterRegistration> getClusters() {
        return this.clusters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredResourceClustersWritable)) {
            return false;
        }
        RegisteredResourceClustersWritable other = (RegisteredResourceClustersWritable)o;
        Map<String, ClusterRegistration> this$clusters = this.getClusters();
        Map<String, ClusterRegistration> other$clusters = other.getClusters();
        return !(this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ClusterRegistration> $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        return result;
    }

    public String toString() {
        return "RegisteredResourceClustersWritable(clusters=" + this.getClusters() + ")";
    }

    public static class RegisteredResourceClustersWritableBuilder {
        private ArrayList<String> clusters$key;
        private ArrayList<ClusterRegistration> clusters$value;

        RegisteredResourceClustersWritableBuilder() {
        }

        public RegisteredResourceClustersWritableBuilder cluster(String clusterKey, ClusterRegistration clusterValue) {
            if (this.clusters$key == null) {
                this.clusters$key = new ArrayList();
                this.clusters$value = new ArrayList();
            }
            this.clusters$key.add(clusterKey);
            this.clusters$value.add(clusterValue);
            return this;
        }

        public RegisteredResourceClustersWritableBuilder clusters(Map<? extends String, ? extends ClusterRegistration> clusters) {
            if (clusters == null) {
                throw new NullPointerException("clusters cannot be null");
            }
            if (this.clusters$key == null) {
                this.clusters$key = new ArrayList();
                this.clusters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends ClusterRegistration> $lombokEntry : clusters.entrySet()) {
                this.clusters$key.add($lombokEntry.getKey());
                this.clusters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RegisteredResourceClustersWritableBuilder clearClusters() {
            if (this.clusters$key != null) {
                this.clusters$key.clear();
                this.clusters$value.clear();
            }
            return this;
        }

        public RegisteredResourceClustersWritable build() {
            Map<String, ClusterRegistration> clusters;
            switch (this.clusters$key == null ? 0 : this.clusters$key.size()) {
                case 0: {
                    clusters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    clusters = Collections.singletonMap(this.clusters$key.get(0), this.clusters$value.get(0));
                    break;
                }
                default: {
                    clusters = new LinkedHashMap<String, ClusterRegistration>(this.clusters$key.size() < 0x40000000 ? 1 + this.clusters$key.size() + (this.clusters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.clusters$key.size(); ++$i) {
                        clusters.put(this.clusters$key.get($i), this.clusters$value.get($i));
                    }
                    clusters = Collections.unmodifiableMap(clusters);
                }
            }
            return new RegisteredResourceClustersWritable(clusters);
        }

        public String toString() {
            return "RegisteredResourceClustersWritable.RegisteredResourceClustersWritableBuilder(clusters$key=" + this.clusters$key + ", clusters$value=" + this.clusters$value + ")";
        }
    }

    public static final class ClusterRegistration {
        private final ClusterID clusterId;
        private final String version;

        @JsonCreator
        public ClusterRegistration(@JsonProperty(value="clusterId") ClusterID clusterId, @JsonProperty(value="version") String version) {
            this.clusterId = clusterId;
            this.version = version;
        }

        public static ClusterRegistrationBuilder builder() {
            return new ClusterRegistrationBuilder();
        }

        public ClusterID getClusterId() {
            return this.clusterId;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterRegistration)) {
                return false;
            }
            ClusterRegistration other = (ClusterRegistration)o;
            ClusterID this$clusterId = this.getClusterId();
            ClusterID other$clusterId = other.getClusterId();
            if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClusterID $clusterId = this.getClusterId();
            result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "RegisteredResourceClustersWritable.ClusterRegistration(clusterId=" + this.getClusterId() + ", version=" + this.getVersion() + ")";
        }

        public static class ClusterRegistrationBuilder {
            private ClusterID clusterId;
            private String version;

            ClusterRegistrationBuilder() {
            }

            public ClusterRegistrationBuilder clusterId(ClusterID clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            public ClusterRegistrationBuilder version(String version) {
                this.version = version;
                return this;
            }

            public ClusterRegistration build() {
                return new ClusterRegistration(this.clusterId, this.version);
            }

            public String toString() {
                return "RegisteredResourceClustersWritable.ClusterRegistration.ClusterRegistrationBuilder(clusterId=" + this.clusterId + ", version=" + this.version + ")";
            }
        }
    }
}

