/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.resourcecluster.writable;

import io.mantisrx.master.resourcecluster.proto.ResourceClusterScaleSpec;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ResourceClusterScaleRulesWritable {
    private final ClusterID clusterId;
    private final String version;
    private final Map<String, ResourceClusterScaleSpec> scaleRules;

    @JsonCreator
    public ResourceClusterScaleRulesWritable(@JsonProperty(value="clusterId") ClusterID clusterId, @JsonProperty(value="version") String version, @JsonProperty(value="rules") Map<String, ResourceClusterScaleSpec> scaleRules) {
        this.clusterId = clusterId;
        this.version = version;
        this.scaleRules = scaleRules;
    }

    public static ResourceClusterScaleRulesWritableBuilder builder() {
        return new ResourceClusterScaleRulesWritableBuilder();
    }

    public ResourceClusterScaleRulesWritableBuilder toBuilder() {
        ResourceClusterScaleRulesWritableBuilder builder = new ResourceClusterScaleRulesWritableBuilder().clusterId(this.clusterId).version(this.version);
        if (this.scaleRules != null) {
            builder.scaleRules(this.scaleRules);
        }
        return builder;
    }

    public ClusterID getClusterId() {
        return this.clusterId;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, ResourceClusterScaleSpec> getScaleRules() {
        return this.scaleRules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceClusterScaleRulesWritable)) {
            return false;
        }
        ResourceClusterScaleRulesWritable other = (ResourceClusterScaleRulesWritable)o;
        ClusterID this$clusterId = this.getClusterId();
        ClusterID other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, ResourceClusterScaleSpec> this$scaleRules = this.getScaleRules();
        Map<String, ResourceClusterScaleSpec> other$scaleRules = other.getScaleRules();
        return !(this$scaleRules == null ? other$scaleRules != null : !((Object)this$scaleRules).equals(other$scaleRules));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClusterID $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, ResourceClusterScaleSpec> $scaleRules = this.getScaleRules();
        result = result * 59 + ($scaleRules == null ? 43 : ((Object)$scaleRules).hashCode());
        return result;
    }

    public String toString() {
        return "ResourceClusterScaleRulesWritable(clusterId=" + this.getClusterId() + ", version=" + this.getVersion() + ", scaleRules=" + this.getScaleRules() + ")";
    }

    public static class ResourceClusterScaleRulesWritableBuilder {
        private ClusterID clusterId;
        private String version;
        private ArrayList<String> scaleRules$key;
        private ArrayList<ResourceClusterScaleSpec> scaleRules$value;

        ResourceClusterScaleRulesWritableBuilder() {
        }

        public ResourceClusterScaleRulesWritableBuilder clusterId(ClusterID clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public ResourceClusterScaleRulesWritableBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ResourceClusterScaleRulesWritableBuilder scaleRule(String scaleRuleKey, ResourceClusterScaleSpec scaleRuleValue) {
            if (this.scaleRules$key == null) {
                this.scaleRules$key = new ArrayList();
                this.scaleRules$value = new ArrayList();
            }
            this.scaleRules$key.add(scaleRuleKey);
            this.scaleRules$value.add(scaleRuleValue);
            return this;
        }

        public ResourceClusterScaleRulesWritableBuilder scaleRules(Map<? extends String, ? extends ResourceClusterScaleSpec> scaleRules) {
            if (scaleRules == null) {
                throw new NullPointerException("scaleRules cannot be null");
            }
            if (this.scaleRules$key == null) {
                this.scaleRules$key = new ArrayList();
                this.scaleRules$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends ResourceClusterScaleSpec> $lombokEntry : scaleRules.entrySet()) {
                this.scaleRules$key.add($lombokEntry.getKey());
                this.scaleRules$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ResourceClusterScaleRulesWritableBuilder clearScaleRules() {
            if (this.scaleRules$key != null) {
                this.scaleRules$key.clear();
                this.scaleRules$value.clear();
            }
            return this;
        }

        public ResourceClusterScaleRulesWritable build() {
            Map<String, ResourceClusterScaleSpec> scaleRules;
            switch (this.scaleRules$key == null ? 0 : this.scaleRules$key.size()) {
                case 0: {
                    scaleRules = Collections.emptyMap();
                    break;
                }
                case 1: {
                    scaleRules = Collections.singletonMap(this.scaleRules$key.get(0), this.scaleRules$value.get(0));
                    break;
                }
                default: {
                    scaleRules = new LinkedHashMap(this.scaleRules$key.size() < 0x40000000 ? 1 + this.scaleRules$key.size() + (this.scaleRules$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.scaleRules$key.size(); ++$i) {
                        scaleRules.put(this.scaleRules$key.get($i), this.scaleRules$value.get($i));
                    }
                    scaleRules = Collections.unmodifiableMap(scaleRules);
                }
            }
            return new ResourceClusterScaleRulesWritable(this.clusterId, this.version, scaleRules);
        }

        public String toString() {
            return "ResourceClusterScaleRulesWritable.ResourceClusterScaleRulesWritableBuilder(clusterId=" + this.clusterId + ", version=" + this.version + ", scaleRules$key=" + this.scaleRules$key + ", scaleRules$value=" + this.scaleRules$value + ")";
        }
    }
}

