/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.master.utils;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class CaffeineMetrics
implements StatsCounter {
    private final Counter hitCount;
    private final Counter missCount;
    private final Counter loadSuccessCount;
    private final Counter loadFailureCount;
    private final Gauge totalLoadTime;
    private final Counter evictionCount;
    private final Counter evictionWeight;

    public CaffeineMetrics(String metricGroup) {
        Objects.requireNonNull(metricGroup);
        Metrics m = new Metrics.Builder().id("CaffeineMetrics_" + metricGroup, new Tag[0]).addCounter("hits").addCounter("misses").addGauge("loadTimeMillis").addCounter("loadsSuccess").addCounter("loadsFailure").addCounter("evictions").addCounter("evictionsWeight").build();
        Metrics metrics = MetricsRegistry.getInstance().registerAndGet(m);
        this.hitCount = metrics.getCounter("hits");
        this.missCount = metrics.getCounter("misses");
        this.totalLoadTime = metrics.getGauge("loadTimeMillis");
        this.loadSuccessCount = metrics.getCounter("loadsSuccess");
        this.loadFailureCount = metrics.getCounter("loadsFailure");
        this.evictionCount = metrics.getCounter("evictions");
        this.evictionWeight = metrics.getCounter("evictionsWeight");
    }

    public void recordHits(int count) {
        this.hitCount.increment((long)count);
    }

    public void recordMisses(int count) {
        this.missCount.increment((long)count);
    }

    public void recordLoadSuccess(long loadTime) {
        this.loadSuccessCount.increment();
        this.totalLoadTime.set(TimeUnit.MILLISECONDS.convert(loadTime, TimeUnit.NANOSECONDS));
    }

    public void recordLoadFailure(long loadTime) {
        this.loadFailureCount.increment();
        this.totalLoadTime.set(TimeUnit.MILLISECONDS.convert(loadTime, TimeUnit.NANOSECONDS));
    }

    public void recordEviction() {
        this.recordEviction(1);
    }

    public void recordEviction(int weight) {
        this.evictionCount.increment();
        this.evictionWeight.increment((long)weight);
    }

    public CacheStats snapshot() {
        return new CacheStats(this.hitCount.value(), this.missCount.value(), this.loadSuccessCount.value(), this.loadFailureCount.value(), this.totalLoadTime.value(), this.evictionCount.value(), this.evictionWeight.value());
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

