/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import akka.http.javadsl.model.StatusCodes;
import akka.http.javadsl.model.Uri;
import akka.http.javadsl.server.AllDirectives;
import akka.http.javadsl.server.Route;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.server.master.ILeadershipManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderRedirectionFilter
extends AllDirectives {
    public static final Logger logger = LoggerFactory.getLogger(LeaderRedirectionFilter.class);
    private final MasterMonitor masterMonitor;
    private final ILeadershipManager leadershipManager;
    private final Counter api503MasterNotReady;
    private final Counter apiRedirectsToLeader;

    public LeaderRedirectionFilter(MasterMonitor masterMonitor, ILeadershipManager leadershipManager) {
        this.masterMonitor = masterMonitor;
        this.leadershipManager = leadershipManager;
        Metrics m = new Metrics.Builder().id("LeaderRedirectionFilter", new Tag[0]).addCounter("api503MasterNotReady").addCounter("apiRedirectsToLeader").build();
        this.api503MasterNotReady = m.getCounter("api503MasterNotReady");
        this.apiRedirectsToLeader = m.getCounter("apiRedirectsToLeader");
    }

    private boolean isLocalHost(MasterDescription master) {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            for (InetAddress addr : InetAddress.getAllByName(master.getHostname())) {
                if (!addr.equals(localHost)) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
        return false;
    }

    public Route redirectIfNotLeader(Route leaderRoute) {
        MasterDescription latestMaster = this.masterMonitor.getLatestMaster();
        if (this.leadershipManager.isLeader() || this.isLocalHost(latestMaster)) {
            if (this.leadershipManager.isReady()) {
                return leaderRoute;
            }
            return this.extractUri(uri -> {
                logger.info("leader is not ready, returning 503 for {}", uri);
                this.api503MasterNotReady.increment();
                return this.complete(StatusCodes.SERVICE_UNAVAILABLE, "Mantis master awaiting to be ready");
            });
        }
        String hostname = latestMaster.getHostname();
        int apiPort = latestMaster.getApiPort();
        return this.extractUri(uri -> {
            Uri redirectUri = uri.host(hostname).port(apiPort);
            this.apiRedirectsToLeader.increment();
            logger.info("redirecting request {} to leader", (Object)redirectUri.toString());
            return this.redirect(redirectUri, StatusCodes.FOUND);
        });
    }

    public Route rejectIfNotLeader(Route leaderRoute) {
        MasterDescription latestMaster = this.masterMonitor.getLatestMaster();
        if (!this.leadershipManager.isLeader() && !this.isLocalHost(latestMaster)) {
            return this.extractUri(uri -> {
                logger.info("not leader, returning 500 for {}", uri);
                return this.complete(StatusCodes.INTERNAL_SERVER_ERROR, "this node is not leader");
            });
        }
        if (this.leadershipManager.isReady()) {
            return leaderRoute;
        }
        return this.extractUri(uri -> {
            logger.info("leader is not ready, returning 503 for {}", uri);
            this.api503MasterNotReady.increment();
            return this.complete(StatusCodes.SERVICE_UNAVAILABLE, "Mantis master awaiting to be ready");
        });
    }
}

