/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import io.mantisrx.server.master.MantisAuditLogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.observers.SerializedObserver;
import rx.schedulers.Schedulers;
import rx.subjects.PublishSubject;

public class MantisAuditLogWriter {
    private static final Logger logger = LoggerFactory.getLogger(MantisAuditLogWriter.class);
    private static MantisAuditLogWriter instance;
    private final PublishSubject<MantisAuditLogEvent> subject = PublishSubject.create();
    private final int backPressureBufferSize = 1000;

    private MantisAuditLogWriter(Subscriber<MantisAuditLogEvent> subscriber) {
        this.subject.onBackpressureBuffer(1000L, new Action0(){

            public void call() {
                logger.warn("Exceeded back pressure buffer of 1000");
            }
        }).observeOn(Schedulers.computation()).subscribe(subscriber);
    }

    public static void initialize(Subscriber<MantisAuditLogEvent> subscriber) {
        instance = new MantisAuditLogWriter(subscriber);
    }

    public static MantisAuditLogWriter getInstance() {
        if (instance == null) {
            throw new IllegalStateException(MantisAuditLogWriter.class.getName() + " must be initialized before use");
        }
        return instance;
    }

    public Observer<MantisAuditLogEvent> getObserver() {
        return new SerializedObserver(this.subject);
    }
}

