/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.DeadLetter;
import akka.actor.Props;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.spectator.SpectatorRegistryFactory;
import io.mantisrx.common.properties.DefaultMantisPropertiesLoader;
import io.mantisrx.common.properties.MantisPropertiesLoader;
import io.mantisrx.master.DeadLetterActor;
import io.mantisrx.master.JobClustersManagerActor;
import io.mantisrx.master.JobClustersManagerService;
import io.mantisrx.master.api.akka.MasterApiAkkaService;
import io.mantisrx.master.events.AuditEventBrokerActor;
import io.mantisrx.master.events.AuditEventSubscriber;
import io.mantisrx.master.events.AuditEventSubscriberAkkaImpl;
import io.mantisrx.master.events.AuditEventSubscriberLoggingImpl;
import io.mantisrx.master.events.LifecycleEventPublisherImpl;
import io.mantisrx.master.events.StatusEventBrokerActor;
import io.mantisrx.master.events.StatusEventSubscriberAkkaImpl;
import io.mantisrx.master.events.WorkerMetricsCollector;
import io.mantisrx.master.events.WorkerRegistryV2;
import io.mantisrx.master.resourcecluster.ResourceClustersAkkaImpl;
import io.mantisrx.master.resourcecluster.ResourceClustersHostManagerActor;
import io.mantisrx.master.resourcecluster.resourceprovider.ResourceClusterProviderAdapter;
import io.mantisrx.master.scheduler.JobMessageRouterImpl;
import io.mantisrx.master.zk.LeaderElector;
import io.mantisrx.server.core.BaseService;
import io.mantisrx.server.core.CoreConfiguration;
import io.mantisrx.server.core.MantisAkkaRpcSystemLoader;
import io.mantisrx.server.core.Service;
import io.mantisrx.server.core.json.DefaultObjectMapper;
import io.mantisrx.server.core.master.LocalMasterMonitor;
import io.mantisrx.server.core.master.MasterDescription;
import io.mantisrx.server.core.master.MasterMonitor;
import io.mantisrx.server.core.metrics.MetricsPublisherService;
import io.mantisrx.server.core.metrics.MetricsServerService;
import io.mantisrx.server.core.zookeeper.CuratorService;
import io.mantisrx.server.master.ExecuteStageRequestFactory;
import io.mantisrx.server.master.ILeadershipManager;
import io.mantisrx.server.master.LeadershipManagerZkImpl;
import io.mantisrx.server.master.ServiceLifecycle;
import io.mantisrx.server.master.config.ConfigurationFactory;
import io.mantisrx.server.master.config.ConfigurationProvider;
import io.mantisrx.server.master.config.MasterConfiguration;
import io.mantisrx.server.master.config.StaticPropertiesConfigurationFactory;
import io.mantisrx.server.master.persistence.IMantisPersistenceProvider;
import io.mantisrx.server.master.persistence.KeyValueBasedPersistenceProvider;
import io.mantisrx.server.master.persistence.MantisJobStore;
import io.mantisrx.server.master.resourcecluster.ResourceClusters;
import io.mantisrx.server.master.scheduler.MantisSchedulerFactoryImpl;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.org.apache.curator.utils.ZKPaths;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class MasterMain
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(MasterMain.class);
    @Argument(alias="p", description="Specify a configuration file", required=false)
    private static String propFile = "master.properties";
    private final ServiceLifecycle mantisServices = new ServiceLifecycle();
    private final AtomicBoolean shutdownInitiated = new AtomicBoolean(false);
    private KeyValueBasedPersistenceProvider storageProvider;
    private CountDownLatch blockUntilShutdown = new CountDownLatch(1);
    private volatile CuratorService curatorService = null;
    private MasterConfiguration config;
    private ILeadershipManager leadershipManager;
    private final MantisPropertiesLoader dynamicPropertiesLoader;

    public MasterMain(ConfigurationFactory configFactory, MantisPropertiesLoader dynamicPropertiesLoader, AuditEventSubscriber auditEventSubscriber) {
        this.dynamicPropertiesLoader = dynamicPropertiesLoader;
        String test = "{\"jobId\":\"sine-function-1\",\"status\":{\"jobId\":\"sine-function-1\",\"stageNum\":1,\"workerIndex\":0,\"workerNumber\":2,\"type\":\"HEARTBEAT\",\"message\":\"heartbeat\",\"state\":\"Noop\",\"hostname\":null,\"timestamp\":1525813363585,\"reason\":\"Normal\",\"payloads\":[{\"type\":\"SubscriptionState\",\"data\":\"false\"},{\"type\":\"IncomingDataDrop\",\"data\":\"{\\\"onNextCount\\\":0,\\\"droppedCount\\\":0}\"}]}}";
        Metrics metrics = new Metrics.Builder().id("MasterMain", new Tag[0]).addCounter("masterInitSuccess").addCounter("masterInitError").build();
        Metrics m = MetricsRegistry.getInstance().registerAndGet(metrics);
        try {
            ConfigurationProvider.initialize(configFactory);
            this.config = ConfigurationProvider.getConfig();
            this.leadershipManager = new LeadershipManagerZkImpl(this.config, this.mantisServices);
            Thread t = new Thread(() -> this.shutdown());
            t.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(t);
            ActorSystem system = ActorSystem.create((String)"MantisMaster");
            system.logConfiguration();
            ActorRef actor = system.actorOf(Props.create(DeadLetterActor.class, (Object[])new Object[0]), "MantisDeadLetter");
            system.eventStream().subscribe(actor, DeadLetter.class);
            ActorRef statusEventBrokerActor = system.actorOf(StatusEventBrokerActor.props(), "StatusEventBroker");
            ActorRef auditEventBrokerActor = system.actorOf(AuditEventBrokerActor.props(auditEventSubscriber), "AuditEventBroker");
            StatusEventSubscriberAkkaImpl statusEventSubscriber = new StatusEventSubscriberAkkaImpl(statusEventBrokerActor);
            AuditEventSubscriberAkkaImpl auditEventSubscriberAkka = new AuditEventSubscriberAkkaImpl(auditEventBrokerActor);
            WorkerRegistryV2 workerEventSubscriber = WorkerRegistryV2.INSTANCE;
            WorkerMetricsCollector workerMetricsCollector = new WorkerMetricsCollector(Duration.ofMinutes(5L), Duration.ofMinutes(1L), Clock.systemDefaultZone());
            this.mantisServices.addService(BaseService.wrap((io.mantisrx.shaded.com.google.common.util.concurrent.Service)workerMetricsCollector));
            LifecycleEventPublisherImpl lifecycleEventPublisher = new LifecycleEventPublisherImpl(auditEventSubscriberAkka, statusEventSubscriber, workerEventSubscriber.and(workerMetricsCollector));
            this.storageProvider = new KeyValueBasedPersistenceProvider(this.config.getStorageProvider(), lifecycleEventPublisher);
            MantisJobStore mantisJobStore = new MantisJobStore(this.storageProvider);
            ActorRef jobClusterManagerActor = system.actorOf(JobClustersManagerActor.props(mantisJobStore, lifecycleEventPublisher, this.config.getJobCostsCalculator()), "JobClustersManager");
            JobMessageRouterImpl jobMessageRouter = new JobMessageRouterImpl(jobClusterManagerActor);
            Configuration configuration = GlobalConfiguration.loadConfiguration();
            ActorRef resourceClustersHostActor = system.actorOf(ResourceClustersHostManagerActor.props(new ResourceClusterProviderAdapter(this.config.getResourceClusterProvider(), system), this.storageProvider), "ResourceClusterHostActor");
            RpcSystem rpcSystem = MantisAkkaRpcSystemLoader.getInstance();
            RpcService rpcService = RpcUtils.createRemoteRpcService((RpcSystem)rpcSystem, (Configuration)configuration, null, (String)"6123", null, Optional.empty());
            ResourceClusters resourceClusters = ResourceClustersAkkaImpl.load(configFactory, rpcService, system, mantisJobStore, jobMessageRouter, resourceClustersHostActor, this.storageProvider, this.dynamicPropertiesLoader);
            MantisSchedulerFactoryImpl mantisSchedulerFactory = new MantisSchedulerFactoryImpl(system, resourceClusters, new ExecuteStageRequestFactory(this.getConfig()), jobMessageRouter, this.getConfig(), MetricsRegistry.getInstance());
            boolean loadJobsFromStoreOnInit = true;
            JobClustersManagerService jobClustersManagerService = new JobClustersManagerService(jobClusterManagerActor, mantisSchedulerFactory, true);
            if (this.config.getMasterMetricsPort() > 0) {
                new MetricsServerService(this.config.getMasterMetricsPort(), 1, Collections.emptyMap()).start();
            }
            new MetricsPublisherService(this.config.getMetricsPublisher(), this.config.getMetricsPublisherFrequencyInSeconds(), new HashMap()).start();
            this.mantisServices.addService(jobClustersManagerService);
            if (this.config.isLocalMode()) {
                this.mantisServices.addService(new MasterApiAkkaService((MasterMonitor)new LocalMasterMonitor(this.leadershipManager.getDescription()), this.leadershipManager.getDescription(), jobClusterManagerActor, statusEventBrokerActor, resourceClusters, resourceClustersHostActor, this.config.getApiPort(), this.storageProvider, lifecycleEventPublisher, this.leadershipManager));
                this.leadershipManager.becomeLeader();
            } else {
                this.curatorService = new CuratorService((CoreConfiguration)this.config);
                this.curatorService.start();
                this.mantisServices.addService(this.createLeaderElector(this.curatorService, this.leadershipManager));
                this.mantisServices.addService(new MasterApiAkkaService(this.curatorService.getMasterMonitor(), this.leadershipManager.getDescription(), jobClusterManagerActor, statusEventBrokerActor, resourceClusters, resourceClustersHostActor, this.config.getApiPort(), this.storageProvider, lifecycleEventPublisher, this.leadershipManager));
            }
            m.getCounter("masterInitSuccess").increment();
        }
        catch (Exception e) {
            logger.error("caught exception on Mantis Master initialization", (Throwable)e);
            m.getCounter("masterInitError").increment();
            this.shutdown();
            System.exit(1);
        }
    }

    private static Properties loadProperties(String propFile) {
        Properties props = new Properties();
        try (InputStream in = MasterMain.findResourceAsStream(propFile);){
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Can't load properties from the given property file %s: %s", propFile, e.getMessage()), e);
        }
        for (String key : props.stringPropertyNames()) {
            String envVarKey = key.toUpperCase().replace('.', '_');
            String envValue = System.getenv(envVarKey);
            if (envValue == null) continue;
            props.setProperty(key, envValue);
            logger.info("Override config from env {}: {}.", (Object)key, (Object)envValue);
        }
        return props;
    }

    private static InputStream findResourceAsStream(String resourceName) throws FileNotFoundException {
        File resource = new File(resourceName);
        if (resource.exists()) {
            return new FileInputStream(resource);
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(String.format("Can't find property file %s. Make sure the property file is either in your path or in your classpath ", resourceName));
        }
        return is;
    }

    public static void main(String[] args) {
        try {
            Args.parse(MasterMain.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(MasterMain.class);
            System.exit(1);
        }
        try {
            SpectatorRegistryFactory.setRegistry((Registry)new DefaultRegistry());
            Properties props = new Properties();
            props.putAll(System.getenv());
            props.putAll((Map<?, ?>)System.getProperties());
            props.putAll((Map<?, ?>)MasterMain.loadProperties(propFile));
            StaticPropertiesConfigurationFactory factory = new StaticPropertiesConfigurationFactory(props);
            AuditEventSubscriberLoggingImpl auditEventSubscriber = new AuditEventSubscriberLoggingImpl();
            DefaultMantisPropertiesLoader propertiesLoader = new DefaultMantisPropertiesLoader(System.getProperties());
            MasterMain master = new MasterMain(factory, (MantisPropertiesLoader)propertiesLoader, auditEventSubscriber);
            master.start();
        }
        catch (Exception e) {
            logger.error("Unexpected error: " + e.getMessage(), (Throwable)e);
            System.exit(2);
        }
    }

    private LeaderElector createLeaderElector(CuratorService curatorService, ILeadershipManager leadershipManager) {
        return LeaderElector.builder(leadershipManager).withCurator(curatorService.getCurator()).withJsonMapper((ObjectMapper)DefaultObjectMapper.getInstance()).withElectionPath(ZKPaths.makePath((String)this.config.getZkRoot(), (String)this.config.getLeaderElectionPath())).withAnnouncementPath(ZKPaths.makePath((String)this.config.getZkRoot(), (String)this.config.getLeaderAnnouncementPath())).build();
    }

    public void start() {
        logger.info("Starting Mantis Master");
        this.mantisServices.start();
        try {
            this.blockUntilShutdown.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void enterActiveMode() {
    }

    public void shutdown() {
        if (this.shutdownInitiated.compareAndSet(false, true)) {
            logger.info("Shutting down Mantis Master");
            this.mantisServices.shutdown();
            logger.info("mantis services shutdown complete");
            boolean shutdownCuratorEnabled = ConfigurationProvider.getConfig().getShutdownCuratorServiceEnabled();
            if (this.curatorService != null && shutdownCuratorEnabled) {
                logger.info("Shutting down Curator Service");
                this.curatorService.shutdown();
            } else {
                logger.info("not shutting down curator service {} shutdownEnabled? {}", (Object)this.curatorService, (Object)shutdownCuratorEnabled);
            }
            this.blockUntilShutdown.countDown();
            logger.info("Mantis Master shutdown done");
        } else {
            logger.info("Shutdown already initiated, not starting again");
        }
    }

    public MasterConfiguration getConfig() {
        return this.config;
    }

    public String getDescriptionJson() {
        try {
            return DefaultObjectMapper.getInstance().writeValueAsString((Object)this.leadershipManager.getDescription());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(String.format("Failed to convert the description %s to JSON: %s", this.leadershipManager.getDescription(), e.getMessage()), e);
        }
    }

    public Observable<MasterDescription> getMasterObservable() {
        return this.curatorService == null ? Observable.empty() : this.curatorService.getMasterMonitor().getMasterObservable();
    }

    public boolean isLeader() {
        return this.leadershipManager.isLeader();
    }

    public IMantisPersistenceProvider getStorageProvider() {
        return this.storageProvider;
    }
}

