/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.agentdeploy;

import io.mantisrx.runtime.MigrationStrategy;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.server.master.agentdeploy.OneWorkerPerTickMigrationStrategy;
import io.mantisrx.server.master.agentdeploy.PercentageMigrationStrategy;
import io.mantisrx.server.master.utils.MantisSystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationStrategyFactory {
    private static final Logger logger = LoggerFactory.getLogger(MigrationStrategyFactory.class);

    public static MigrationStrategy getStrategy(String jobId, WorkerMigrationConfig config) {
        switch (config.getStrategy()) {
            case PERCENTAGE: {
                return new PercentageMigrationStrategy(MantisSystemClock.INSTANCE, jobId, config);
            }
            case ONE_WORKER: {
                return new OneWorkerPerTickMigrationStrategy(MantisSystemClock.INSTANCE, jobId, config);
            }
        }
        logger.error("unknown strategy type {} in config {}, using default strategy to migrate 25 percent every 1 min", (Object)config.getStrategy(), (Object)config);
        return new PercentageMigrationStrategy(MantisSystemClock.INSTANCE, jobId, new WorkerMigrationConfig(WorkerMigrationConfig.MigrationStrategyEnum.PERCENTAGE, "{\"percentToMove\":25,\"intervalMs\":60000}"));
    }
}

