/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.domain;

import io.mantisrx.common.Label;
import io.mantisrx.runtime.JobOwner;
import io.mantisrx.runtime.WorkerMigrationConfig;
import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.server.master.domain.Jar;
import io.mantisrx.server.master.domain.SLA;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.mantisrx.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class JobClusterMetadata {
    private final String name;
    private final List<Jar> jars;
    private final JobOwner owner;
    private final SLA sla;
    private final List<Parameter> parameters;
    private final boolean isReadyForJobMaster;
    private final boolean disabled;
    private final WorkerMigrationConfig migrationConfig;
    private final List<Label> labels;
    private final AtomicLong lastJobCount = new AtomicLong(0L);

    @JsonCreator
    @JsonIgnoreProperties(ignoreUnknown=true)
    public JobClusterMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="jars") List<Jar> jars, @JsonProperty(value="sla") SLA sla, @JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="owner") JobOwner owner, @JsonProperty(value="lastJobCount") long lastJobCount, @JsonProperty(value="disabled") boolean disabled, @JsonProperty(value="isReadyForJobMaster") boolean isReadyForJobMaster, @JsonProperty(value="migrationConfig") WorkerMigrationConfig migrationConfig, @JsonProperty(value="labels") List<Label> labels) {
        this.name = name;
        this.jars = Optional.ofNullable(jars).orElse(new ArrayList());
        this.sla = sla;
        this.parameters = Optional.ofNullable(parameters).orElse(new ArrayList());
        this.isReadyForJobMaster = isReadyForJobMaster;
        this.owner = owner;
        this.migrationConfig = migrationConfig;
        this.labels = labels;
        this.disabled = disabled;
        this.lastJobCount.set(lastJobCount);
    }

    public String getName() {
        return this.name;
    }

    public List<Jar> getJars() {
        return this.jars;
    }

    public JobOwner getOwner() {
        return this.owner;
    }

    public SLA getSla() {
        return this.sla;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean isReadyForJobMaster() {
        return this.isReadyForJobMaster;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public WorkerMigrationConfig getMigrationConfig() {
        return this.migrationConfig;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public AtomicLong getLastJobCount() {
        return this.lastJobCount;
    }
}

