/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.persistence;

import io.mantisrx.master.jobcluster.IJobClusterMetadata;
import io.mantisrx.master.jobcluster.job.IMantisJobMetadata;
import io.mantisrx.master.jobcluster.job.IMantisStageMetadata;
import io.mantisrx.master.jobcluster.job.worker.IMantisWorkerMetadata;
import io.mantisrx.master.resourcecluster.DisableTaskExecutorsRequest;
import io.mantisrx.master.resourcecluster.proto.ResourceClusterScaleSpec;
import io.mantisrx.master.resourcecluster.writable.RegisteredResourceClustersWritable;
import io.mantisrx.master.resourcecluster.writable.ResourceClusterScaleRulesWritable;
import io.mantisrx.master.resourcecluster.writable.ResourceClusterSpecWritable;
import io.mantisrx.server.core.domain.ArtifactID;
import io.mantisrx.server.core.domain.JobArtifact;
import io.mantisrx.server.master.domain.JobClusterDefinitionImpl;
import io.mantisrx.server.master.domain.JobId;
import io.mantisrx.server.master.persistence.exceptions.InvalidJobException;
import io.mantisrx.server.master.resourcecluster.ClusterID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import rx.Observable;

public interface IMantisPersistenceProvider {
    public void storeNewJob(IMantisJobMetadata var1) throws Exception;

    public void updateJob(IMantisJobMetadata var1) throws Exception;

    public void archiveJob(String var1) throws IOException;

    public void deleteJob(String var1) throws IOException;

    public void storeMantisStage(IMantisStageMetadata var1) throws IOException;

    public void updateMantisStage(IMantisStageMetadata var1) throws IOException;

    default public void storeWorker(IMantisWorkerMetadata workerMetadata) throws IOException {
        this.storeWorkers(Collections.singletonList(workerMetadata));
    }

    default public void storeWorkers(String jobId, List<IMantisWorkerMetadata> workers) throws IOException {
        this.storeWorkers(workers);
    }

    public void storeWorkers(List<IMantisWorkerMetadata> var1) throws IOException;

    public void storeAndUpdateWorkers(IMantisWorkerMetadata var1, IMantisWorkerMetadata var2) throws InvalidJobException, IOException, Exception;

    public void updateWorker(IMantisWorkerMetadata var1) throws IOException;

    public List<IMantisJobMetadata> loadAllJobs() throws IOException;

    public Observable<IMantisJobMetadata> loadAllArchivedJobs();

    public List<IJobClusterMetadata> loadAllJobClusters() throws IOException;

    public List<JobClusterDefinitionImpl.CompletedJob> loadLatestCompletedJobsForCluster(String var1, int var2, @Nullable JobId var3) throws IOException;

    public void archiveWorker(IMantisWorkerMetadata var1) throws IOException;

    public List<IMantisWorkerMetadata> getArchivedWorkers(String var1) throws IOException;

    public void createJobCluster(IJobClusterMetadata var1) throws Exception;

    public void updateJobCluster(IJobClusterMetadata var1) throws Exception;

    public void deleteJobCluster(String var1) throws Exception;

    public void storeCompletedJobForCluster(String var1, JobClusterDefinitionImpl.CompletedJob var2) throws IOException;

    public void deleteCompletedJobsForCluster(String var1) throws IOException;

    public Optional<IMantisJobMetadata> loadArchivedJob(String var1) throws IOException;

    public List<String> initActiveVmAttributeValuesList() throws IOException;

    public void setActiveVmAttributeValuesList(List<String> var1) throws IOException;

    public TaskExecutorRegistration getTaskExecutorFor(TaskExecutorID var1) throws IOException;

    public void storeNewTaskExecutor(TaskExecutorRegistration var1) throws IOException;

    public void storeNewDisableTaskExecutorRequest(DisableTaskExecutorsRequest var1) throws IOException;

    public void deleteExpiredDisableTaskExecutorRequest(DisableTaskExecutorsRequest var1) throws IOException;

    public List<DisableTaskExecutorsRequest> loadAllDisableTaskExecutorsRequests(ClusterID var1) throws IOException;

    public boolean isArtifactExists(String var1) throws IOException;

    public JobArtifact getArtifactById(String var1) throws IOException;

    public List<JobArtifact> listJobArtifacts(String var1, String var2) throws IOException;

    public void addNewJobArtifactsToCache(ClusterID var1, List<ArtifactID> var2) throws IOException;

    public void removeJobArtifactsToCache(ClusterID var1, List<ArtifactID> var2) throws IOException;

    public List<String> listJobArtifactsToCache(ClusterID var1) throws IOException;

    public List<String> listJobArtifactsByName(String var1, String var2) throws IOException;

    public void addNewJobArtifact(JobArtifact var1) throws IOException;

    public ResourceClusterSpecWritable registerAndUpdateClusterSpec(ResourceClusterSpecWritable var1) throws IOException;

    public RegisteredResourceClustersWritable deregisterCluster(ClusterID var1) throws IOException;

    public RegisteredResourceClustersWritable getRegisteredResourceClustersWritable() throws IOException;

    @Nullable
    public ResourceClusterSpecWritable getResourceClusterSpecWritable(ClusterID var1) throws IOException;

    public ResourceClusterScaleRulesWritable getResourceClusterScaleRules(ClusterID var1) throws IOException;

    public ResourceClusterScaleRulesWritable registerResourceClusterScaleRule(ResourceClusterScaleRulesWritable var1) throws IOException;

    public ResourceClusterScaleRulesWritable registerResourceClusterScaleRule(ResourceClusterScaleSpec var1) throws IOException;
}

