/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.scheduler;

import akka.actor.ActorRef;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.server.master.scheduler.BatchScheduleRequest;
import io.mantisrx.server.master.scheduler.MantisScheduler;
import io.mantisrx.server.master.scheduler.ResourceClusterAwareSchedulerActor;
import io.mantisrx.server.master.scheduler.ScheduleRequest;
import io.mantisrx.shaded.com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceClusterAwareScheduler
implements MantisScheduler {
    private static final Logger log = LoggerFactory.getLogger(ResourceClusterAwareScheduler.class);
    private final ActorRef schedulerActor;

    @Override
    public void scheduleWorkers(BatchScheduleRequest scheduleRequest) {
        this.schedulerActor.tell((Object)ResourceClusterAwareSchedulerActor.BatchScheduleRequestEvent.of(scheduleRequest), null);
    }

    @Override
    public void unscheduleJob(String jobId) {
        this.schedulerActor.tell((Object)ResourceClusterAwareSchedulerActor.CancelBatchRequestEvent.of(jobId), null);
    }

    @Override
    public void unscheduleWorker(WorkerId workerId, Optional<String> hostname) {
        throw new UnsupportedOperationException("This seems to be used only within the SchedulingService which is a MantisScheduler implementation itself; so it's not clear if this is needed or not");
    }

    @Override
    public void unscheduleAndTerminateWorker(WorkerId workerId, Optional<String> hostname) {
        this.schedulerActor.tell((Object)ResourceClusterAwareSchedulerActor.CancelRequestEvent.of(workerId), null);
    }

    @Override
    public void updateWorkerSchedulingReadyTime(WorkerId workerId, long when) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initializeRunningWorker(ScheduleRequest scheduleRequest, String hostname, String hostID) {
        log.info("initializeRunningWorker called for {} and {}", (Object)scheduleRequest, (Object)hostname);
        this.schedulerActor.tell((Object)new ResourceClusterAwareSchedulerActor.InitializeRunningWorkerRequestEvent(scheduleRequest, TaskExecutorID.of((String)hostID)), null);
    }

    @Override
    public void rescindOffer(String offerId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rescindOffers(String hostname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addOffers(List<VirtualMachineLease> offers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableVM(String hostname, long durationMillis) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enableVM(String hostname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<VirtualMachineCurrentState> getCurrentVMState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setActiveVmGroups(List<String> activeVmGroups) {
        log.info("Active VM Groups is {} as per this stack-trace {}", activeVmGroups, (Object)Throwables.getStackTraceAsString((Throwable)new Throwable()));
    }

    @ConstructorProperties(value={"schedulerActor"})
    public ResourceClusterAwareScheduler(ActorRef schedulerActor) {
        this.schedulerActor = schedulerActor;
    }
}

