/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.scheduler;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.Props;
import akka.actor.Status;
import akka.japi.pf.ReceiveBuilder;
import akka.pattern.Patterns;
import com.netflix.spectator.api.Tag;
import io.mantisrx.common.Ack;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.MetricsRegistry;
import io.mantisrx.common.metrics.Timer;
import io.mantisrx.server.core.domain.JobMetadata;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.core.scheduler.SchedulingConstraints;
import io.mantisrx.server.master.ExecuteStageRequestFactory;
import io.mantisrx.server.master.resourcecluster.ResourceCluster;
import io.mantisrx.server.master.resourcecluster.TaskExecutorAllocationRequest;
import io.mantisrx.server.master.resourcecluster.TaskExecutorID;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.server.master.scheduler.BatchScheduleRequest;
import io.mantisrx.server.master.scheduler.JobMessageRouter;
import io.mantisrx.server.master.scheduler.ScheduleRequest;
import io.mantisrx.server.master.scheduler.WorkerLaunchFailed;
import io.mantisrx.server.master.scheduler.WorkerLaunched;
import io.mantisrx.server.worker.TaskExecutorGateway;
import io.mantisrx.shaded.com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;

class ResourceClusterAwareSchedulerActor
extends AbstractActorWithTimers {
    private static final Logger log = LoggerFactory.getLogger(ResourceClusterAwareSchedulerActor.class);
    private final ResourceCluster resourceCluster;
    private final ExecuteStageRequestFactory executeStageRequestFactory;
    private final JobMessageRouter jobMessageRouter;
    private final int maxScheduleRetries;
    private final int maxCancelRetries;
    private final Duration intervalBetweenRetries;
    private final Timer schedulingLatency;
    private final Counter schedulingFailures;
    private final Counter batchSchedulingFailures;
    private final Counter connectionFailures;

    public static Props props(int maxScheduleRetries, int maxCancelRetries, Duration intervalBetweenRetries, ResourceCluster resourceCluster, ExecuteStageRequestFactory executeStageRequestFactory, JobMessageRouter jobMessageRouter, MetricsRegistry metricsRegistry) {
        return Props.create(ResourceClusterAwareSchedulerActor.class, (Object[])new Object[]{maxScheduleRetries, maxCancelRetries, intervalBetweenRetries, resourceCluster, executeStageRequestFactory, jobMessageRouter, metricsRegistry});
    }

    public ResourceClusterAwareSchedulerActor(int maxScheduleRetries, int maxCancelRetries, Duration intervalBetweenRetries, ResourceCluster resourceCluster, ExecuteStageRequestFactory executeStageRequestFactory, JobMessageRouter jobMessageRouter, MetricsRegistry metricsRegistry) {
        this.resourceCluster = resourceCluster;
        this.executeStageRequestFactory = executeStageRequestFactory;
        this.jobMessageRouter = jobMessageRouter;
        this.maxScheduleRetries = maxScheduleRetries;
        this.intervalBetweenRetries = intervalBetweenRetries;
        this.maxCancelRetries = maxCancelRetries;
        String metricsGroup = "ResourceClusterAwareSchedulerActor";
        Metrics metrics = new Metrics.Builder().id("ResourceClusterAwareSchedulerActor", new Tag[]{Tag.of((String)"resourceCluster", (String)resourceCluster.getName())}).addTimer("schedulingLatency").addCounter("batchSchedulingFailures").addCounter("schedulingFailures").addCounter("connectionFailures").build();
        metricsRegistry.registerAndGet(metrics);
        this.schedulingLatency = metrics.getTimer("schedulingLatency");
        this.schedulingFailures = metrics.getCounter("schedulingFailures");
        this.batchSchedulingFailures = metrics.getCounter("batchSchedulingFailures");
        this.connectionFailures = metrics.getCounter("connectionFailures");
    }

    public AbstractActor.Receive createReceive() {
        return ReceiveBuilder.create().match(BatchScheduleRequestEvent.class, this::onBatchScheduleRequestEvent).match(AssignedBatchScheduleRequestEvent.class, this::onAssignedBatchScheduleRequestEvent).match(FailedToBatchScheduleRequestEvent.class, this::onFailedToBatchScheduleRequestEvent).match(CancelBatchRequestEvent.class, this::onCancelBatchRequestEvent).match(ScheduleRequestEvent.class, this::onScheduleRequestEvent).match(InitializeRunningWorkerRequestEvent.class, this::onInitializeRunningWorkerRequest).match(CancelRequestEvent.class, this::onCancelRequestEvent).match(AssignedScheduleRequestEvent.class, this::onAssignedScheduleRequestEvent).match(FailedToScheduleRequestEvent.class, this::onFailedScheduleRequestEvent).match(SubmittedScheduleRequestEvent.class, this::onSubmittedScheduleRequestEvent).match(FailedToSubmitScheduleRequestEvent.class, this::onFailedToSubmitScheduleRequestEvent).match(RetryCancelRequestEvent.class, this::onRetryCancelRequestEvent).match(Noop.class, this::onNoop).match(Ack.class, ack -> log.debug("Received ack from {}", (Object)this.sender())).match(Status.Failure.class, failure -> log.error("Received failure from {}: {}", (Object)this.sender(), failure)).build();
    }

    private void onBatchScheduleRequestEvent(BatchScheduleRequestEvent event) {
        log.info("Received batch schedule request event: {}", (Object)event);
        if (event.getRequest().getScheduleRequests().size() == 1) {
            ScheduleRequestEvent scheduleRequestEvent = ScheduleRequestEvent.of(event);
            this.self().tell((Object)scheduleRequestEvent, this.self());
        } else {
            if (event.isRetry()) {
                log.info("Retrying Batch Schedule Request {}, attempt {}", (Object)event.getRequest(), (Object)event.getAttempt());
            }
            CompletionStage assignedFuture = ((CompletableFuture)this.resourceCluster.getTaskExecutorsFor(event.getTaskExecutorAllocationRequests()).thenApply(event::onAssignment)).exceptionally(event::onFailure);
            Patterns.pipe((CompletionStage)assignedFuture, (ExecutionContext)this.getContext().getDispatcher()).to(this.self());
        }
    }

    private void onAssignedBatchScheduleRequestEvent(AssignedBatchScheduleRequestEvent event) {
        event.getAllocations().forEach((key, value) -> {
            ScheduleRequest scheduleRequest = event.getScheduleRequestEvent().getAllocationRequestScheduleRequestMap().get(key);
            ScheduleRequestEvent scheduleRequestEvent = ScheduleRequestEvent.of(scheduleRequest, event.getScheduleRequestEvent().eventTime);
            AssignedScheduleRequestEvent assignedScheduleRequestEvent = new AssignedScheduleRequestEvent(scheduleRequestEvent, (TaskExecutorID)value);
            this.self().tell((Object)assignedScheduleRequestEvent, this.self());
        });
    }

    private void onFailedToBatchScheduleRequestEvent(FailedToBatchScheduleRequestEvent event) {
        this.batchSchedulingFailures.increment();
        if (event.getAttempt() >= this.maxScheduleRetries) {
            log.error("Failed to submit the batch request {} because of ", (Object)event.getScheduleRequestEvent(), (Object)event.getThrowable());
        } else {
            Duration timeout = Duration.ofMillis(this.intervalBetweenRetries.toMillis());
            log.error("Failed to submit the request {}; Retrying in {} because of ", new Object[]{event.getScheduleRequestEvent(), timeout, event.getThrowable()});
            this.getTimers().startSingleTimer((Object)this.getBatchSchedulingQueueKeyFor(event.getScheduleRequestEvent().getJobId()), (Object)event.onRetry(), timeout);
        }
    }

    private void onScheduleRequestEvent(ScheduleRequestEvent event) {
        if (event.isRetry()) {
            log.info("Retrying Schedule Request {}, attempt {}", (Object)event.getRequest(), (Object)event.getAttempt());
        }
        CompletionStage assignedFuture = ((CompletableFuture)this.resourceCluster.getTaskExecutorsFor(Collections.singleton(TaskExecutorAllocationRequest.of((WorkerId)event.getRequest().getWorkerId(), (SchedulingConstraints)event.getRequest().getSchedulingConstraints(), (JobMetadata)event.getRequest().getJobMetadata(), (int)event.getRequest().getStageNum()))).thenApply(allocation -> event.onAssignment((TaskExecutorID)allocation.values().stream().findFirst().get()))).exceptionally(event::onFailure);
        Patterns.pipe((CompletionStage)assignedFuture, (ExecutionContext)this.getContext().getDispatcher()).to(this.self());
    }

    private void onInitializeRunningWorkerRequest(InitializeRunningWorkerRequestEvent request) {
        this.resourceCluster.initializeTaskExecutor(request.getTaskExecutorID(), request.getScheduleRequest().getWorkerId());
    }

    private void onAssignedScheduleRequestEvent(AssignedScheduleRequestEvent event) {
        try {
            CompletableFuture gatewayFut = this.resourceCluster.getTaskExecutorGateway(event.getTaskExecutorID());
            TaskExecutorRegistration info = (TaskExecutorRegistration)this.resourceCluster.getTaskExecutorInfo(event.getTaskExecutorID()).join();
            if (gatewayFut != null && info != null) {
                CompletionStage ackFuture = ((CompletableFuture)gatewayFut.thenComposeAsync(gateway -> ((CompletableFuture)((CompletableFuture)gateway.submitTask(this.executeStageRequestFactory.of(event.getScheduleRequestEvent().getRequest(), info)).thenApply(dontCare -> new SubmittedScheduleRequestEvent(event.getScheduleRequestEvent(), event.getTaskExecutorID()))).exceptionally(throwable -> new FailedToSubmitScheduleRequestEvent(event.getScheduleRequestEvent(), event.getTaskExecutorID(), ExceptionUtils.stripCompletionException((Throwable)throwable)))).whenCompleteAsync((res, err) -> {
                    if (err == null) {
                        log.debug("[Submit Task] finish with {}", res);
                    } else {
                        log.error("[Submit Task] fail: {}", (Object)event.getTaskExecutorID(), err);
                    }
                }))).exceptionally(throwable -> event.getScheduleRequestEvent().onFailure((Throwable)throwable));
                Patterns.pipe((CompletionStage)ackFuture, (ExecutionContext)this.getContext().getDispatcher()).to(this.self());
            }
        }
        catch (Exception e) {
            log.warn("Failed to submit task with the task executor {}; Resubmitting the request", (Object)event.getTaskExecutorID(), (Object)e);
            this.self().tell((Object)event.getScheduleRequestEvent().onFailure(e), this.self());
        }
    }

    private void onFailedScheduleRequestEvent(FailedToScheduleRequestEvent event) {
        this.schedulingFailures.increment();
        if (event.getAttempt() >= this.maxScheduleRetries) {
            log.error("Failed to submit the request {} because of ", (Object)event.getScheduleRequestEvent(), (Object)event.getThrowable());
        } else {
            Duration timeout = Duration.ofMillis(Math.max(event.getScheduleRequestEvent().getRequest().getReadyAt() - Instant.now().toEpochMilli(), this.intervalBetweenRetries.toMillis()));
            log.error("Failed to submit the request {}; Retrying in {} because of ", new Object[]{event.getScheduleRequestEvent(), timeout, event.getThrowable()});
            this.getTimers().startSingleTimer((Object)this.getSchedulingQueueKeyFor(event.getScheduleRequestEvent().getRequest().getWorkerId()), (Object)event.onRetry(), timeout);
        }
    }

    private void onSubmittedScheduleRequestEvent(SubmittedScheduleRequestEvent event) {
        log.debug("[Submit Task]: receive SubmittedScheduleRequestEvent: {}", (Object)event);
        TaskExecutorID taskExecutorID = event.getTaskExecutorID();
        try {
            TaskExecutorRegistration info = (TaskExecutorRegistration)this.resourceCluster.getTaskExecutorInfo(taskExecutorID).join();
            boolean success = this.jobMessageRouter.routeWorkerEvent(new WorkerLaunched(event.getEvent().getRequest().getWorkerId(), event.getEvent().getRequest().getStageNum(), info.getHostname(), taskExecutorID.getResourceId(), Optional.ofNullable(info.getClusterID().getResourceID()), Optional.of(info.getClusterID()), info.getWorkerPorts()));
            Duration latency = Duration.between(event.getEvent().getEventTime(), Clock.systemDefaultZone().instant());
            this.schedulingLatency.record(latency.toNanos(), TimeUnit.NANOSECONDS);
            if (!success) {
                log.error("Routing message to jobMessageRouter was never expected to fail but it has failed to event {}", (Object)event);
            }
        }
        catch (Exception ex) {
            log.warn("Failed to route message due to error in getting TaskExecutor info: {}", (Object)taskExecutorID, (Object)ex);
        }
    }

    private void onFailedToSubmitScheduleRequestEvent(FailedToSubmitScheduleRequestEvent event) {
        log.error("Failed to submit schedule request event {}", (Object)event, (Object)event.getThrowable());
        this.jobMessageRouter.routeWorkerEvent(new WorkerLaunchFailed(event.getScheduleRequestEvent().getRequest().getWorkerId(), event.getScheduleRequestEvent().getRequest().getStageNum(), Throwables.getStackTraceAsString((Throwable)event.throwable)));
    }

    private void onCancelRequestEvent(CancelRequestEvent event) {
        try {
            log.info("onCancelRequestEvent {}", (Object)event);
            this.getTimers().cancel((Object)this.getSchedulingQueueKeyFor(event.getWorkerId()));
            TaskExecutorID taskExecutorID = (TaskExecutorID)this.resourceCluster.getTaskExecutorAssignedFor(event.getWorkerId()).join();
            CompletionStage cancelFuture = this.resourceCluster.getTaskExecutorGateway(taskExecutorID).thenComposeAsync(gateway -> ((CompletableFuture)gateway.cancelTask(event.getWorkerId()).thenApply(dontCare -> Noop.getInstance())).exceptionally(exception -> {
                Throwable actual = ExceptionUtils.stripCompletionException((Throwable)ExceptionUtils.stripExecutionException((Throwable)exception));
                if (actual instanceof TaskExecutorGateway.TaskNotFoundException) {
                    return Noop.getInstance();
                }
                return event.onFailure(actual);
            }));
            Patterns.pipe((CompletionStage)cancelFuture, (ExecutionContext)this.context().dispatcher()).to(this.self());
        }
        catch (Exception e) {
            Throwable throwable = ExceptionUtils.stripCompletionException((Throwable)ExceptionUtils.stripExecutionException((Throwable)e));
            if (!(throwable instanceof TaskExecutorGateway.TaskNotFoundException)) {
                this.self().tell((Object)event.onFailure(throwable), this.self());
            }
            log.info("Failed to cancel task {} as no matching executor could be found", (Object)event.getWorkerId());
        }
    }

    private void onRetryCancelRequestEvent(RetryCancelRequestEvent event) {
        if (event.getActualEvent().getAttempt() < this.maxCancelRetries) {
            this.context().system().scheduler().scheduleOnce(Duration.ofMinutes(1L), this.self(), (Object)event.onRetry(), (ExecutionContext)this.getContext().getDispatcher(), this.self());
        } else {
            log.error("Exhausted number of retries for cancel request {}", (Object)event.getActualEvent(), (Object)event.getCurrentFailure());
        }
    }

    private void onCancelBatchRequestEvent(CancelBatchRequestEvent event) {
        this.getTimers().cancel((Object)this.getBatchSchedulingQueueKeyFor(event.getJobId()));
    }

    private void onNoop(Noop event) {
    }

    private String getSchedulingQueueKeyFor(WorkerId workerId) {
        return "Retry-Schedule-Request-For" + workerId.toString();
    }

    private String getBatchSchedulingQueueKeyFor(String jobId) {
        return "Retry-Batch-Schedule-Request-For" + jobId;
    }

    private static final class Noop {
        private Noop() {
        }

        public static Noop getInstance() {
            return new Noop();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Noop;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.Noop()";
        }
    }

    private static final class RetryCancelRequestEvent {
        private final CancelRequestEvent actualEvent;
        private final Throwable currentFailure;

        CancelRequestEvent onRetry() {
            return new CancelRequestEvent(this.actualEvent.getWorkerId(), this.actualEvent.getAttempt() + 1, this.currentFailure);
        }

        @ConstructorProperties(value={"actualEvent", "currentFailure"})
        public RetryCancelRequestEvent(CancelRequestEvent actualEvent, Throwable currentFailure) {
            this.actualEvent = actualEvent;
            this.currentFailure = currentFailure;
        }

        public CancelRequestEvent getActualEvent() {
            return this.actualEvent;
        }

        public Throwable getCurrentFailure() {
            return this.currentFailure;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryCancelRequestEvent)) {
                return false;
            }
            RetryCancelRequestEvent other = (RetryCancelRequestEvent)o;
            CancelRequestEvent this$actualEvent = this.getActualEvent();
            CancelRequestEvent other$actualEvent = other.getActualEvent();
            if (this$actualEvent == null ? other$actualEvent != null : !((Object)this$actualEvent).equals(other$actualEvent)) {
                return false;
            }
            Throwable this$currentFailure = this.getCurrentFailure();
            Throwable other$currentFailure = other.getCurrentFailure();
            return !(this$currentFailure == null ? other$currentFailure != null : !this$currentFailure.equals(other$currentFailure));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CancelRequestEvent $actualEvent = this.getActualEvent();
            result = result * 59 + ($actualEvent == null ? 43 : ((Object)$actualEvent).hashCode());
            Throwable $currentFailure = this.getCurrentFailure();
            result = result * 59 + ($currentFailure == null ? 43 : $currentFailure.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.RetryCancelRequestEvent(actualEvent=" + this.getActualEvent() + ", currentFailure=" + this.getCurrentFailure() + ")";
        }
    }

    static final class CancelBatchRequestEvent {
        private final String jobId;

        static CancelBatchRequestEvent of(String jobId) {
            return new CancelBatchRequestEvent(jobId);
        }

        @ConstructorProperties(value={"jobId"})
        public CancelBatchRequestEvent(String jobId) {
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CancelBatchRequestEvent)) {
                return false;
            }
            CancelBatchRequestEvent other = (CancelBatchRequestEvent)o;
            String this$jobId = this.getJobId();
            String other$jobId = other.getJobId();
            return !(this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jobId = this.getJobId();
            result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.CancelBatchRequestEvent(jobId=" + this.getJobId() + ")";
        }
    }

    static final class CancelRequestEvent {
        private final WorkerId workerId;
        private final int attempt;
        private final Throwable previousFailure;

        static CancelRequestEvent of(WorkerId workerId) {
            return new CancelRequestEvent(workerId, 1, null);
        }

        RetryCancelRequestEvent onFailure(Throwable throwable) {
            return new RetryCancelRequestEvent(this, throwable);
        }

        @ConstructorProperties(value={"workerId", "attempt", "previousFailure"})
        public CancelRequestEvent(WorkerId workerId, int attempt, Throwable previousFailure) {
            this.workerId = workerId;
            this.attempt = attempt;
            this.previousFailure = previousFailure;
        }

        public WorkerId getWorkerId() {
            return this.workerId;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public Throwable getPreviousFailure() {
            return this.previousFailure;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CancelRequestEvent)) {
                return false;
            }
            CancelRequestEvent other = (CancelRequestEvent)o;
            if (this.getAttempt() != other.getAttempt()) {
                return false;
            }
            WorkerId this$workerId = this.getWorkerId();
            WorkerId other$workerId = other.getWorkerId();
            if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
                return false;
            }
            Throwable this$previousFailure = this.getPreviousFailure();
            Throwable other$previousFailure = other.getPreviousFailure();
            return !(this$previousFailure == null ? other$previousFailure != null : !this$previousFailure.equals(other$previousFailure));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAttempt();
            WorkerId $workerId = this.getWorkerId();
            result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
            Throwable $previousFailure = this.getPreviousFailure();
            result = result * 59 + ($previousFailure == null ? 43 : $previousFailure.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.CancelRequestEvent(workerId=" + this.getWorkerId() + ", attempt=" + this.getAttempt() + ", previousFailure=" + this.getPreviousFailure() + ")";
        }
    }

    private static final class FailedToSubmitScheduleRequestEvent {
        private final ScheduleRequestEvent scheduleRequestEvent;
        private final TaskExecutorID taskExecutorID;
        private final Throwable throwable;

        @ConstructorProperties(value={"scheduleRequestEvent", "taskExecutorID", "throwable"})
        public FailedToSubmitScheduleRequestEvent(ScheduleRequestEvent scheduleRequestEvent, TaskExecutorID taskExecutorID, Throwable throwable) {
            this.scheduleRequestEvent = scheduleRequestEvent;
            this.taskExecutorID = taskExecutorID;
            this.throwable = throwable;
        }

        public ScheduleRequestEvent getScheduleRequestEvent() {
            return this.scheduleRequestEvent;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedToSubmitScheduleRequestEvent)) {
                return false;
            }
            FailedToSubmitScheduleRequestEvent other = (FailedToSubmitScheduleRequestEvent)o;
            ScheduleRequestEvent this$scheduleRequestEvent = this.getScheduleRequestEvent();
            ScheduleRequestEvent other$scheduleRequestEvent = other.getScheduleRequestEvent();
            if (this$scheduleRequestEvent == null ? other$scheduleRequestEvent != null : !((Object)this$scheduleRequestEvent).equals(other$scheduleRequestEvent)) {
                return false;
            }
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            if (this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID)) {
                return false;
            }
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScheduleRequestEvent $scheduleRequestEvent = this.getScheduleRequestEvent();
            result = result * 59 + ($scheduleRequestEvent == null ? 43 : ((Object)$scheduleRequestEvent).hashCode());
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.FailedToSubmitScheduleRequestEvent(scheduleRequestEvent=" + this.getScheduleRequestEvent() + ", taskExecutorID=" + this.getTaskExecutorID() + ", throwable=" + this.getThrowable() + ")";
        }
    }

    private static final class SubmittedScheduleRequestEvent {
        private final ScheduleRequestEvent event;
        private final TaskExecutorID taskExecutorID;

        @ConstructorProperties(value={"event", "taskExecutorID"})
        public SubmittedScheduleRequestEvent(ScheduleRequestEvent event, TaskExecutorID taskExecutorID) {
            this.event = event;
            this.taskExecutorID = taskExecutorID;
        }

        public ScheduleRequestEvent getEvent() {
            return this.event;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubmittedScheduleRequestEvent)) {
                return false;
            }
            SubmittedScheduleRequestEvent other = (SubmittedScheduleRequestEvent)o;
            ScheduleRequestEvent this$event = this.getEvent();
            ScheduleRequestEvent other$event = other.getEvent();
            if (this$event == null ? other$event != null : !((Object)this$event).equals(other$event)) {
                return false;
            }
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            return !(this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScheduleRequestEvent $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.SubmittedScheduleRequestEvent(event=" + this.getEvent() + ", taskExecutorID=" + this.getTaskExecutorID() + ")";
        }
    }

    private static final class AssignedScheduleRequestEvent {
        private final ScheduleRequestEvent scheduleRequestEvent;
        private final TaskExecutorID taskExecutorID;

        @ConstructorProperties(value={"scheduleRequestEvent", "taskExecutorID"})
        public AssignedScheduleRequestEvent(ScheduleRequestEvent scheduleRequestEvent, TaskExecutorID taskExecutorID) {
            this.scheduleRequestEvent = scheduleRequestEvent;
            this.taskExecutorID = taskExecutorID;
        }

        public ScheduleRequestEvent getScheduleRequestEvent() {
            return this.scheduleRequestEvent;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignedScheduleRequestEvent)) {
                return false;
            }
            AssignedScheduleRequestEvent other = (AssignedScheduleRequestEvent)o;
            ScheduleRequestEvent this$scheduleRequestEvent = this.getScheduleRequestEvent();
            ScheduleRequestEvent other$scheduleRequestEvent = other.getScheduleRequestEvent();
            if (this$scheduleRequestEvent == null ? other$scheduleRequestEvent != null : !((Object)this$scheduleRequestEvent).equals(other$scheduleRequestEvent)) {
                return false;
            }
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            return !(this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScheduleRequestEvent $scheduleRequestEvent = this.getScheduleRequestEvent();
            result = result * 59 + ($scheduleRequestEvent == null ? 43 : ((Object)$scheduleRequestEvent).hashCode());
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.AssignedScheduleRequestEvent(scheduleRequestEvent=" + this.getScheduleRequestEvent() + ", taskExecutorID=" + this.getTaskExecutorID() + ")";
        }
    }

    private static final class FailedToBatchScheduleRequestEvent {
        private final BatchScheduleRequestEvent scheduleRequestEvent;
        private final int attempt;
        private final Throwable throwable;

        private BatchScheduleRequestEvent onRetry() {
            return new BatchScheduleRequestEvent(this.scheduleRequestEvent.getRequest(), this.attempt + 1, this.throwable, this.scheduleRequestEvent.getEventTime());
        }

        @ConstructorProperties(value={"scheduleRequestEvent", "attempt", "throwable"})
        public FailedToBatchScheduleRequestEvent(BatchScheduleRequestEvent scheduleRequestEvent, int attempt, Throwable throwable) {
            this.scheduleRequestEvent = scheduleRequestEvent;
            this.attempt = attempt;
            this.throwable = throwable;
        }

        public BatchScheduleRequestEvent getScheduleRequestEvent() {
            return this.scheduleRequestEvent;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedToBatchScheduleRequestEvent)) {
                return false;
            }
            FailedToBatchScheduleRequestEvent other = (FailedToBatchScheduleRequestEvent)o;
            if (this.getAttempt() != other.getAttempt()) {
                return false;
            }
            BatchScheduleRequestEvent this$scheduleRequestEvent = this.getScheduleRequestEvent();
            BatchScheduleRequestEvent other$scheduleRequestEvent = other.getScheduleRequestEvent();
            if (this$scheduleRequestEvent == null ? other$scheduleRequestEvent != null : !((Object)this$scheduleRequestEvent).equals(other$scheduleRequestEvent)) {
                return false;
            }
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAttempt();
            BatchScheduleRequestEvent $scheduleRequestEvent = this.getScheduleRequestEvent();
            result = result * 59 + ($scheduleRequestEvent == null ? 43 : ((Object)$scheduleRequestEvent).hashCode());
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.FailedToBatchScheduleRequestEvent(scheduleRequestEvent=" + this.getScheduleRequestEvent() + ", attempt=" + this.getAttempt() + ", throwable=" + this.getThrowable() + ")";
        }
    }

    private static final class AssignedBatchScheduleRequestEvent {
        private final BatchScheduleRequestEvent scheduleRequestEvent;
        private final Map<TaskExecutorAllocationRequest, TaskExecutorID> allocations;

        @ConstructorProperties(value={"scheduleRequestEvent", "allocations"})
        public AssignedBatchScheduleRequestEvent(BatchScheduleRequestEvent scheduleRequestEvent, Map<TaskExecutorAllocationRequest, TaskExecutorID> allocations) {
            this.scheduleRequestEvent = scheduleRequestEvent;
            this.allocations = allocations;
        }

        public BatchScheduleRequestEvent getScheduleRequestEvent() {
            return this.scheduleRequestEvent;
        }

        public Map<TaskExecutorAllocationRequest, TaskExecutorID> getAllocations() {
            return this.allocations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignedBatchScheduleRequestEvent)) {
                return false;
            }
            AssignedBatchScheduleRequestEvent other = (AssignedBatchScheduleRequestEvent)o;
            BatchScheduleRequestEvent this$scheduleRequestEvent = this.getScheduleRequestEvent();
            BatchScheduleRequestEvent other$scheduleRequestEvent = other.getScheduleRequestEvent();
            if (this$scheduleRequestEvent == null ? other$scheduleRequestEvent != null : !((Object)this$scheduleRequestEvent).equals(other$scheduleRequestEvent)) {
                return false;
            }
            Map<TaskExecutorAllocationRequest, TaskExecutorID> this$allocations = this.getAllocations();
            Map<TaskExecutorAllocationRequest, TaskExecutorID> other$allocations = other.getAllocations();
            return !(this$allocations == null ? other$allocations != null : !((Object)this$allocations).equals(other$allocations));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BatchScheduleRequestEvent $scheduleRequestEvent = this.getScheduleRequestEvent();
            result = result * 59 + ($scheduleRequestEvent == null ? 43 : ((Object)$scheduleRequestEvent).hashCode());
            Map<TaskExecutorAllocationRequest, TaskExecutorID> $allocations = this.getAllocations();
            result = result * 59 + ($allocations == null ? 43 : ((Object)$allocations).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.AssignedBatchScheduleRequestEvent(scheduleRequestEvent=" + this.getScheduleRequestEvent() + ", allocations=" + this.getAllocations() + ")";
        }
    }

    private static final class FailedToScheduleRequestEvent {
        private final ScheduleRequestEvent scheduleRequestEvent;
        private final int attempt;
        private final Throwable throwable;

        private ScheduleRequestEvent onRetry() {
            return new ScheduleRequestEvent(this.scheduleRequestEvent.getRequest(), this.attempt + 1, this.throwable, this.scheduleRequestEvent.getEventTime());
        }

        @ConstructorProperties(value={"scheduleRequestEvent", "attempt", "throwable"})
        public FailedToScheduleRequestEvent(ScheduleRequestEvent scheduleRequestEvent, int attempt, Throwable throwable) {
            this.scheduleRequestEvent = scheduleRequestEvent;
            this.attempt = attempt;
            this.throwable = throwable;
        }

        public ScheduleRequestEvent getScheduleRequestEvent() {
            return this.scheduleRequestEvent;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedToScheduleRequestEvent)) {
                return false;
            }
            FailedToScheduleRequestEvent other = (FailedToScheduleRequestEvent)o;
            if (this.getAttempt() != other.getAttempt()) {
                return false;
            }
            ScheduleRequestEvent this$scheduleRequestEvent = this.getScheduleRequestEvent();
            ScheduleRequestEvent other$scheduleRequestEvent = other.getScheduleRequestEvent();
            if (this$scheduleRequestEvent == null ? other$scheduleRequestEvent != null : !((Object)this$scheduleRequestEvent).equals(other$scheduleRequestEvent)) {
                return false;
            }
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAttempt();
            ScheduleRequestEvent $scheduleRequestEvent = this.getScheduleRequestEvent();
            result = result * 59 + ($scheduleRequestEvent == null ? 43 : ((Object)$scheduleRequestEvent).hashCode());
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.FailedToScheduleRequestEvent(scheduleRequestEvent=" + this.getScheduleRequestEvent() + ", attempt=" + this.getAttempt() + ", throwable=" + this.getThrowable() + ")";
        }
    }

    static final class InitializeRunningWorkerRequestEvent {
        private final ScheduleRequest scheduleRequest;
        private final TaskExecutorID taskExecutorID;

        @ConstructorProperties(value={"scheduleRequest", "taskExecutorID"})
        public InitializeRunningWorkerRequestEvent(ScheduleRequest scheduleRequest, TaskExecutorID taskExecutorID) {
            this.scheduleRequest = scheduleRequest;
            this.taskExecutorID = taskExecutorID;
        }

        public ScheduleRequest getScheduleRequest() {
            return this.scheduleRequest;
        }

        public TaskExecutorID getTaskExecutorID() {
            return this.taskExecutorID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitializeRunningWorkerRequestEvent)) {
                return false;
            }
            InitializeRunningWorkerRequestEvent other = (InitializeRunningWorkerRequestEvent)o;
            ScheduleRequest this$scheduleRequest = this.getScheduleRequest();
            ScheduleRequest other$scheduleRequest = other.getScheduleRequest();
            if (this$scheduleRequest == null ? other$scheduleRequest != null : !((Object)this$scheduleRequest).equals(other$scheduleRequest)) {
                return false;
            }
            TaskExecutorID this$taskExecutorID = this.getTaskExecutorID();
            TaskExecutorID other$taskExecutorID = other.getTaskExecutorID();
            return !(this$taskExecutorID == null ? other$taskExecutorID != null : !this$taskExecutorID.equals(other$taskExecutorID));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScheduleRequest $scheduleRequest = this.getScheduleRequest();
            result = result * 59 + ($scheduleRequest == null ? 43 : ((Object)$scheduleRequest).hashCode());
            TaskExecutorID $taskExecutorID = this.getTaskExecutorID();
            result = result * 59 + ($taskExecutorID == null ? 43 : $taskExecutorID.hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.InitializeRunningWorkerRequestEvent(scheduleRequest=" + this.getScheduleRequest() + ", taskExecutorID=" + this.getTaskExecutorID() + ")";
        }
    }

    static final class ScheduleRequestEvent {
        private final ScheduleRequest request;
        private final int attempt;
        @Nullable
        private final Throwable previousFailure;
        private final Instant eventTime;

        boolean isRetry() {
            return this.attempt > 1;
        }

        static ScheduleRequestEvent of(BatchScheduleRequestEvent request) {
            return new ScheduleRequestEvent(request.getRequest().getScheduleRequests().get(0), 1, null, Clock.systemDefaultZone().instant());
        }

        static ScheduleRequestEvent of(ScheduleRequest request, Instant eventTime) {
            return new ScheduleRequestEvent(request, 1, null, eventTime);
        }

        FailedToScheduleRequestEvent onFailure(Throwable throwable) {
            return new FailedToScheduleRequestEvent(this, this.attempt, ExceptionUtils.stripCompletionException((Throwable)throwable));
        }

        AssignedScheduleRequestEvent onAssignment(TaskExecutorID taskExecutorID) {
            return new AssignedScheduleRequestEvent(this, taskExecutorID);
        }

        @ConstructorProperties(value={"request", "attempt", "previousFailure", "eventTime"})
        public ScheduleRequestEvent(ScheduleRequest request, int attempt, @Nullable Throwable previousFailure, Instant eventTime) {
            this.request = request;
            this.attempt = attempt;
            this.previousFailure = previousFailure;
            this.eventTime = eventTime;
        }

        public ScheduleRequest getRequest() {
            return this.request;
        }

        public int getAttempt() {
            return this.attempt;
        }

        @Nullable
        public Throwable getPreviousFailure() {
            return this.previousFailure;
        }

        public Instant getEventTime() {
            return this.eventTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScheduleRequestEvent)) {
                return false;
            }
            ScheduleRequestEvent other = (ScheduleRequestEvent)o;
            if (this.getAttempt() != other.getAttempt()) {
                return false;
            }
            ScheduleRequest this$request = this.getRequest();
            ScheduleRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            Throwable this$previousFailure = this.getPreviousFailure();
            Throwable other$previousFailure = other.getPreviousFailure();
            if (this$previousFailure == null ? other$previousFailure != null : !this$previousFailure.equals(other$previousFailure)) {
                return false;
            }
            Instant this$eventTime = this.getEventTime();
            Instant other$eventTime = other.getEventTime();
            return !(this$eventTime == null ? other$eventTime != null : !((Object)this$eventTime).equals(other$eventTime));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAttempt();
            ScheduleRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            Throwable $previousFailure = this.getPreviousFailure();
            result = result * 59 + ($previousFailure == null ? 43 : $previousFailure.hashCode());
            Instant $eventTime = this.getEventTime();
            result = result * 59 + ($eventTime == null ? 43 : ((Object)$eventTime).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.ScheduleRequestEvent(request=" + this.getRequest() + ", attempt=" + this.getAttempt() + ", previousFailure=" + this.getPreviousFailure() + ", eventTime=" + this.getEventTime() + ")";
        }
    }

    static final class BatchScheduleRequestEvent {
        private final BatchScheduleRequest request;
        private final int attempt;
        @Nullable
        private final Throwable previousFailure;
        private final Instant eventTime;
        private final Map<TaskExecutorAllocationRequest, ScheduleRequest> allocationRequestScheduleRequestMap;

        BatchScheduleRequestEvent(BatchScheduleRequest request, int attempt, Throwable previousFailure, Instant eventTime) {
            this.request = request;
            this.attempt = attempt;
            this.previousFailure = previousFailure;
            this.eventTime = eventTime;
            this.allocationRequestScheduleRequestMap = request.getScheduleRequests().stream().map(req -> Pair.of((Object)req, (Object)TaskExecutorAllocationRequest.of((WorkerId)req.getWorkerId(), (SchedulingConstraints)req.getSchedulingConstraints(), (JobMetadata)req.getJobMetadata(), (int)req.getStageNum()))).collect(Collectors.toMap(Pair::getRight, Pair::getLeft));
        }

        boolean isRetry() {
            return this.attempt > 1;
        }

        static BatchScheduleRequestEvent of(BatchScheduleRequest request) {
            return new BatchScheduleRequestEvent(request, 1, null, Clock.systemDefaultZone().instant());
        }

        AssignedBatchScheduleRequestEvent onAssignment(Map<TaskExecutorAllocationRequest, TaskExecutorID> allocations) {
            return new AssignedBatchScheduleRequestEvent(this, allocations);
        }

        FailedToBatchScheduleRequestEvent onFailure(Throwable throwable) {
            return new FailedToBatchScheduleRequestEvent(this, this.attempt, throwable);
        }

        Set<TaskExecutorAllocationRequest> getTaskExecutorAllocationRequests() {
            return this.allocationRequestScheduleRequestMap.keySet();
        }

        String getJobId() {
            return this.request.getScheduleRequests().get(0).getJobMetadata().getJobId();
        }

        public BatchScheduleRequest getRequest() {
            return this.request;
        }

        public int getAttempt() {
            return this.attempt;
        }

        @Nullable
        public Throwable getPreviousFailure() {
            return this.previousFailure;
        }

        public Instant getEventTime() {
            return this.eventTime;
        }

        public Map<TaskExecutorAllocationRequest, ScheduleRequest> getAllocationRequestScheduleRequestMap() {
            return this.allocationRequestScheduleRequestMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchScheduleRequestEvent)) {
                return false;
            }
            BatchScheduleRequestEvent other = (BatchScheduleRequestEvent)o;
            if (this.getAttempt() != other.getAttempt()) {
                return false;
            }
            BatchScheduleRequest this$request = this.getRequest();
            BatchScheduleRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            Throwable this$previousFailure = this.getPreviousFailure();
            Throwable other$previousFailure = other.getPreviousFailure();
            if (this$previousFailure == null ? other$previousFailure != null : !this$previousFailure.equals(other$previousFailure)) {
                return false;
            }
            Instant this$eventTime = this.getEventTime();
            Instant other$eventTime = other.getEventTime();
            if (this$eventTime == null ? other$eventTime != null : !((Object)this$eventTime).equals(other$eventTime)) {
                return false;
            }
            Map<TaskExecutorAllocationRequest, ScheduleRequest> this$allocationRequestScheduleRequestMap = this.getAllocationRequestScheduleRequestMap();
            Map<TaskExecutorAllocationRequest, ScheduleRequest> other$allocationRequestScheduleRequestMap = other.getAllocationRequestScheduleRequestMap();
            return !(this$allocationRequestScheduleRequestMap == null ? other$allocationRequestScheduleRequestMap != null : !((Object)this$allocationRequestScheduleRequestMap).equals(other$allocationRequestScheduleRequestMap));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAttempt();
            BatchScheduleRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            Throwable $previousFailure = this.getPreviousFailure();
            result = result * 59 + ($previousFailure == null ? 43 : $previousFailure.hashCode());
            Instant $eventTime = this.getEventTime();
            result = result * 59 + ($eventTime == null ? 43 : ((Object)$eventTime).hashCode());
            Map<TaskExecutorAllocationRequest, ScheduleRequest> $allocationRequestScheduleRequestMap = this.getAllocationRequestScheduleRequestMap();
            result = result * 59 + ($allocationRequestScheduleRequestMap == null ? 43 : ((Object)$allocationRequestScheduleRequestMap).hashCode());
            return result;
        }

        public String toString() {
            return "ResourceClusterAwareSchedulerActor.BatchScheduleRequestEvent(request=" + this.getRequest() + ", attempt=" + this.getAttempt() + ", previousFailure=" + this.getPreviousFailure() + ", eventTime=" + this.getEventTime() + ", allocationRequestScheduleRequestMap=" + this.getAllocationRequestScheduleRequestMap() + ")";
        }
    }
}

