/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.master.scheduler;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.MantisJobDurationType;
import io.mantisrx.server.core.domain.JobMetadata;
import io.mantisrx.server.core.domain.WorkerId;
import io.mantisrx.server.core.scheduler.SchedulingConstraints;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ScheduleRequest
implements QueuableTask {
    public static final QAttributes DEFAULT_Q_ATTRIBUTES = new QAttributes(){

        public String getBucketName() {
            return "default";
        }

        public int getTierNumber() {
            return 0;
        }
    };
    private static final String defaultGrpName = "defaultGrp";
    private final WorkerId workerId;
    private final int stageNum;
    private final int numPortsRequested;
    private final JobMetadata jobMetadata;
    private final MantisJobDurationType durationType;
    private final SchedulingConstraints schedulingConstraints;
    private final List<ConstraintEvaluator> hardConstraints;
    private final List<VMTaskFitnessCalculator> softConstraints;
    private final Optional<String> preferredCluster;
    private volatile long readyAt;

    public ScheduleRequest(WorkerId workerId, int stageNum, int numPortsRequested, JobMetadata jobMetadata, MantisJobDurationType durationType, SchedulingConstraints schedulingConstraints, List<ConstraintEvaluator> hardConstraints, List<VMTaskFitnessCalculator> softConstraints, long readyAt, Optional<String> preferredCluster) {
        this.workerId = workerId;
        this.stageNum = stageNum;
        this.numPortsRequested = numPortsRequested;
        this.jobMetadata = jobMetadata;
        this.durationType = durationType;
        this.schedulingConstraints = schedulingConstraints;
        this.hardConstraints = hardConstraints;
        this.softConstraints = softConstraints;
        this.readyAt = readyAt;
        this.preferredCluster = preferredCluster;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleRequest that = (ScheduleRequest)o;
        return this.workerId != null ? this.workerId.equals((Object)that.workerId) : that.workerId == null;
    }

    public int hashCode() {
        return this.workerId != null ? this.workerId.hashCode() : 0;
    }

    public String getId() {
        return this.workerId.getId();
    }

    public WorkerId getWorkerId() {
        return this.workerId;
    }

    public String taskGroupName() {
        return defaultGrpName;
    }

    public double getCPUs() {
        return this.schedulingConstraints.getMachineDefinition().getCpuCores();
    }

    public double getMemory() {
        return this.schedulingConstraints.getMachineDefinition().getMemoryMB();
    }

    public double getNetworkMbps() {
        return this.schedulingConstraints.getMachineDefinition().getNetworkMbps();
    }

    public double getDisk() {
        return this.schedulingConstraints.getMachineDefinition().getDiskMB();
    }

    public int getPorts() {
        return this.numPortsRequested;
    }

    public JobMetadata getJobMetadata() {
        return this.jobMetadata;
    }

    public MachineDefinition getMachineDefinition() {
        return this.schedulingConstraints.getMachineDefinition();
    }

    public SchedulingConstraints getSchedulingConstraints() {
        return this.schedulingConstraints;
    }

    public Map<String, Double> getScalarRequests() {
        return Collections.emptyMap();
    }

    public Map<String, TaskRequest.NamedResourceSetRequest> getCustomNamedResources() {
        return Collections.emptyMap();
    }

    public List<ConstraintEvaluator> getHardConstraints() {
        return this.hardConstraints;
    }

    public List<VMTaskFitnessCalculator> getSoftConstraints() {
        return this.softConstraints;
    }

    public TaskRequest.AssignedResources getAssignedResources() {
        return null;
    }

    public void setAssignedResources(TaskRequest.AssignedResources assignedResources) {
    }

    public MantisJobDurationType getDurationType() {
        return this.durationType;
    }

    public int getStageNum() {
        return this.stageNum;
    }

    public QAttributes getQAttributes() {
        return DEFAULT_Q_ATTRIBUTES;
    }

    public long getReadyAt() {
        return this.readyAt;
    }

    public void safeSetReadyAt(long when) {
        this.readyAt = when;
    }

    public Optional<String> getPreferredCluster() {
        return this.preferredCluster;
    }

    public String toString() {
        return "ScheduleRequest{workerId=" + this.workerId + ", readyAt=" + this.readyAt + '}';
    }
}

